/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import java.awt.Color;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class SetFillColorTag
extends BaseGraphicsTag {
    public static final String TAG_NAME = "set-fill-color";
    private static final AttributeDefinition FILL_COLOR = CommonAttributes.COLOR.cloneAttrDef("The fill color to set.").setRequired(true);

    public SetFillColorTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the current fill color for the surrounding graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FILL_COLOR);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        Color color = this.getColorAttribute(CommonAttributes.COLOR, true, null);
        this.graphicsTag.setFillColor(color);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

