/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class SetLineCapTag
extends BaseGraphicsTag {
    protected static final AttributeDefinition LINE_CAP = new AttributeDefinition("line-cap", new String[]{"butt", "round", "projecting-square"}, true, "The line cap to set.");
    public static final String TAG_NAME = "set-line-cap";

    public SetLineCapTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the current line dash for the surrounding graphics area.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(LINE_CAP);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String strLineCap = this.getStringAttribute(LINE_CAP, "butt", true, null).toLowerCase();
        int lineCap = 0;
        if ("butt".equals(strLineCap)) {
            lineCap = 0;
        } else if ("round".equals(strLineCap)) {
            lineCap = 1;
        } else if ("projecting-square".equals(strLineCap)) {
            lineCap = 2;
        }
        this.graphicsTag.setLineCap(lineCap);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

