/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util;

import java.util.Comparator;
import org.ujac.util.BeanException;
import org.ujac.util.BeanUtils;
import org.ujac.util.CompareTuple;

public class BeanComparator
implements Comparator {
    private CompareTuple[] compareTuples = null;

    public BeanComparator(String fieldName) {
        this.compareTuples = new CompareTuple[]{new CompareTuple(fieldName)};
    }

    public BeanComparator(CompareTuple compareTuple) {
        this.compareTuples = new CompareTuple[]{compareTuple};
    }

    public BeanComparator(String[] fieldNames) {
        if (fieldNames != null) {
            this.compareTuples = new CompareTuple[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                this.compareTuples[i] = new CompareTuple(fieldNames[i]);
            }
        }
    }

    public BeanComparator(CompareTuple[] compareTuples) {
        this.compareTuples = compareTuples;
    }

    public int compare(Object o1, Object o2) {
        Comparable c1 = null;
        Comparable c2 = null;
        CompareTuple[] compareTuples = this.compareTuples;
        if (compareTuples != null) {
            for (int i = 0; i < compareTuples.length; ++i) {
                CompareTuple compareTuple = compareTuples[i];
                String fieldName = compareTuple.getFieldName();
                try {
                    c1 = (Comparable)BeanUtils.getProperty(o1, fieldName);
                    c2 = (Comparable)BeanUtils.getProperty(o2, fieldName);
                }
                catch (BeanException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                int result = c1.compareTo(c2);
                if (result == 0) continue;
                if (compareTuple.getDirection() == 2) {
                    return result * -1;
                }
                return result;
            }
            return 0;
        }
        c1 = (Comparable)o1;
        c2 = (Comparable)o2;
        return c1.compareTo(c2);
    }
}

