/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final Date today() {
        Calendar cal = Calendar.getInstance();
        cal.set(14, cal.getActualMinimum(14));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(11, cal.getActualMinimum(11));
        return cal.getTime();
    }

    public static final Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.set(14, cal.getActualMinimum(14));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(11, cal.getActualMinimum(11));
        cal.add(5, -1);
        return cal.getTime();
    }

    public static final Date now() {
        return DateUtils.now(13);
    }

    public static final Date now(int precision) {
        Calendar cal = Calendar.getInstance();
        if (precision == 14) {
            return cal.getTime();
        }
        cal.set(14, cal.getActualMinimum(14));
        if (precision == 13) {
            return cal.getTime();
        }
        cal.set(13, cal.getActualMinimum(13));
        if (precision == 12) {
            return cal.getTime();
        }
        cal.set(12, cal.getActualMinimum(12));
        if (precision == 10 || precision == 11) {
            return cal.getTime();
        }
        cal.set(11, cal.getActualMinimum(11));
        return cal.getTime();
    }

    public static final Calendar createCalendar(int year, int month, int day) {
        Calendar cal = DateUtils.createCalendar(5);
        DateUtils.setYear(cal, year);
        DateUtils.setMonth(cal, month);
        DateUtils.setDay(cal, day);
        return cal;
    }

    public static final Calendar createCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = DateUtils.createCalendar(13);
        DateUtils.setYear(cal, year);
        DateUtils.setMonth(cal, month);
        DateUtils.setDay(cal, day);
        DateUtils.setHour(cal, hour);
        DateUtils.setMinute(cal, minute);
        DateUtils.setSecond(cal, second);
        return cal;
    }

    public static final Calendar createCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar cal = DateUtils.createCalendar(14);
        DateUtils.setYear(cal, year);
        DateUtils.setMonth(cal, month);
        DateUtils.setDay(cal, day);
        DateUtils.setHour(cal, hour);
        DateUtils.setMinute(cal, minute);
        DateUtils.setSecond(cal, second);
        DateUtils.setMillisecond(cal, millisecond);
        return cal;
    }

    public static final Calendar createCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal;
    }

    public static final Calendar createCalendar(int precision) {
        return DateUtils.createCalendar(null, precision);
    }

    public static final Calendar createCalendar(Date date, int precision) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        if (precision == 14) {
            return cal;
        }
        cal.set(14, cal.getActualMinimum(14));
        if (precision == 13) {
            return cal;
        }
        cal.set(13, cal.getActualMinimum(13));
        if (precision == 12) {
            return cal;
        }
        cal.set(12, cal.getActualMinimum(12));
        if (precision == 10 || precision == 11) {
            return cal;
        }
        cal.set(11, cal.getActualMinimum(11));
        return cal;
    }

    public static final Date createDate(int year, int month, int day) {
        Calendar cal = DateUtils.createCalendar(year, month, day);
        return cal.getTime();
    }

    public static final Date createDate(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = DateUtils.createCalendar(year, month, day, hour, minute, second);
        return cal.getTime();
    }

    public static final Date createDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar cal = DateUtils.createCalendar(year, month, day, hour, minute, second, millisecond);
        return cal.getTime();
    }

    public static final int getDay(Calendar cal) {
        return cal.get(5);
    }

    public static final int getDay(Date date) {
        return DateUtils.getDay(DateUtils.createCalendar(date));
    }

    public static final void setDay(Calendar cal, int day) {
        int min = cal.getActualMinimum(5);
        int max = cal.getActualMaximum(5);
        if (day < min || day > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            throw new RuntimeException("Encountered illegal day value " + day + " for the date " + df.format(cal.getTime()));
        }
        cal.set(5, day);
    }

    public static final Date setDay(Date date, int day) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setDay(cal, day);
        return cal.getTime();
    }

    public static final void incrDay(Calendar cal, int days) {
        cal.add(5, days);
    }

    public static final Date incrDay(Date date, int days) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrDay(cal, days);
        return cal.getTime();
    }

    public static final int getMonth(Calendar cal) {
        return cal.get(2) + 1;
    }

    public static final int getMonth(Date date) {
        return DateUtils.getMonth(DateUtils.createCalendar(date));
    }

    public static final void setMonth(Calendar cal, int month) {
        int calMonth = month - 1;
        int min = cal.getActualMinimum(2);
        int max = cal.getActualMaximum(2);
        if (calMonth < min || calMonth > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            throw new RuntimeException("Encountered illegal month value " + month + " for the date " + df.format(cal.getTime()));
        }
        Date prevDate = cal.getTime();
        cal.set(2, calMonth);
        if (cal.get(2) != calMonth) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            throw new RuntimeException("Failed to set month value " + month + " for the date " + df.format(prevDate));
        }
    }

    public static final Date setMonth(Date date, int month) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setMonth(cal, month);
        return cal.getTime();
    }

    public static final void incrMonth(Calendar cal, int months) {
        cal.add(2, months);
    }

    public static final Date incrMonth(Date date, int months) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrMonth(cal, months);
        return cal.getTime();
    }

    public static final int getYear(Calendar cal) {
        return cal.get(1);
    }

    public static final int getYear(Date date) {
        return DateUtils.getYear(DateUtils.createCalendar(date));
    }

    public static final void setYear(Calendar cal, int year) {
        int min = cal.getActualMinimum(1);
        int max = cal.getActualMaximum(1);
        if (year < min || year > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            throw new RuntimeException("Encountered illegal year value " + year + " for the date " + df.format(cal.getTime()));
        }
        cal.set(1, year);
    }

    public static final Date setYear(Date date, int year) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setYear(cal, year);
        return cal.getTime();
    }

    public static final void incrYear(Calendar cal, int years) {
        cal.add(1, years);
    }

    public static final Date incrYear(Date date, int year) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrYear(cal, year);
        return cal.getTime();
    }

    public static final int getHour(Calendar cal) {
        return cal.get(11);
    }

    public static final int getHour(Date date) {
        Calendar cal = DateUtils.createCalendar(date);
        return DateUtils.getHour(cal);
    }

    public static final void setHour(Calendar cal, int hour) {
        int min = cal.getActualMinimum(11);
        int max = cal.getActualMaximum(11);
        if (hour < min || hour > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new RuntimeException("Encountered illegal hour value " + hour + " for the date " + df.format(cal.getTime()));
        }
        cal.set(11, hour);
    }

    public static final Date setHour(Date date, int hour) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setHour(cal, hour);
        return cal.getTime();
    }

    public static final void incrHour(Calendar cal, int hours) {
        cal.add(11, hours);
    }

    public static final Date incrHour(Date date, int hours) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrHour(cal, hours);
        return cal.getTime();
    }

    public static final int getMinute(Calendar cal) {
        return cal.get(12);
    }

    public static final int getMinute(Date date) {
        Calendar cal = DateUtils.createCalendar(date);
        return DateUtils.getMinute(cal);
    }

    public static final void setMinute(Calendar cal, int minute) {
        int min = cal.getActualMinimum(12);
        int max = cal.getActualMaximum(12);
        if (minute < min || minute > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new RuntimeException("Encountered illegal minute value " + minute + " for the date " + df.format(cal.getTime()));
        }
        cal.set(12, minute);
    }

    public static final Date setMinute(Date date, int minute) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setMinute(cal, minute);
        return cal.getTime();
    }

    public static final void incrMinute(Calendar cal, int minutes) {
        cal.add(12, minutes);
    }

    public static final Date incrMinute(Date date, int minutes) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrMinute(cal, minutes);
        return cal.getTime();
    }

    public static final int getSecond(Calendar cal) {
        return cal.get(13);
    }

    public static final int getSecond(Date date) {
        Calendar cal = DateUtils.createCalendar(date);
        return DateUtils.getSecond(cal);
    }

    public static final void setSecond(Calendar cal, int second) {
        int min = cal.getActualMinimum(13);
        int max = cal.getActualMaximum(13);
        if (second < min || second > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new RuntimeException("Encountered illegal second value " + second + " for the date " + df.format(cal.getTime()));
        }
        cal.set(13, second);
    }

    public static final Date setSecond(Date date, int second) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setSecond(cal, second);
        return cal.getTime();
    }

    public static final void incrSecond(Calendar cal, int seconds) {
        cal.add(13, seconds);
    }

    public static final Date incrSecond(Date date, int seconds) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrSecond(cal, seconds);
        return cal.getTime();
    }

    public static final int getMillisecond(Calendar cal) {
        return cal.get(14);
    }

    public static final int getMillisecond(Date date) {
        Calendar cal = DateUtils.createCalendar(date);
        return DateUtils.getMillisecond(cal);
    }

    public static final void setMillisecond(Calendar cal, int millisecond) {
        int min = cal.getActualMinimum(14);
        int max = cal.getActualMaximum(14);
        if (millisecond < min || millisecond > max) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new RuntimeException("Encountered illegal millisecond value " + millisecond + " for the date " + df.format(cal.getTime()));
        }
        cal.set(14, millisecond);
    }

    public static final Date setMillisecond(Date date, int millisecond) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.setMillisecond(cal, millisecond);
        return cal.getTime();
    }

    public static final void incrMillisecond(Calendar cal, int milliseconds) {
        cal.add(14, milliseconds);
    }

    public static final Date incrMillisecond(Date date, int milliseconds) {
        Calendar cal = DateUtils.createCalendar(date);
        DateUtils.incrMillisecond(cal, milliseconds);
        return cal.getTime();
    }

    public static final Date min(Date a, Date b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.after(b)) {
            return b;
        }
        return a;
    }

    public static final Date max(Date a, Date b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.after(b)) {
            return b;
        }
        return a;
    }

    public static final Date beginOfYear(Date d) {
        Calendar cal = DateUtils.createCalendar(d, 5);
        cal.set(5, 1);
        cal.set(2, 0);
        return cal.getTime();
    }

    public static final Date endOfYear(Date d) {
        Calendar cal = DateUtils.createCalendar(d, 5);
        cal.set(2, 11);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static final Date previousUltimo(Date d) {
        Calendar cal = DateUtils.createCalendar(d, 5);
        if (cal.get(5) == cal.getActualMaximum(5)) {
            return cal.getTime();
        }
        cal.set(5, 1);
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static final Date nextUltimo(Date d) {
        Calendar cal = DateUtils.createCalendar(d, 5);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }
}

