/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util;

import java.util.HashMap;
import java.util.Map;
import org.ujac.util.UjacTypes;

public class UjacTypeHelper
implements UjacTypes {
    private static final Map TYPE_NAME_MAP = new HashMap();
    private static final String[] TYPE_NAMES = new String[]{"boolean", "date", "double", "float", "int", "long", "object", "short", "string", "table", "time", "timestamp"};
    private static final int[] TYPE_IDS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

    public static final int getTypeId(String name) {
        if (name == null) {
            return -1;
        }
        Integer typeId = (Integer)TYPE_NAME_MAP.get(name.toLowerCase());
        if (typeId == null) {
            return -1;
        }
        return typeId;
    }

    public static final String getTypeName(int id) {
        switch (id) {
            case 1: {
                return "string";
            }
            case 2: {
                return "int";
            }
            case 4: {
                return "long";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "boolean";
            }
            case 8: {
                return "date";
            }
            case 9: {
                return "time";
            }
            case 10: {
                return "timestamp";
            }
            case 11: {
                return "object";
            }
            case 12: {
                return "table";
            }
        }
        return null;
    }

    public static final String[] getTypeNames() {
        return TYPE_NAMES;
    }

    public static final int[] getTypeIds() {
        return TYPE_IDS;
    }

    static {
        TYPE_NAME_MAP.put("string", new Integer(1));
        TYPE_NAME_MAP.put("int", new Integer(2));
        TYPE_NAME_MAP.put("short", new Integer(3));
        TYPE_NAME_MAP.put("long", new Integer(4));
        TYPE_NAME_MAP.put("float", new Integer(5));
        TYPE_NAME_MAP.put("double", new Integer(6));
        TYPE_NAME_MAP.put("boolean", new Integer(7));
        TYPE_NAME_MAP.put("date", new Integer(8));
        TYPE_NAME_MAP.put("time", new Integer(9));
        TYPE_NAME_MAP.put("timestamp", new Integer(10));
        TYPE_NAME_MAP.put("object", new Integer(11));
        TYPE_NAME_MAP.put("table", new Integer(12));
    }
}

