/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.console;

import java.io.IOException;

public class PasswordReader
implements Runnable {
    private boolean passwordEntered = false;
    private String prompt;

    public PasswordReader(String prompt) {
        this.prompt = prompt;
    }

    public void run() {
        while (!this.passwordEntered) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            if (!this.passwordEntered) {
                System.out.print("\r" + this.prompt + " \r" + this.prompt);
            }
            System.out.flush();
        }
    }

    public void stopMasking() {
        this.passwordEntered = true;
    }

    public String readPassword() throws IOException {
        StringBuffer passwdBuf = new StringBuffer();
        Thread maskingthread = new Thread(this);
        Thread thread = new Thread(maskingthread);
        thread.start();
        while (true) {
            char c = (char)System.in.read();
            this.stopMasking();
            if (c == '\r') {
                c = (char)System.in.read();
                if (c != '\n') continue;
                break;
            }
            if (c == '\n') break;
            passwdBuf.append(c);
        }
        return passwdBuf.toString();
    }

    public static void main(String[] args) {
        try {
            String passwd = new PasswordReader("password: ").readPassword();
            System.out.println("Password is: " + passwd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

