/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.db;

import org.ujac.util.db.DataTypeMapper;

public class AttributeDefinition {
    private String name;
    private String type = null;
    private String primitiveType = null;
    private String fullyQualifiedType = null;
    private String getter;
    private String setter;
    private String columnName;
    private int sqlType;
    private boolean primaryKey;
    private boolean foreignKey;

    public AttributeDefinition(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public AttributeDefinition(String name, String columnName, int sqlType, int columnSize, int decimalDigits, boolean primaryKey, boolean foreignKey, DataTypeMapper dataTypeMapper) {
        this.setName(name);
        this.setType(dataTypeMapper.getJavaTypeName(sqlType, columnSize, decimalDigits, false, false));
        this.setPrimitiveType(dataTypeMapper.getJavaTypeName(sqlType, columnSize, decimalDigits, true, false));
        this.setFullyQualifiedType(dataTypeMapper.getJavaTypeName(sqlType, columnSize, decimalDigits, false, true));
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.primaryKey = primaryKey;
        this.foreignKey = foreignKey;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
        if (name != null && name.length() > 0) {
            this.getter = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            this.setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    public void setFullyQualifiedType(String fullyQualifiedType) {
        this.fullyQualifiedType = fullyQualifiedType;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public void setPrimitiveType(String primitiveType) {
        this.primitiveType = primitiveType;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getSqlTypeName() {
        return AttributeDefinition.getSqlTypeName(this.sqlType);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public static final String getSqlTypeName(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        buf.append("java name: ").append(this.name).append(", java type: ").append(this.type).append(", column name: ").append(this.columnName).append(", SQL type: ").append(AttributeDefinition.getSqlTypeName(this.sqlType)).append(", is primary key: ").append(this.primaryKey).append(", is foreign key: ").append(this.foreignKey).append("}");
        return buf.toString();
    }
}

