/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.db;

import org.ujac.util.db.DataTypeMapper;

public class DefaultDataTypeMapper
implements DataTypeMapper {
    public int getJavaType(int sqlType, int columnSize, int decimalDigits) {
        switch (sqlType) {
            case -5: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2005: {
                return 11;
            }
            case 91: {
                return 8;
            }
            case 3: {
                if (columnSize > 0) {
                    return 6;
                }
                if (decimalDigits > 9) {
                    return 4;
                }
                return 2;
            }
            case 8: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 2000: {
                return 11;
            }
            case -1: {
                return 1;
            }
            case 2: {
                if (decimalDigits > 9) {
                    return 4;
                }
                return 2;
            }
            case 7: {
                return 5;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case -6: {
                return 2;
            }
            case 12: {
                return 1;
            }
        }
        throw new RuntimeException("Not supported type: " + this.getSqlTypeName(sqlType));
    }

    public String getJavaTypeName(int sqlType, int columnSize, int decimalDigits, boolean allowPrimitive, boolean fullyQualified) {
        switch (sqlType) {
            case -5: {
                return this.getLongType(allowPrimitive, fullyQualified);
            }
            case 1: {
                return this.getStringType(fullyQualified);
            }
            case 2005: {
                return this.getStringType(fullyQualified);
            }
            case 91: {
                return "java.sql.Date";
            }
            case 3: {
                if (columnSize > 0) {
                    return this.getDoubleType(allowPrimitive, fullyQualified);
                }
                if (decimalDigits > 9) {
                    return this.getLongType(allowPrimitive, fullyQualified);
                }
                return this.getIntType(allowPrimitive, fullyQualified);
            }
            case 8: {
                return this.getDoubleType(allowPrimitive, fullyQualified);
            }
            case 6: {
                return this.getFloatType(allowPrimitive, fullyQualified);
            }
            case 4: {
                return this.getIntType(allowPrimitive, fullyQualified);
            }
            case 2000: {
                return this.getObjectType(fullyQualified);
            }
            case -1: {
                return this.getStringType(fullyQualified);
            }
            case 2: {
                if (decimalDigits > 9) {
                    return this.getLongType(allowPrimitive, fullyQualified);
                }
                return this.getIntType(allowPrimitive, fullyQualified);
            }
            case 7: {
                return this.getFloatType(allowPrimitive, fullyQualified);
            }
            case 5: {
                return this.getIntType(allowPrimitive, fullyQualified);
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -6: {
                return this.getIntType(allowPrimitive, fullyQualified);
            }
            case 12: {
                return this.getStringType(fullyQualified);
            }
        }
        throw new RuntimeException("Not supported type: " + this.getSqlTypeName(sqlType));
    }

    private String getStringType(boolean fullyQualified) {
        if (fullyQualified) {
            return "java.lang.String";
        }
        return "String";
    }

    private String getObjectType(boolean fullyQualified) {
        if (fullyQualified) {
            return "java.lang.Object";
        }
        return "Object";
    }

    private String getIntType(boolean allowPrimitive, boolean fullyQualified) {
        if (allowPrimitive) {
            return "int";
        }
        if (fullyQualified) {
            return "java.lang.Integer";
        }
        return "Integer";
    }

    private String getLongType(boolean allowPrimitive, boolean fullyQualified) {
        if (allowPrimitive) {
            return "long";
        }
        if (fullyQualified) {
            return "java.lang.Long";
        }
        return "Long";
    }

    private String getFloatType(boolean allowPrimitive, boolean fullyQualified) {
        if (allowPrimitive) {
            return "float";
        }
        if (fullyQualified) {
            return "java.lang.Float";
        }
        return "Float";
    }

    private String getDoubleType(boolean allowPrimitive, boolean fullyQualified) {
        if (allowPrimitive) {
            return "double";
        }
        if (fullyQualified) {
            return "java.lang.Double";
        }
        return "Double";
    }

    public String getSqlTypeName(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return null;
    }
}

