/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.util.db.AttributeDefinition;

public class TableDefinition {
    private String name;
    private String schema;
    private List attributes = new ArrayList();
    private Map attributeNameMap = new HashMap();
    private Map attributeColumnMap = new HashMap();

    public TableDefinition(String name) {
        StringTokenizer nameTkn = new StringTokenizer(name, ".");
        String first = nameTkn.nextToken();
        if (nameTkn.hasMoreTokens()) {
            this.schema = first;
            this.name = nameTkn.nextToken();
        } else {
            this.name = first;
        }
    }

    public TableDefinition(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public void addAttribute(AttributeDefinition attribute) {
        this.attributes.add(attribute);
        this.attributeNameMap.put(attribute.getName(), attribute);
        this.attributeColumnMap.put(attribute.getColumnName(), attribute);
    }

    public AttributeDefinition getAttributeByName(String name) {
        return (AttributeDefinition)this.attributeNameMap.get(name);
    }

    public AttributeDefinition getAttributeByColumn(String columnName) {
        return (AttributeDefinition)this.attributeColumnMap.get(columnName);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public List getAttributes() {
        return this.attributes;
    }

    public int getNumPrimaryKeys() {
        int numPrimaryKeys = 0;
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributeDefinition attr = (AttributeDefinition)this.attributes.get(i);
            if (!attr.isPrimaryKey()) continue;
            ++numPrimaryKeys;
        }
        return numPrimaryKeys;
    }

    public AttributeDefinition[] getPrimaryKeys() {
        int numPrimaryKeys = this.getNumPrimaryKeys();
        AttributeDefinition[] pkAttrs = new AttributeDefinition[numPrimaryKeys];
        int pkIdx = 0;
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributeDefinition attr = (AttributeDefinition)this.attributes.get(i);
            if (!attr.isPrimaryKey()) continue;
            pkAttrs[pkIdx] = attr;
            ++pkIdx;
        }
        return pkAttrs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("table name: '").append(this.name);
        if (this.schema != null) {
            buf.append("' at schema: '").append(this.schema);
        }
        buf.append("'\nattributes:");
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            AttributeDefinition attribute = (AttributeDefinition)this.attributes.get(i);
            buf.append("\n  ").append(attribute);
        }
        return buf.toString();
    }
}

