/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi;

import java.io.Serializable;
import org.ujac.util.exi.ExpressionType;

public abstract class Operand
implements Serializable,
Cloneable {
    private char[] source;
    private int relativePosition;
    private int absolutePosition;
    private int length;
    private int totalPosition;
    private int totalLength;
    private ExpressionType forcedType = null;

    public Operand() {
    }

    public Operand(char[] source, int absolutePosition, int relativePosition, int length) {
        this.source = source;
        this.absolutePosition = absolutePosition;
        this.relativePosition = relativePosition;
        this.length = length;
        this.totalPosition = absolutePosition;
        this.totalLength = length;
    }

    public Operand(Operand outer) {
        this.source = outer.getSource();
        this.totalPosition = outer.getTotalPosition();
        this.totalLength = outer.getTotalLength();
    }

    public abstract boolean isSimple();

    public String getCode() {
        return new String(this.source, this.absolutePosition, this.length);
    }

    public char[] getSource() {
        return this.source;
    }

    public void setSource(char[] source) {
        this.source = source;
    }

    public int getAbsolutePosition() {
        return this.absolutePosition;
    }

    public void setAbsolutePosition(int absolutePosition) {
        this.absolutePosition = absolutePosition;
    }

    public int getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(int relativePosition) {
        this.relativePosition = relativePosition;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getTotalPosition() {
        return this.totalPosition;
    }

    public void setTotalPosition(int totalPosition) {
        this.totalPosition = totalPosition;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public abstract Object getValue();

    public ExpressionType getForcedType() {
        return this.forcedType;
    }

    public void setForcedType(ExpressionType forcedType) {
        this.forcedType = forcedType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone Operand instance: " + ex.getMessage(), ex);
        }
    }
}

