/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ConditionResultHolder;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseType;

public class ConditionResultHolderType
extends BaseType {
    public ConditionResultHolderType(ExpressionInterpreter interpreter) {
        super(interpreter);
        ElseOperation op = new ElseOperation();
        this.addOperation(":", op);
    }

    public Class getType() {
        return ConditionResultHolder.class;
    }

    public class ElseOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            ConditionResultHolder conditionResult = (ConditionResultHolder)expr.getObject().getValue();
            if (conditionResult.isStatus()) {
                return conditionResult.getResult();
            }
            return ConditionResultHolderType.this.interpreter.evalOperand(operand, ctx);
        }

        public String getDescription() {
            return "Tells whether the object is defined or not.";
        }
    }
}

