/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.Map;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.type.BaseType;

public class MapEntryType
extends BaseType {
    public MapEntryType(ExpressionInterpreter interpreter) {
        super(interpreter);
        ReferenceOperation op = new ReferenceOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
    }

    public Class getType() {
        return Map.Entry.class;
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = MapEntryType.this.interpreter.evalStringOperand(operand, ctx);
            Operand object = expr.getObject();
            Map.Entry objectValue = (Map.Entry)object.getValue();
            if (objectValue == null) {
                throw new OperandException("Unable to resolve reference " + expr.getObject() + " for null value at expression " + expr.toString() + "!");
            }
            if (BeanUtils.equals(operandValue, "key")) {
                return objectValue.getKey();
            }
            if (BeanUtils.equals(operandValue, "value")) {
                return objectValue.getValue();
            }
            throw new OperandException("Invalid property '" + operandValue + "' requested for Map Entry " + expr.getObject() + " at expression '" + expr.getCode() + "'.");
        }

        public String getDescription() {
            return "Accesses the object's key/value properties.";
        }
    }
}

