/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class ShortArrayType
extends BaseType {
    public ShortArrayType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new IsEmptyOperation();
        this.addOperation("isEmpty", op);
        op = new NotEmptyOperation();
        this.addOperation("notEmpty", op);
        op = new SizeOperation();
        this.addOperation("size", op);
        op = new GetOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
    }

    public Class getType() {
        return [S.class;
    }

    public class GetOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = ShortArrayType.this.interpreter.evalIntOperand(operand, ctx, false);
            short[] array = (short[])expr.getObject().getValue();
            try {
                return new Short(array[operandValue]);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OperandException("Invalid index " + operandValue + " for array at expression '" + expr.getCode() + "'.");
            }
        }

        public String getDescription() {
            return "Gets an element from the array.";
        }
    }

    public class SizeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            short[] array = (short[])expr.getObject().getValue();
            return new Integer(array.length);
        }

        public String getDescription() {
            return "Determines the size of the array.";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            short[] array = (short[])expr.getObject().getValue();
            return new Boolean(array.length != 0);
        }

        public String getDescription() {
            return "Checks if the array is not empty.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            short[] array = (short[])expr.getObject().getValue();
            return new Boolean(array.length == 0);
        }

        public String getDescription() {
            return "Tells whether the array is empty or not.";
        }
    }
}

