/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.ujac.util.table.BeanColumn;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnFilter;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.util.text.FormatHelper;

public class BeanTable
extends DataTable {
    static final long serialVersionUID = -6301105392789353319L;

    public BeanTable(List itemList) throws TableException {
        this(null, itemList, null);
    }

    public BeanTable(FormatHelper formatHelper, List itemList) throws TableException {
        this(formatHelper, itemList, null);
    }

    public BeanTable(List itemList, ColumnFilter columnFilter) throws TableException {
        this(null, itemList, columnFilter);
    }

    public BeanTable(FormatHelper formatHelper, List itemList, ColumnFilter columnFilter) throws TableException {
        super(formatHelper);
        if (itemList == null || itemList.size() < 1) {
            throw new TableException("Unable to determine bean class from empty list.");
        }
        Object firstItem = itemList.get(0);
        if (firstItem == null) {
            throw new TableException("Unable to determine bean class from given list.");
        }
        this.setupColumns(firstItem.getClass(), columnFilter);
        Object[] getterArgs = new Object[]{};
        Object[] columns = this.columns.toArray();
        int numColumns = columns.length;
        int numItems = itemList.size();
        try {
            for (int i = 0; i < numItems; ++i) {
                Object bean = itemList.get(i);
                Row row = this.addRow();
                block15: for (int j = 0; j < numColumns; ++j) {
                    BeanColumn col = (BeanColumn)columns[j];
                    Method getter = col.getGetter();
                    Object value = getter.invoke(bean, getterArgs);
                    if (value == null) continue;
                    switch (col.getType()) {
                        case 7: {
                            row.setBoolean(j, (boolean)((Boolean)value));
                            continue block15;
                        }
                        case 5: {
                            row.setFloat(j, ((Number)value).floatValue());
                            continue block15;
                        }
                        case 6: {
                            row.setDouble(j, ((Number)value).doubleValue());
                            continue block15;
                        }
                        case 2: {
                            row.setInt(j, ((Number)value).intValue());
                            continue block15;
                        }
                        case 4: {
                            row.setLong(j, ((Number)value).longValue());
                            continue block15;
                        }
                        case 1: {
                            row.setString(j, (String)value);
                            continue block15;
                        }
                        case 8: {
                            row.setDate(j, (Date)value);
                            continue block15;
                        }
                        case 9: {
                            row.setTime(j, (Date)((Time)value));
                            continue block15;
                        }
                        case 10: {
                            row.setTimestamp(j, (Date)((Timestamp)value));
                            continue block15;
                        }
                        default: {
                            row.setObject(j, value);
                        }
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new TableException("Unable to import data from bean list:" + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new TableException("Unable to import data from bean list:" + ex.getMessage());
        }
    }

    public BeanTable(Class dataType) {
        this(null, dataType, null);
    }

    public BeanTable(FormatHelper formatHelper, Class dataType) {
        this(formatHelper, dataType, null);
    }

    public BeanTable(Class dataType, ColumnFilter columnFilter) {
        this(null, dataType, columnFilter);
    }

    public BeanTable(FormatHelper formatHelper, Class dataType, ColumnFilter columnFilter) {
        super(formatHelper);
        this.setupColumns(dataType, columnFilter);
    }

    private void setupColumns(Class dataClass, ColumnFilter columnFilter) {
        try {
            Method[] methods = dataClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int type;
                String columnName;
                Method method = methods[i];
                Class<?> returnType = method.getReturnType();
                if (returnType == null) continue;
                String methodName = method.getName();
                if (methodName.startsWith("get")) {
                    if (method.getParameterTypes().length > 0) continue;
                    columnName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                    if (columnFilter != null && !columnFilter.isValid(columnName) || "class".equals(columnName) || (type = this.getColumnType(method.getReturnType())) <= 0) continue;
                    this.addColumn(columnName, type, method);
                    continue;
                }
                if (!methodName.startsWith("is") || method.getParameterTypes().length > 0) continue;
                columnName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                if (columnFilter != null && !columnFilter.isValid(columnName) || (type = this.getColumnType(method.getReturnType())) <= 0) continue;
                this.addColumn(columnName, type, method);
            }
        }
        catch (ColumnAlreadyDefinedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private int getColumnType(Class dataType) {
        if (Boolean.TYPE.isAssignableFrom(dataType)) {
            return 7;
        }
        if (Boolean.class.isAssignableFrom(dataType)) {
            return 7;
        }
        if (Integer.TYPE.isAssignableFrom(dataType)) {
            return 2;
        }
        if (Integer.class.isAssignableFrom(dataType)) {
            return 2;
        }
        if (Long.TYPE.isAssignableFrom(dataType)) {
            return 4;
        }
        if (Long.class.isAssignableFrom(dataType)) {
            return 4;
        }
        if (Float.TYPE.isAssignableFrom(dataType)) {
            return 5;
        }
        if (Float.class.isAssignableFrom(dataType)) {
            return 5;
        }
        if (Double.TYPE.isAssignableFrom(dataType)) {
            return 6;
        }
        if (Double.class.isAssignableFrom(dataType)) {
            return 6;
        }
        if (String.class.isAssignableFrom(dataType)) {
            return 1;
        }
        if (Time.class.isAssignableFrom(dataType)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(dataType)) {
            return 10;
        }
        if (Date.class.isAssignableFrom(dataType)) {
            return 8;
        }
        return 11;
    }

    public Column addColumn(String name, int type, Method getter) throws ColumnAlreadyDefinedException {
        Column col = (Column)this.columnMap.get(name);
        if (col != null) {
            throw new ColumnAlreadyDefinedException("A column with name '" + name + "' already exists.");
        }
        col = new BeanColumn(this, name, type, getter);
        this.columnMap.put(name, col);
        this.columns.add(col);
        int idx = this.columns.size() - 1;
        col.setIndex(idx);
        col.setDataIndex(idx);
        return col;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        super.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readData(s);
    }
}

