/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.ujac.util.DefaultTypeConverter;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.table.BaseTable;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.DataRow;
import org.ujac.util.table.DataTableIterator;
import org.ujac.util.table.HeaderRow;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowComparator;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;
import org.ujac.util.text.FormatHelper;

public class DataTable
extends BaseTable
implements Serializable {
    static final long serialVersionUID = 2494694894996180895L;
    private List rows = new ArrayList();

    public DataTable() {
    }

    public DataTable(FormatHelper formatHelper) {
        super(formatHelper);
    }

    public Column addColumn(String name, int type) throws ColumnAlreadyDefinedException, OperationNotSupportedException {
        Column col = super.addColumn(name, type);
        List rows = this.rows;
        int numRows = rows.size();
        for (int i = 0; i < numRows; ++i) {
            ((DataRow)rows.get(i)).expandRow();
        }
        return col;
    }

    public Column addColumn(String name, int type, LayoutHints layoutHints) throws ColumnAlreadyDefinedException, OperationNotSupportedException {
        Column col = this.addColumn(name, type);
        col.setLayoutHints(layoutHints);
        return col;
    }

    public Table addString(String name, String value) throws TableException {
        Column col = this.addColumn(name, 1);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setString(col.getIndex(), value);
        return this;
    }

    public Table addInt(String name, int value) throws TableException {
        Column col = this.addColumn(name, 2);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setInt(col.getIndex(), value);
        return this;
    }

    public Table addLong(String name, long value) throws TableException {
        Column col = this.addColumn(name, 4);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setLong(col.getIndex(), value);
        return this;
    }

    public Table addFloat(String name, float value) throws TableException {
        Column col = this.addColumn(name, 5);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setFloat(col.getIndex(), value);
        return this;
    }

    public Table addDouble(String name, double value) throws TableException {
        Column col = this.addColumn(name, 6);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setDouble(col.getIndex(), value);
        return this;
    }

    public Table addBoolean(String name, boolean value) throws TableException {
        Column col = this.addColumn(name, 7);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setBoolean(col.getIndex(), value);
        return this;
    }

    public Table addDate(String name, Date value) throws TableException {
        Column col = this.addColumn(name, 8);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setDate(col.getIndex(), value);
        return this;
    }

    public Table addTime(String name, Date value) throws TableException {
        Column col = this.addColumn(name, 9);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setTime(col.getIndex(), value);
        return this;
    }

    public Table addTimestamp(String name, Date value) throws TableException {
        Column col = this.addColumn(name, 10);
        if (this.getRowCount() < 1) {
            this.addRow();
        }
        Row row = this.getRow(0);
        ((DataRow)row).expandRow();
        row.setTimestamp(col.getIndex(), value);
        return this;
    }

    public boolean isEmpty() {
        return this.rows.size() == 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Row addRow() {
        DataRow newRow = new DataRow((Table)this, this.rows.size());
        this.rows.add(newRow);
        return newRow;
    }

    public Row addRow(Row srcRow) throws OperationNotSupportedException {
        DataRow newRow = new DataRow(this, this.rows.size(), srcRow);
        this.rows.add(newRow);
        return newRow;
    }

    public Row getRow(int rowIdx) throws RowNotDefinedException {
        if (rowIdx >= this.getRowCount()) {
            throw new RowNotDefinedException("The row with index " + rowIdx + " does not exist.");
        }
        return (Row)this.rows.get(rowIdx);
    }

    public void removeRow(int rowIdx) throws RowNotDefinedException {
        if (rowIdx >= this.getRowCount()) {
            throw new RowNotDefinedException("The row with index " + rowIdx + " does not exist.");
        }
        this.rows.remove(rowIdx);
    }

    public Row getHeaderRow() {
        HeaderRow row = new HeaderRow(this);
        return row;
    }

    public Iterator iterator() {
        return new DataTableIterator(this);
    }

    public String getString(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getString(columnIdx);
    }

    public String getString(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        return this.getString(rowIdx, col.getIndex());
    }

    public void setString(int rowIdx, int columnIdx, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setString(columnIdx, value);
    }

    public void setString(int rowIdx, String columnName, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        this.setString(rowIdx, col.getIndex(), value);
    }

    public int getInt(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getInt(columnIdx);
    }

    public int getInt(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Column col = this.getColumn(columnName);
        return this.getInt(rowIdx, col.getIndex());
    }

    public void setInt(int rowIdx, int columnIdx, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setInt(columnIdx, value);
    }

    public void setInt(int rowIdx, String columnName, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setInt(rowIdx, columnIdx, value);
    }

    public long getLong(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getLong(columnIdx);
    }

    public long getLong(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getLong(rowIdx, columnIdx);
    }

    public void setLong(int rowIdx, int columnIdx, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setLong(columnIdx, value);
    }

    public void setLong(int rowIdx, String columnName, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setLong(rowIdx, columnIdx, value);
    }

    public float getFloat(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getFloat(columnIdx);
    }

    public float getFloat(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getFloat(rowIdx, columnIdx);
    }

    public void setFloat(int rowIdx, int columnIdx, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setFloat(columnIdx, value);
    }

    public void setFloat(int rowIdx, String columnName, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setFloat(rowIdx, columnIdx, value);
    }

    public double getDouble(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getDouble(columnIdx);
    }

    public double getDouble(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDouble(rowIdx, columnIdx);
    }

    public void setDouble(int rowIdx, int columnIdx, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setDouble(columnIdx, value);
    }

    public void setDouble(int rowIdx, String columnName, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDouble(rowIdx, columnIdx, value);
    }

    public boolean getBoolean(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getBoolean(columnIdx);
    }

    public boolean getBoolean(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getBoolean(rowIdx, columnIdx);
    }

    public void setBoolean(int rowIdx, int columnIdx, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setBoolean(columnIdx, value);
    }

    public void setBoolean(int rowIdx, String columnName, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setBoolean(rowIdx, columnIdx, value);
    }

    public Date getDate(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getDate(columnIdx);
    }

    public Date getDate(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDate(rowIdx, columnIdx);
    }

    public void setDate(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setDate(columnIdx, value);
    }

    public void setDate(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDate(rowIdx, columnIdx, value);
    }

    public Date getTime(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getTime(columnIdx);
    }

    public Date getTime(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getDate(rowIdx, columnIdx);
    }

    public void setTime(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setTime(columnIdx, value);
    }

    public void setTime(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setTime(rowIdx, columnIdx, value);
    }

    public Date getTimestamp(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        return row.getTimestamp(columnIdx);
    }

    public Date getTimestamp(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getTimestamp(rowIdx, columnIdx);
    }

    public void setTimestamp(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setTimestamp(columnIdx, value);
    }

    public void setTimestamp(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setDate(rowIdx, columnIdx, value);
    }

    public Object getObject(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException {
        Row row = this.getRow(rowIdx);
        return row.getObject(columnIdx);
    }

    public Object getObject(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException {
        int columnIdx = this.getColumnIndex(columnName);
        return this.getObject(rowIdx, columnIdx);
    }

    public void setObject(int rowIdx, int columnIdx, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        Row row = this.getRow(rowIdx);
        row.setObject(columnIdx, value);
    }

    public void setObject(int rowIdx, String columnName, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int columnIdx = this.getColumnIndex(columnName);
        this.setObject(rowIdx, columnIdx, value);
    }

    public void sort(CompareItem[] compareColumns) {
        RowComparator rowComparator = new RowComparator(compareColumns);
        Collections.sort(this.rows, rowComparator);
    }

    public void sort(int columnIdx, int direction) {
        this.sort(new CompareItem[]{new CompareItem(columnIdx, direction)});
    }

    public void swapRows(int a, int b) {
        if (a == b) {
            return;
        }
        DataRow rowA = (DataRow)this.rows.get(a);
        DataRow rowB = (DataRow)this.rows.get(b);
        this.rows.set(a, rowB);
        this.rows.set(b, rowA);
    }

    public void setColumnType(int columnIdx, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        Column column = this.getColumn(columnIdx);
        int dataIdx = column.getDataIndex();
        int oldType = column.getType();
        if (oldType == typeId) {
            return;
        }
        column.setType(typeId);
        TypeConverter tc = this.getTypeConverter();
        if (tc == null) {
            tc = new DefaultTypeConverter();
        }
        try {
            int numRows = this.rows.size();
            for (int i = 0; i < numRows; ++i) {
                Row row = (Row)this.rows.get(i);
                row.setObject(columnIdx, tc.convertObject(typeId, row.getObject(dataIdx)));
            }
        }
        catch (TableException ex) {
            throw new TypeConverterException("Type conversion failed: " + ex.getMessage(), ex);
        }
    }

    public void setColumnType(String columnName, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        Column column = this.getColumn(columnName);
        this.setColumnType(column.getIndex(), typeId);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int numCols = this.columns.size();
        try {
            Column col;
            int i;
            int totalWidth = 1;
            int[] widths = new int[numCols];
            for (i = 0; i < numCols; ++i) {
                col = (Column)this.columns.get(i);
                widths[i] = this.computeColumnWidth(i, col);
                totalWidth += widths[i] + 1;
            }
            for (i = 0; i < totalWidth; ++i) {
                buf.append('-');
            }
            buf.append("\n|");
            for (i = 0; i < numCols; ++i) {
                if (i > 0) {
                    buf.append('|');
                }
                col = (Column)this.columns.get(i);
                this.printField(buf, col.getName() + ":" + col.getTypeName(), widths[i]);
            }
            buf.append("|\n");
            for (int k = 0; k < totalWidth; ++k) {
                buf.append('-');
            }
            buf.append('\n');
            int numRows = this.getRowCount();
            for (int row = 0; row < numRows; ++row) {
                if (row > 0) {
                    buf.append('\n');
                }
                buf.append('|');
                for (int j = 0; j < numCols; ++j) {
                    if (j > 0) {
                        buf.append('|');
                    }
                    this.printField(buf, this.getString(row, j), widths[j]);
                }
                buf.append('|');
            }
            buf.append('\n');
            for (int k = 0; k < totalWidth; ++k) {
                buf.append('-');
            }
        }
        catch (RowNotDefinedException e) {
            e.printStackTrace();
        }
        catch (ColumnNotDefinedException e) {
            e.printStackTrace();
        }
        catch (TypeMismatchException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private int computeColumnWidth(int colId, Column col) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        int width = col.getName().length() + col.getTypeName().length() + 1;
        int numRows = this.getRowCount();
        String val = null;
        int valLength = 0;
        for (int row = 0; row < numRows; ++row) {
            val = this.getString(row, colId);
            if (val == null) continue;
            valLength = val.length();
            width = valLength > width ? valLength : width;
        }
        return width;
    }

    private void printField(StringBuffer buf, String value, int columnWidth) {
        buf.append(value);
        int len = 0;
        len = value != null ? value.length() : 4;
        if (len >= columnWidth) {
            return;
        }
        for (int i = len; i < columnWidth; ++i) {
            buf.append(' ');
        }
    }

    public static final void main(String[] args) {
        try {
            DataTable table = new DataTable();
            int nameID = table.addColumn("name", 1).getIndex();
            int firstNameID = table.addColumn("firstName", 1).getIndex();
            int addressID = table.addColumn("address", 1).getIndex();
            int zipCodeID = table.addColumn("zipCode", 2).getIndex();
            int cityID = table.addColumn("city", 1).getIndex();
            int birthdayID = table.addColumn("birthday", 8).getIndex();
            Row row = table.addRow();
            row.setString(nameID, "Pan");
            row.setString(firstNameID, "Peter");
            row.setString(addressID, "Zwiebelgasse 12");
            row.setInt(zipCodeID, 12345);
            row.setString(cityID, "Wichtelhausen");
            row.setString(birthdayID, "20.02.1971");
            int ageID = table.addColumn("age", 2).getIndex();
            row = table.addRow();
            row.setString(nameID, "Kunz");
            row.setString(firstNameID, "Heiner");
            row.setString(addressID, "Wurtsweg 23");
            row.setInt(zipCodeID, 12345);
            row.setString(cityID, "Wichtelhausen");
            row.setString(birthdayID, "24.03.1964");
            row.setInt(ageID, 39);
            System.out.println(table.toString());
            Iterator iter = table.iterator();
            while (iter.hasNext()) {
                DataRow r = (DataRow)iter.next();
                System.out.println(r.getString("name"));
            }
        }
        catch (OperationNotSupportedException e) {
            e.printStackTrace();
        }
        catch (ColumnAlreadyDefinedException e) {
            e.printStackTrace();
        }
        catch (ColumnNotDefinedException e) {
            e.printStackTrace();
        }
        catch (TypeMismatchException e) {
            e.printStackTrace();
        }
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        super.writeData(s);
        s.writeObject(this.rows);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readData(s);
        this.rows = (List)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

