/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Iterator;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.table.BaseTable;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.FilteredTableIterator;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowFilterRule;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;
import org.ujac.util.text.FormatHelper;

public class FilteredTable
extends BaseTable
implements Table {
    static final long serialVersionUID = 2135433454353128079L;
    private Table dataTable = null;
    private Column[] columns = null;
    private RowFilterRule filterRule = null;
    private Row firstRow = null;

    public FilteredTable(Table dataTable) throws TableException {
        this.dataTable = dataTable;
        int numColumns = dataTable.getColumnCount();
        this.columns = new Column[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            this.columns[i] = dataTable.getColumn(i);
        }
    }

    public FilteredTable(Table dataTable, RowFilterRule filterRule) throws TableException {
        this(dataTable);
        this.setFilterRule(filterRule);
    }

    public void setFilterRule(RowFilterRule filterRule) throws TableException {
        this.filterRule = filterRule;
        filterRule.setup(this.dataTable);
        this.firstRow = null;
        Iterator iter = this.iterator();
        if (iter.hasNext()) {
            this.firstRow = (Row)iter.next();
        }
    }

    public RowFilterRule getFilterRule() {
        return this.filterRule;
    }

    public FormatHelper getFormatHelper() {
        return this.dataTable.getFormatHelper();
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.dataTable.setFormatHelper(formatHelper);
    }

    public TypeConverter getTypeConverter() {
        return this.dataTable.getTypeConverter();
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.dataTable.setTypeConverter(typeConverter);
    }

    public Column getColumn(int index) throws ColumnNotDefinedException {
        return this.dataTable.getColumn(index);
    }

    public Column getColumn(String name) throws ColumnNotDefinedException {
        return this.dataTable.getColumn(name);
    }

    public int getColumnIndex(String name) throws ColumnNotDefinedException {
        return this.dataTable.getColumnIndex(name);
    }

    public void orderColumns(String[] columnNames) throws ColumnNotDefinedException, ColumnAlreadyDefinedException {
        this.dataTable.orderColumns(columnNames);
    }

    public Column[] getVisibleColumns() {
        return this.dataTable.getVisibleColumns();
    }

    public Column[] getVisibleColumns(int levelFilter) {
        return this.dataTable.getVisibleColumns(levelFilter);
    }

    public Row getHeaderRow() {
        return this.dataTable.getHeaderRow();
    }

    public Iterator iterator() {
        return new FilteredTableIterator(this.dataTable, this.filterRule);
    }

    public int getColumnCount() {
        return this.dataTable.getColumnCount();
    }

    protected Table getDataTable() {
        return this.dataTable;
    }

    public Column addColumn(String name, int type) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Column addColumn(String name, int type, LayoutHints layoutHints) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addString(String name, String value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addInt(String name, int value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addLong(String name, long value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addFloat(String name, float value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addDouble(String name, double value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addBoolean(String name, boolean value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addDate(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addTime(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addTimestamp(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public boolean isEmpty() {
        return this.firstRow != null;
    }

    public int getRowCount() throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return 0;
    }

    public Row addRow() throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Row addRow(Row srcRow) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Row getRow(int rowIdx) throws RowNotDefinedException, OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public void removeRow(int rowIdx) throws RowNotDefinedException, OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public String getString(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getString(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public String getString(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getString(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public void setString(int rowIdx, int columnIdx, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setString(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setString(int rowIdx, String columnName, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setString(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public int getInt(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getInt(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0;
    }

    public int getInt(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getInt(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0;
    }

    public void setInt(int rowIdx, int columnIdx, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setInt(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setInt(int rowIdx, String columnName, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setInt(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public long getLong(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getLong(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0L;
    }

    public long getLong(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getLong(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0L;
    }

    public void setLong(int rowIdx, int columnIdx, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setLong(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setLong(int rowIdx, String columnName, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setLong(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public float getFloat(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getFloat(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0.0f;
    }

    public float getFloat(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getFloat(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0.0f;
    }

    public void setFloat(int rowIdx, int columnIdx, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setFloat(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setFloat(int rowIdx, String columnName, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setFloat(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public double getDouble(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getDouble(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0.0;
    }

    public double getDouble(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getDouble(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return 0.0;
    }

    public void setDouble(int rowIdx, int columnIdx, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setDouble(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setDouble(int rowIdx, String columnName, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setDouble(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public boolean getBoolean(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getBoolean(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return false;
    }

    public boolean getBoolean(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getBoolean(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return false;
    }

    public void setBoolean(int rowIdx, int columnIdx, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setBoolean(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setBoolean(int rowIdx, String columnName, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setBoolean(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public Date getDate(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getDate(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public Date getDate(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getDate(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public void setDate(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setDate(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setDate(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setDate(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public Date getTime(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getTime(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public Date getTime(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getTime(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public void setTime(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setTime(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setTime(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setTime(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public Date getTimestamp(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getTimestamp(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public Date getTimestamp(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            return this.firstRow.getTimestamp(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public void setTimestamp(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setTimestamp(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setTimestamp(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setTimestamp(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public Object getObject(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException {
        if (rowIdx == 0) {
            return this.firstRow.getObject(columnIdx);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public Object getObject(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException {
        if (rowIdx == 0) {
            return this.firstRow.getObject(columnName);
        }
        this.throwDirectRowAccessNotAllowedException();
        return null;
    }

    public void setObject(int rowIdx, int columnIdx, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setObject(columnIdx, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void setObject(int rowIdx, String columnName, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        if (rowIdx == 0) {
            this.firstRow.setObject(columnName, value);
        }
        this.throwDirectRowAccessNotAllowedException();
    }

    public void sort(CompareItem[] compareColumns) throws OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public void sort(int columnIdx, int direction) throws OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public void setColumnType(int columnIdx, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        this.dataTable.setColumnType(columnIdx, typeId);
    }

    public void setColumnType(String columnName, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        this.dataTable.setColumnType(columnName, typeId);
    }

    private void throwNotSupportedException() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("This operation is not supported for filtered tables.");
    }

    private void throwDirectRowAccessNotAllowedException() throws RuntimeException {
        throw new RuntimeException("Direct row access is not supported for filtered tables.");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.dataTable);
        s.writeObject(this.columns);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.dataTable = (Table)s.readObject();
        this.columns = (Column[])s.readObject();
    }
}

