/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataRow;
import org.ujac.util.table.Table;

public class GroupRow
extends DataRow {
    static final long serialVersionUID = 5453737701006063660L;
    private String groupName = null;

    public GroupRow(Table table, String type, String groupName) {
        super(table, -1);
        this.setType(type);
        this.groupName = groupName;
        try {
            int columnCount = table.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.setVisible(i, false);
            }
        }
        catch (ColumnNotDefinedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    protected void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    protected void writeData(ObjectOutputStream s) throws IOException {
        super.writeData(s);
        s.writeObject(this.groupName);
    }

    protected void readData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        super.readData(s);
        this.groupName = (String)s.readObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeData(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readData(s);
    }
}

