/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ujac.util.table.TableHelper;

public class LayoutHints
implements Serializable {
    static final long serialVersionUID = -5722131385432713833L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private float width = 0.0f;
    private String header = null;
    private int align = 0;
    private int headerAlign = 0;
    private boolean visible = true;
    private int level = 0;

    public LayoutHints() {
    }

    public LayoutHints(float width, String title) {
        this(width, title, 0, true);
    }

    public LayoutHints(float width, String title, int align) {
        this(width, title, align, true);
    }

    public LayoutHints(float width, String header, int align, boolean visible) {
        this.width = width;
        this.header = header;
        this.align = align;
        this.headerAlign = align;
        this.visible = visible;
    }

    public int getAlign() {
        return this.align;
    }

    public String getAlignText() {
        return TableHelper.getAlignmentName(this.align);
    }

    public LayoutHints setAlign(int align) {
        this.align = align;
        return this;
    }

    public int getHeaderAlign() {
        return this.headerAlign;
    }

    public String getHeaderAlignText() {
        return TableHelper.getAlignmentName(this.headerAlign);
    }

    public LayoutHints setHeaderAlign(int headerAlign) {
        this.headerAlign = headerAlign;
        return this;
    }

    public String getHeader() {
        return this.header;
    }

    public LayoutHints setHeader(String header) {
        this.header = header;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public LayoutHints setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public LayoutHints setLevel(int level) {
        this.level = level;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public LayoutHints setWidth(float width) {
        this.width = width;
        return this;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeFloat(this.width);
        s.writeObject(this.header);
        s.writeInt(this.align);
        s.writeInt(this.headerAlign);
        s.writeBoolean(this.visible);
        s.writeInt(this.level);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.width = s.readFloat();
        this.header = (String)s.readObject();
        this.align = s.readInt();
        this.headerAlign = s.readInt();
        this.visible = s.readBoolean();
        this.level = s.readInt();
    }
}

