/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.ujac.util.table.DataRow;
import org.ujac.util.table.GroupRow;
import org.ujac.util.table.ReportFunction;
import org.ujac.util.table.ReportGroup;
import org.ujac.util.table.ReportTable;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TableIterationException;

public class ReportIterator
implements Iterator {
    private ReportFunction[] functions = null;
    private ReportGroup[] groups = null;
    private Table table;
    private Iterator tableIterator;
    private Row groupStartRow = null;
    private Row lastDataRow = null;
    private Row prefetchedRow = null;
    private List rowBuffer = new LinkedList();
    private int currentRowIdx = -1;

    protected ReportIterator(ReportTable report, ReportFunction[] functions, ReportGroup[] groups) {
        this.functions = functions;
        this.groups = groups;
        this.table = report.getDataTable();
        this.tableIterator = this.table.iterator();
    }

    public boolean hasNext() {
        return this.tableIterator.hasNext() || !this.rowBuffer.isEmpty() || this.prefetchedRow != null;
    }

    public Object next() {
        if (!this.isRowBufferEmpty()) {
            return this.fetchRow();
        }
        Row row = this.prefetchedRow;
        if (row == null) {
            row = (Row)this.tableIterator.next();
            ++this.currentRowIdx;
        } else {
            this.prefetchedRow = null;
        }
        return this.processNextRow(row);
    }

    private Row processNextRow(Row nextRow) {
        try {
            boolean pageBreakAllowed;
            ReportFunction[] functions = this.functions;
            int firstChangedGroupIdx = -1;
            int lastChangedGroupIdx = -1;
            boolean blockStartAllowed = true;
            boolean bl = pageBreakAllowed = this.currentRowIdx > 0;
            while (true) {
                int i;
                if (this.groupStartRow == null) {
                    firstChangedGroupIdx = 0;
                    this.groupStartRow = nextRow;
                    for (i = 0; i < this.groups.length; ++i) {
                        ReportGroup group = this.groups[i];
                        if (group == null) continue;
                        if (group.isViewTitleRow()) {
                            GroupRow groupTitleRow = new GroupRow(this.table, "groupTitle", group.getColumnName());
                            if (group.isKeepTogether() && blockStartAllowed) {
                                groupTitleRow.setStartsBlock(true);
                                blockStartAllowed = false;
                            }
                            if (group.isStartNewPage() && pageBreakAllowed) {
                                groupTitleRow.setStartNewPage(true);
                                pageBreakAllowed = false;
                            }
                            if (group.isKeepTogether() && blockStartAllowed) {
                                this.groupStartRow.setStartsBlock(true);
                                blockStartAllowed = false;
                            }
                            int numColumns = this.table.getColumnCount();
                            for (int j = 0; j < numColumns; ++j) {
                                groupTitleRow.setObject(j, nextRow.getObject(j));
                                if (j != group.getColumnIdx()) continue;
                                groupTitleRow.setVisible(j, true);
                            }
                            group.setTitleRow(groupTitleRow);
                            this.groupStartRow = groupTitleRow;
                            this.pushRow(groupTitleRow);
                            if (!group.isHideAtSucceedingRows()) continue;
                        }
                        if (group.isStartNewPage() && pageBreakAllowed) {
                            this.groupStartRow.setStartNewPage(true);
                            pageBreakAllowed = false;
                        }
                        if (!group.isKeepTogether() || !blockStartAllowed) continue;
                        this.groupStartRow.setStartsBlock(true);
                        blockStartAllowed = false;
                    }
                } else {
                    ReportGroup[] groups = this.groups;
                    firstChangedGroupIdx = -1;
                    boolean firstResultsInTitleGroupClosed = false;
                    int firstGroupIdx = -1;
                    for (int i2 = 0; i2 < groups.length; ++i2) {
                        ReportGroup group = groups[i2];
                        if (group == null) continue;
                        if (firstGroupIdx < 0) {
                            firstGroupIdx = i2;
                        }
                        Object nro = nextRow.getObject(i2);
                        Object sro = this.groupStartRow.getObject(i2);
                        boolean equal = false;
                        equal = nro == null || sro == null ? nro == sro : nextRow.getObject(i2).equals(this.groupStartRow.getObject(i2));
                        if (equal) continue;
                        firstChangedGroupIdx = i2;
                        firstResultsInTitleGroupClosed = i2 == firstGroupIdx && group.isResultsInTitleRow();
                        break;
                    }
                    lastChangedGroupIdx = firstChangedGroupIdx;
                    if (firstChangedGroupIdx >= 0) {
                        int i3;
                        ReportGroup group;
                        int j;
                        Row blockEndRow = this.lastDataRow;
                        for (j = groups.length - 1; j >= firstChangedGroupIdx; --j) {
                            group = groups[j];
                            if (group == null) continue;
                            lastChangedGroupIdx = Math.max(lastChangedGroupIdx, j);
                            if (!group.isFunctionsApplied()) {
                                if (group.isEnforceResultRow()) {
                                    blockEndRow = this.enforceResultRow(group);
                                } else if (group.isKeepTogether()) {
                                    // empty if block
                                }
                                if (!group.isKeepTogether()) continue;
                                blockEndRow.setEndsBlock(true);
                                blockStartAllowed = true;
                                continue;
                            }
                            double[] results = group.getGroupResults();
                            Row groupResultRow = null;
                            if (group.isResultsInTitleRow()) {
                                groupResultRow = group.getTitleRow();
                                group.setTitleRow(null);
                                if (group.isEnforceResultRow()) {
                                    blockEndRow = this.enforceResultRow(group);
                                }
                            } else {
                                blockEndRow = groupResultRow = new GroupRow(this.table, "group", group.getColumnName());
                            }
                            for (i3 = 0; i3 < results.length; ++i3) {
                                if (group.isFunctionsApplied(i3)) {
                                    ReportFunction function = functions[i3];
                                    groupResultRow.setDouble(i3, group.getGroupResult(i3));
                                    groupResultRow.setVisible(i3, true);
                                    groupResultRow.setFormat(i3, function.getFormat());
                                    groupResultRow.setAlign(i3, function.getAlign());
                                    continue;
                                }
                                groupResultRow.setObject(i3, this.lastDataRow.getObject(i3));
                            }
                            if (group != null && group.isKeepTogether()) {
                                blockEndRow.setEndsBlock(true);
                                blockStartAllowed = true;
                            }
                            group.reset();
                            if (group.isResultsInTitleRow()) {
                                if (!group.isKeepTogether()) continue;
                                blockEndRow = groupResultRow;
                                continue;
                            }
                            this.pushRow(groupResultRow);
                        }
                        this.groupStartRow = nextRow;
                        if (firstResultsInTitleGroupClosed) {
                            this.prefetchedRow = nextRow;
                            this.groupStartRow = null;
                            return this.fetchRow();
                        }
                        for (j = firstChangedGroupIdx; j <= lastChangedGroupIdx; ++j) {
                            group = groups[j];
                            if (group == null) continue;
                            if (!group.isViewTitleRow()) {
                                if (group.isStartNewPage() && pageBreakAllowed) {
                                    this.groupStartRow.setStartNewPage(true);
                                    pageBreakAllowed = false;
                                }
                                if (!group.isKeepTogether() || !blockStartAllowed) continue;
                                this.groupStartRow.setStartsBlock(true);
                                blockStartAllowed = false;
                                continue;
                            }
                            GroupRow groupTitleRow = new GroupRow(this.table, "groupTitle", group.getColumnName());
                            if (blockStartAllowed && group.isKeepTogether()) {
                                groupTitleRow.setStartsBlock(true);
                                blockStartAllowed = false;
                            }
                            if (group.isStartNewPage() && pageBreakAllowed) {
                                groupTitleRow.setStartNewPage(true);
                                pageBreakAllowed = false;
                            }
                            if (group.isKeepTogether() && blockStartAllowed) {
                                this.groupStartRow.setStartsBlock(true);
                                blockStartAllowed = false;
                            }
                            int numColumns = this.table.getColumnCount();
                            for (i3 = 0; i3 < numColumns; ++i3) {
                                groupTitleRow.setObject(i3, nextRow.getObject(i3));
                                if (i3 != group.getColumnIdx()) continue;
                                groupTitleRow.setVisible(i3, true);
                            }
                            group.setTitleRow(groupTitleRow);
                            this.groupStartRow = groupTitleRow;
                            this.pushRow(groupTitleRow);
                            if (!group.isHideAtSucceedingRows()) continue;
                        }
                    }
                }
                for (i = 0; i < functions.length; ++i) {
                    ReportFunction function = functions[i];
                    if (function == null) continue;
                    function.apply(nextRow.getObject(i));
                }
                for (i = 0; i < this.groups.length; ++i) {
                    ReportGroup group = this.groups[i];
                    if (group == null) continue;
                    int groupColIdx = group.getColumnIdx();
                    if (!group.isHideAtSucceedingRows() || firstChangedGroupIdx != -1 && groupColIdx >= firstChangedGroupIdx) continue;
                    nextRow.setVisible(group.getColumnIdx(), false);
                }
                this.pushRow(nextRow);
                this.lastDataRow = nextRow;
                if (!this.tableIterator.hasNext()) {
                    Row blockEndRow = this.lastDataRow;
                    for (int i4 = this.groups.length - 1; i4 >= 0; --i4) {
                        ReportGroup group = this.groups[i4];
                        if (group != null) {
                            if (!group.isFunctionsApplied()) {
                                if (group.isEnforceResultRow()) {
                                    blockEndRow = this.enforceResultRow(group);
                                }
                                if (!group.isKeepTogether()) continue;
                                blockEndRow.setEndsBlock(true);
                                blockStartAllowed = true;
                                continue;
                            }
                            double[] results = group.getGroupResults();
                            Row groupResultRow = null;
                            if (group.isResultsInTitleRow()) {
                                groupResultRow = group.getTitleRow();
                                group.setTitleRow(null);
                                if (group.isEnforceResultRow()) {
                                    blockEndRow = this.enforceResultRow(group);
                                }
                            } else {
                                blockEndRow = groupResultRow = new GroupRow(this.table, "group", group.getColumnName());
                            }
                            for (int j = 0; j < results.length; ++j) {
                                if (group.isFunctionsApplied(j)) {
                                    ReportFunction function = functions[j];
                                    groupResultRow.setDouble(j, group.getGroupResult(j));
                                    groupResultRow.setVisible(j, true);
                                    groupResultRow.setFormat(j, function.getFormat());
                                    groupResultRow.setAlign(j, function.getAlign());
                                    continue;
                                }
                                groupResultRow.setObject(j, this.lastDataRow.getObject(j));
                            }
                            group.reset();
                            if (!group.isResultsInTitleRow()) {
                                this.pushRow(groupResultRow);
                            }
                        }
                        if (group == null || !group.isKeepTogether()) continue;
                        blockEndRow.setEndsBlock(true);
                        blockStartAllowed = true;
                    }
                    boolean resultsCalculated = false;
                    for (int i5 = 0; i5 < functions.length; ++i5) {
                        ReportFunction f = functions[i5];
                        if (f == null || !f.isCalculateTotalResult()) continue;
                        resultsCalculated = true;
                        break;
                    }
                    if (resultsCalculated) {
                        DataRow footerRow = new DataRow(this.table, -1);
                        footerRow.setType("footer");
                        for (int i6 = 0; i6 < functions.length; ++i6) {
                            ReportFunction function = functions[i6];
                            if (function != null && function.isCalculateTotalResult()) {
                                footerRow.setDouble(i6, function.getTotalResult());
                                footerRow.setFormat(i6, function.getFormat());
                                footerRow.setAlign(i6, function.getAlign());
                                continue;
                            }
                            footerRow.setObject(i6, this.lastDataRow.getObject(i6));
                            footerRow.setVisible(i6, false);
                        }
                        this.pushRow(footerRow);
                    }
                    return this.fetchRow();
                }
                if (!this.hasGroupsWithResultsInTitle() && blockStartAllowed) break;
                nextRow = (Row)this.tableIterator.next();
                ++this.currentRowIdx;
            }
            return this.fetchRow();
        }
        catch (Exception ex) {
            throw new TableIterationException("Report iteration failed: " + ex.getMessage(), ex);
        }
    }

    private Row enforceResultRow(ReportGroup group) throws TableException {
        GroupRow enforcedResultRow = new GroupRow(this.table, "group", group.getColumnName());
        int numColumns = this.table.getColumnCount();
        for (int k = 0; k < numColumns; ++k) {
            enforcedResultRow.setObject(k, this.lastDataRow.getObject(k));
            if (k != group.getColumnIdx()) continue;
            enforcedResultRow.setVisible(k, false);
        }
        this.pushRow(enforcedResultRow);
        return enforcedResultRow;
    }

    private boolean hasGroupsWithResultsInTitle() {
        for (int i = 0; i < this.groups.length; ++i) {
            ReportGroup group = this.groups[i];
            if (group == null || !group.isResultsInTitleRow() || group.getTitleRow() == null) continue;
            return true;
        }
        return false;
    }

    public void remove() {
        throw new IllegalStateException("Removing rows is not permitted for reports!");
    }

    private boolean isRowBufferEmpty() {
        return this.rowBuffer.size() == 0;
    }

    private void pushRow(Row row) {
        this.rowBuffer.add(row);
    }

    private Row fetchRow() throws NoSuchElementException {
        int lastIdx = this.rowBuffer.size() - 1;
        if (lastIdx < 0) {
            throw new NoSuchElementException("Row buffer is empty!");
        }
        return (Row)this.rowBuffer.remove(0);
    }
}

