/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.table.BaseTable;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnAlreadyDefinedException;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.CompareItem;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.ReportFunction;
import org.ujac.util.table.ReportGroup;
import org.ujac.util.table.ReportIterator;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;
import org.ujac.util.text.FormatHelper;

public class ReportTable
extends BaseTable
implements Table {
    static final long serialVersionUID = 2769570291019778079L;
    private Table dataTable = null;
    private Column[] columns = null;
    private ReportFunction[] functions = null;
    private ReportGroup[] groups = null;

    public ReportTable(Table dataTable) {
        this.dataTable = dataTable;
        int numColumns = dataTable.getColumnCount();
        this.columns = new Column[numColumns];
        try {
            for (int i = 0; i < numColumns; ++i) {
                this.columns[i] = dataTable.getColumn(i);
            }
        }
        catch (ColumnNotDefinedException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        this.functions = new ReportFunction[numColumns];
        this.groups = new ReportGroup[numColumns];
    }

    public FormatHelper getFormatHelper() {
        return this.dataTable.getFormatHelper();
    }

    public void setFormatHelper(FormatHelper formatHelper) {
        this.dataTable.setFormatHelper(formatHelper);
    }

    public TypeConverter getTypeConverter() {
        return this.dataTable.getTypeConverter();
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.dataTable.setTypeConverter(typeConverter);
    }

    public Column getColumn(int index) throws ColumnNotDefinedException {
        return this.dataTable.getColumn(index);
    }

    public Column getColumn(String name) throws ColumnNotDefinedException {
        return this.dataTable.getColumn(name);
    }

    public int getColumnIndex(String name) throws ColumnNotDefinedException {
        return this.dataTable.getColumnIndex(name);
    }

    public void orderColumns(String[] columnNames) throws ColumnNotDefinedException, ColumnAlreadyDefinedException {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            String name = col.getName();
            columnMap.put(name, col);
        }
        HashSet<String> newColumnNames = new HashSet<String>();
        Column[] newColumns = new Column[this.columns.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            Column col = (Column)columnMap.get(name);
            if (col == null) {
                if (newColumnNames.contains(name)) {
                    throw new ColumnAlreadyDefinedException("The column '" + name + "' was specified in the given column order list more than once.");
                }
                throw new ColumnNotDefinedException("The column '" + name + "', specified in the given column order list does not exist.");
            }
            newColumns[i] = col;
            newColumnNames.add(name);
            columnMap.remove(name);
        }
        if (columnMap.size() > 0) {
            Column[] rest = new Column[columnMap.size()];
            int idx = 0;
            Iterator iterRest = columnMap.entrySet().iterator();
            while (iterRest.hasNext()) {
                rest[idx] = (Column)iterRest.next().getValue();
                ++idx;
            }
            Arrays.sort(rest, new Comparator(){

                public int compare(Object a, Object b) {
                    int idxB;
                    int idxA = ((Column)a).getIndex();
                    if (idxA > (idxB = ((Column)b).getIndex())) {
                        return 1;
                    }
                    if (idxA < idxB) {
                        return -1;
                    }
                    return 0;
                }
            });
            int nextIdx = columnNames.length;
            for (int i = 0; i < rest.length; ++i) {
                Column col;
                newColumns[nextIdx] = col = rest[i];
                ++nextIdx;
            }
        }
        this.columns = newColumns;
    }

    public Column[] getVisibleColumns() {
        int numVisibleColumns = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            LayoutHints lh = col.getLayoutHints();
            if (lh == null || !lh.isVisible()) continue;
            ++numVisibleColumns;
        }
        int nextIdx = 0;
        Column[] visibleColumns = new Column[numVisibleColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            LayoutHints lh = col.getLayoutHints();
            if (lh == null || !lh.isVisible()) continue;
            visibleColumns[nextIdx] = col;
            ++nextIdx;
        }
        return visibleColumns;
    }

    public Column[] getVisibleColumns(int levelFilter) {
        int numVisibleColumns = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            LayoutHints lh = col.getLayoutHints();
            if (lh == null || !lh.isVisible() || levelFilter >= 0 && lh.getLevel() > levelFilter) continue;
            ++numVisibleColumns;
        }
        int nextIdx = 0;
        Column[] visibleColumns = new Column[numVisibleColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column col = this.columns[i];
            LayoutHints lh = col.getLayoutHints();
            if (lh == null || !lh.isVisible()) continue;
            visibleColumns[nextIdx] = col;
            ++nextIdx;
        }
        return visibleColumns;
    }

    public Row getHeaderRow() {
        return this.dataTable.getHeaderRow();
    }

    public Iterator iterator() {
        ReportGroup[] groups = new ReportGroup[this.groups.length];
        for (int i = 0; i < groups.length; ++i) {
            ReportGroup g = this.groups[i];
            if (g == null) continue;
            groups[i] = (ReportGroup)g.clone();
            groups[i].init(this);
        }
        ReportFunction[] functions = new ReportFunction[this.functions.length];
        for (int i = 0; i < functions.length; ++i) {
            ReportFunction f = this.functions[i];
            if (f == null) continue;
            functions[i] = (ReportFunction)f.clone();
            functions[i].init(this, groups);
        }
        return new ReportIterator(this, functions, groups);
    }

    public void addGroup(ReportGroup group) throws ColumnNotDefinedException {
        int groupIdx = this.dataTable.getColumnIndex(group.getColumnName());
        group.setColumnIdx(groupIdx);
        this.groups[groupIdx] = group;
    }

    public void addFunction(ReportFunction function) throws ColumnNotDefinedException {
        int functionIdx = this.dataTable.getColumnIndex(function.getColumnName());
        function.setColumnIdx(functionIdx);
        this.functions[functionIdx] = function;
    }

    public int getColumnCount() {
        return this.dataTable.getColumnCount();
    }

    public ReportFunction[] getFunctions() {
        return this.functions;
    }

    public ReportGroup[] getGroups() {
        return this.groups;
    }

    protected Table getDataTable() {
        return this.dataTable;
    }

    public Column addColumn(String name, int type) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Column addColumn(String name, int type, LayoutHints layoutHints) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addString(String name, String value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addInt(String name, int value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addLong(String name, long value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addFloat(String name, float value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addDouble(String name, double value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addBoolean(String name, boolean value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addDate(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addTime(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public Table addTimestamp(String name, Date value) throws TableException {
        this.throwNotSupportedException();
        return null;
    }

    public boolean isEmpty() {
        return this.dataTable.isEmpty();
    }

    public int getRowCount() throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return 0;
    }

    public Row addRow() throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Row addRow(Row srcRow) throws OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public Row getRow(int rowIdx) throws RowNotDefinedException, OperationNotSupportedException {
        this.throwNotSupportedException();
        return null;
    }

    public void removeRow(int rowIdx) throws RowNotDefinedException, OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public String getString(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getString(rowIdx, columnIdx);
    }

    public String getString(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getString(rowIdx, columnName);
    }

    public void setString(int rowIdx, int columnIdx, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setString(rowIdx, columnIdx, value);
    }

    public void setString(int rowIdx, String columnName, String value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setString(rowIdx, columnName, value);
    }

    public int getInt(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getInt(rowIdx, columnIdx);
    }

    public int getInt(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getInt(rowIdx, columnName);
    }

    public void setInt(int rowIdx, int columnIdx, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setInt(rowIdx, columnIdx, value);
    }

    public void setInt(int rowIdx, String columnName, int value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setInt(rowIdx, columnName, value);
    }

    public long getLong(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getLong(rowIdx, columnIdx);
    }

    public long getLong(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getLong(rowIdx, columnName);
    }

    public void setLong(int rowIdx, int columnIdx, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setLong(rowIdx, columnIdx, value);
    }

    public void setLong(int rowIdx, String columnName, long value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setLong(rowIdx, columnName, value);
    }

    public float getFloat(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getFloat(rowIdx, columnIdx);
    }

    public float getFloat(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getFloat(rowIdx, columnName);
    }

    public void setFloat(int rowIdx, int columnIdx, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setFloat(rowIdx, columnIdx, value);
    }

    public void setFloat(int rowIdx, String columnName, float value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setFloat(rowIdx, columnName, value);
    }

    public double getDouble(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getDouble(rowIdx, columnIdx);
    }

    public double getDouble(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getDouble(rowIdx, columnName);
    }

    public void setDouble(int rowIdx, int columnIdx, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setDouble(rowIdx, columnIdx, value);
    }

    public void setDouble(int rowIdx, String columnName, double value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setDouble(rowIdx, columnName, value);
    }

    public boolean getBoolean(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getBoolean(rowIdx, columnIdx);
    }

    public boolean getBoolean(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getBoolean(rowIdx, columnName);
    }

    public void setBoolean(int rowIdx, int columnIdx, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setBoolean(rowIdx, columnIdx, value);
    }

    public void setBoolean(int rowIdx, String columnName, boolean value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setBoolean(rowIdx, columnName, value);
    }

    public Date getDate(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getDate(rowIdx, columnIdx);
    }

    public Date getDate(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getDate(rowIdx, columnName);
    }

    public void setDate(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setDate(rowIdx, columnIdx, value);
    }

    public void setDate(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setDate(rowIdx, columnName, value);
    }

    public Date getTime(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getTime(rowIdx, columnIdx);
    }

    public Date getTime(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getTime(rowIdx, columnName);
    }

    public void setTime(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setTime(rowIdx, columnIdx, value);
    }

    public void setTime(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setTime(rowIdx, columnName, value);
    }

    public Date getTimestamp(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getTimestamp(rowIdx, columnIdx);
    }

    public Date getTimestamp(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        return this.dataTable.getTimestamp(rowIdx, columnName);
    }

    public void setTimestamp(int rowIdx, int columnIdx, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setTimestamp(rowIdx, columnIdx, value);
    }

    public void setTimestamp(int rowIdx, String columnName, Date value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setTimestamp(rowIdx, columnName, value);
    }

    public Object getObject(int rowIdx, int columnIdx) throws RowNotDefinedException, ColumnNotDefinedException {
        return this.dataTable.getObject(rowIdx, columnIdx);
    }

    public Object getObject(int rowIdx, String columnName) throws RowNotDefinedException, ColumnNotDefinedException {
        return this.dataTable.getObject(rowIdx, columnName);
    }

    public void setObject(int rowIdx, int columnIdx, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setObject(rowIdx, columnIdx, value);
    }

    public void setObject(int rowIdx, String columnName, Object value) throws RowNotDefinedException, ColumnNotDefinedException, TypeMismatchException {
        this.dataTable.setObject(rowIdx, columnName, value);
    }

    public void sort(CompareItem[] compareColumns) throws OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public void sort(int columnIdx, int direction) throws OperationNotSupportedException {
        this.throwNotSupportedException();
    }

    public void setColumnType(int columnIdx, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        this.dataTable.setColumnType(columnIdx, typeId);
    }

    public void setColumnType(String columnName, int typeId) throws ColumnNotDefinedException, TypeConverterException {
        this.dataTable.setColumnType(columnName, typeId);
    }

    private void throwNotSupportedException() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("This operation is not supported for report tables.");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.dataTable);
        s.writeObject(this.columns);
        s.writeObject(this.functions);
        s.writeObject(this.groups);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.dataTable = (Table)s.readObject();
        this.columns = (Column[])s.readObject();
        this.functions = (ReportFunction[])s.readObject();
        this.groups = (ReportGroup[])s.readObject();
    }
}

