/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.util.Iterator;
import org.ujac.util.table.ResultSetTable;
import org.ujac.util.table.TableIterationException;

public class ResultSetTableIterator
implements Iterator {
    private ResultSetTable table;
    private int currentRow = -1;

    protected ResultSetTableIterator(ResultSetTable table) {
        this.table = table;
    }

    public boolean hasNext() {
        return this.table.checkNextRow();
    }

    public Object next() {
        try {
            return this.table.getRow(++this.currentRow);
        }
        catch (Exception ex) {
            throw new TableIterationException("Table iteration failed: " + ex.getMessage(), ex);
        }
    }

    public void remove() {
        if (this.currentRow < 0) {
            throw new IllegalStateException("The the next method has not yet been called.");
        }
        try {
            this.table.removeRow(this.currentRow);
        }
        catch (Exception ex) {
            throw new TableIterationException("Table iteration failed: " + ex.getMessage(), ex);
        }
    }
}

