/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.table;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.Format;
import java.util.Iterator;
import java.util.Locale;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TableHelper;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.xml.BaseObjectSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableSerializer
extends BaseObjectSerializer {
    public static final String TAG_TABLE = "table";
    public static final String TAG_COLUMNS = "columns";
    public static final String TAG_COLUMN = "column";
    public static final String TAG_HEADER = "header";
    public static final String TAG_LAYOUT_HINTS = "layout-hints";
    public static final String TAG_ROWS = "rows";
    public static final String TAG_ROW = "row";
    public static final String TAG_CELL = "cell";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_ALIAS = "alias";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_ALIGN = "align";
    public static final String ATTR_HEADER_ALIGN = "header-align";
    public static final String ATTR_LEVEL = "level";
    public static final String ATTR_COLUMN = "column";

    public TableSerializer() {
    }

    public TableSerializer(String encoding) {
        super(encoding);
    }

    public void write(PrintWriter writer, Object obj) throws IOException {
        super.write(writer, obj);
        Table table = (Table)obj;
        this.indent(writer, 0);
        this.writeOpenTag(writer, TAG_TABLE, false, true);
        int numColumns = table.getColumnCount();
        try {
            this.indent(writer, 1);
            this.writeOpenTag(writer, TAG_COLUMNS, false, true);
            Format[] origFormats = new Format[numColumns];
            FormatHelper fh = table.getFormatHelper();
            for (int i = 0; i < numColumns; ++i) {
                Column col = table.getColumn(i);
                origFormats[i] = col.getFormat();
                this.indent(writer, 2);
                this.writeOpenTag(writer, "column", true, false);
                this.writeAttribute(writer, ATTR_NAME, col.getName());
                this.writeAttribute(writer, ATTR_TYPE, col.getTypeName());
                String alias = col.getAlias();
                if (alias != null) {
                    this.writeAttribute(writer, ATTR_ALIAS, alias);
                }
                switch (col.getType()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        col.setFormat(fh.getDefaultIntegerFormat(Locale.US));
                        break;
                    }
                    case 5: 
                    case 6: {
                        col.setFormat(fh.getDefaultDoubleFormat(Locale.US));
                        break;
                    }
                    case 8: {
                        col.setFormat(fh.getIsoDateFormat());
                        break;
                    }
                    case 9: {
                        col.setFormat(fh.getIsoTimeFormat());
                        break;
                    }
                    case 10: {
                        col.setFormat(fh.getIsoTimestampFormat());
                    }
                }
                this.closeOpenTag(writer, false, true);
                LayoutHints lh = col.getLayoutHints();
                if (lh != null) {
                    this.indent(writer, 3);
                    this.writeOpenTag(writer, TAG_LAYOUT_HINTS, true, false);
                    this.writeAttribute(writer, ATTR_WIDTH, Float.toString(lh.getWidth()));
                    this.writeAttribute(writer, ATTR_ALIGN, lh.getAlignText());
                    this.writeAttribute(writer, ATTR_HEADER_ALIGN, lh.getHeaderAlignText());
                    this.writeAttribute(writer, ATTR_LEVEL, Integer.toString(lh.getLevel()));
                    String header = lh.getHeader();
                    if (BeanUtils.isEmpty(header)) {
                        this.closeOpenTag(writer, true, true);
                    } else {
                        this.closeOpenTag(writer, false, true);
                        this.indent(writer, 4);
                        this.writeTag(writer, TAG_HEADER, header, true);
                        this.indent(writer, 3);
                        this.writeCloseTag(writer, TAG_LAYOUT_HINTS, true);
                    }
                }
                this.indent(writer, 2);
                this.writeCloseTag(writer, "column", true);
            }
            this.indent(writer, 1);
            this.writeCloseTag(writer, TAG_COLUMNS, true);
            this.indent(writer, 1);
            this.writeOpenTag(writer, TAG_ROWS, false, true);
            Iterator iterRows = table.iterator();
            while (iterRows.hasNext()) {
                Row row = (Row)iterRows.next();
                this.indent(writer, 2);
                this.writeOpenTag(writer, TAG_ROW, false, true);
                for (int i = 0; i < numColumns; ++i) {
                    String value = row.getString(i);
                    if (value == null) continue;
                    Column col = table.getColumn(i);
                    int type = col.getType();
                    this.indent(writer, 3);
                    this.writeOpenTag(writer, TAG_CELL, true, false);
                    this.writeAttribute(writer, "column", col.getName());
                    this.closeOpenTag(writer, false, false);
                    switch (type) {
                        case 1: 
                        case 11: {
                            this.writeTagBody(writer, row.getString(i), true);
                            break;
                        }
                        default: {
                            this.writeTagBody(writer, row.getString(i), false);
                        }
                    }
                    this.writeCloseTag(writer, TAG_CELL, true);
                }
                this.indent(writer, 2);
                this.writeCloseTag(writer, TAG_ROW, true);
            }
            this.indent(writer, 1);
            this.writeCloseTag(writer, TAG_ROWS, true);
            for (int i = 0; i < numColumns; ++i) {
                Column col = table.getColumn(i);
                col.setFormat(origFormats[i]);
            }
        }
        catch (TableException ex) {
            throw new RuntimeException("Unable to serialize table: " + ex.getMessage(), ex);
        }
        this.indent(writer, 0);
        this.writeCloseTag(writer, TAG_TABLE, false);
    }

    public void startElement(BaseObjectSerializer.StackElement localElement, BaseObjectSerializer.StackElement parentElement, Object root) throws SAXException {
        Attributes localAttrs = localElement.getAttributes();
        String name = localElement.getName();
        if (TAG_TABLE.equals(name)) {
            DataTable table = new DataTable();
            localElement.setData(table);
        } else if (TAG_COLUMNS.equals(name)) {
            localElement.setData(parentElement.getData());
        } else {
            if ("column".equals(name)) {
                Table table = (Table)parentElement.getData();
                FormatHelper fh = table.getFormatHelper();
                String colName = localAttrs.getValue(ATTR_NAME);
                String colTypeName = localAttrs.getValue(ATTR_TYPE);
                try {
                    int colType = TableHelper.getColumnTypeId(colTypeName);
                    Column col = table.addColumn(colName, colType);
                    String colAlias = localAttrs.getValue(ATTR_ALIAS);
                    if (!BeanUtils.isEmpty(colAlias)) {
                        col.setAlias(colAlias);
                    }
                    switch (col.getType()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            col.setFormat(fh.getDefaultIntegerFormat(Locale.US));
                            break;
                        }
                        case 5: 
                        case 6: {
                            col.setFormat(fh.getDefaultDoubleFormat(Locale.US));
                            break;
                        }
                        case 8: {
                            col.setFormat(fh.getIsoDateFormat());
                            break;
                        }
                        case 9: {
                            col.setFormat(fh.getIsoTimeFormat());
                            break;
                        }
                        case 10: {
                            col.setFormat(fh.getIsoTimestampFormat());
                        }
                    }
                    localElement.setData(col);
                }
                catch (TableException ex) {
                    throw new SAXException("Failed to handle attributes of column '" + colName + "': " + ex.getMessage(), ex);
                }
            }
            if (TAG_LAYOUT_HINTS.equals(name)) {
                Column col = (Column)parentElement.getData();
                String strWidth = localAttrs.getValue(ATTR_WIDTH);
                String strAlign = localAttrs.getValue(ATTR_ALIGN);
                String strHeaderAlign = localAttrs.getValue(ATTR_HEADER_ALIGN);
                String strLevel = localAttrs.getValue(ATTR_LEVEL);
                try {
                    float width = Float.parseFloat(strWidth);
                    int align = TableHelper.getAlignmentId(strAlign);
                    LayoutHints lh = new LayoutHints(width, null, align);
                    int headerAlign = TableHelper.getAlignmentId(strHeaderAlign);
                    lh.setHeaderAlign(headerAlign);
                    int level = Integer.parseInt(strLevel);
                    lh.setLevel(level);
                    col.setLayoutHints(lh);
                    localElement.setData(lh);
                }
                catch (NumberFormatException ex) {
                    throw new SAXException("Failed to handle layout hints of column '" + col.getName() + "': " + ex.getMessage(), ex);
                }
            }
            if (TAG_ROWS.equals(name)) {
                localElement.setData(parentElement.getData());
            } else if (TAG_ROW.equals(name)) {
                Table table = (Table)parentElement.getData();
                try {
                    localElement.setData(table.addRow());
                }
                catch (TableException ex) {
                    throw new SAXException("Failed to add row to table: " + ex.getMessage(), ex);
                }
            }
        }
    }

    public void endElement(BaseObjectSerializer.StackElement localElement, String content, BaseObjectSerializer.StackElement parentElement, Object root) throws SAXException {
        String name = localElement.getName();
        if (TAG_HEADER.equals(name)) {
            LayoutHints lh = (LayoutHints)parentElement.getData();
            lh.setHeader(content.trim());
        } else {
            if (TAG_CELL.equals(name)) {
                Row row = (Row)parentElement.getData();
                String colName = localElement.getAttributes().getValue("column");
                try {
                    row.setString(colName, content);
                }
                catch (TableException ex) {
                    try {
                        throw new SAXException("Failed to set value '" + content + "' for column '" + colName + "' with type " + row.getTable().getColumn(colName).getTypeName() + ": " + ex.getMessage(), ex);
                    }
                    catch (ColumnNotDefinedException cnex) {
                        throw new SAXException("Failed to set value '" + content + "' for undefined column '" + colName + "': " + ex.getMessage(), ex);
                    }
                }
            }
            if (TAG_TABLE.equals(name)) {
                Table table = (Table)localElement.getData();
                FormatHelper fh = table.getFormatHelper();
                int numColumns = table.getColumnCount();
                try {
                    block13: for (int i = 0; i < numColumns; ++i) {
                        Column col = table.getColumn(i);
                        switch (col.getType()) {
                            case 2: 
                            case 3: 
                            case 4: {
                                col.setFormat(fh.getIntegerFormat());
                                continue block13;
                            }
                            case 5: 
                            case 6: {
                                col.setFormat(fh.getDoubleFormat());
                                continue block13;
                            }
                            case 8: {
                                col.setFormat(fh.getDateFormat());
                                continue block13;
                            }
                            case 9: {
                                col.setFormat(fh.getTimeFormat());
                                continue block13;
                            }
                            case 10: {
                                col.setFormat(fh.getTimestampFormat());
                            }
                        }
                    }
                }
                catch (TableException ex) {
                    throw new SAXException("Failed to restore default column formats: " + ex.getMessage(), ex);
                }
            }
        }
    }
}

