/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ujac.util.CollectionUtils;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.ProcedureToken;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class CallprocToken
extends TemplateToken {
    private static final long serialVersionUID = 3762530096761942838L;
    private String procName = null;
    private List arguments = null;

    public String getTokenName() {
        return "callproc";
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        int endPos = this.parseArguments();
        this.setLength(endPos - position);
    }

    public void setArgument(Operand argument, int idx) {
        if (idx == 0) {
            this.procName = argument.getValue().toString();
            return;
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(argument);
    }

    public List getArguments() {
        return this.arguments;
    }

    public void execute(Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        Map procedureRegistry = this.getParent().getProcedureRegistry();
        ProcedureToken proc = (ProcedureToken)procedureRegistry.get(this.procName);
        if (proc == null) {
            throw new ExpressionException("No procedure registered with name '" + this.procName + "'.");
        }
        int numArgs = CollectionUtils.getSize(this.arguments);
        ArrayList<Object> argValues = new ArrayList<Object>(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Operand arg = (Operand)this.arguments.get(i);
            argValues.add(this.interpreter.evalObjectExpr(arg, ctx));
        }
        proc.execute(argValues, writer, ctx);
    }

    public String toString() {
        return this.getIndention() + "_callproc_ " + this.procName + "(" + this.getArgumentsAsString() + ")\n";
    }

    protected String getArgumentsAsString() {
        StringBuffer ab = new StringBuffer();
        int numArguments = this.arguments.size();
        List argumentNames = this.getArguments();
        for (int i = 0; i < numArguments; ++i) {
            if (i > 0) {
                ab.append(", ");
            }
            ab.append(argumentNames.get(i));
        }
        return ab.toString();
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        CallprocToken clone = (CallprocToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        int numOperands = CollectionUtils.getSize(clone.arguments);
        for (int i = 0; i < numOperands; ++i) {
            clone.arguments.set(i, ((Operand)clone.arguments.get(i)).clone());
        }
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

