/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.SequenceIndex;
import org.ujac.util.table.Table;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;
import org.ujac.util.template.TokenAncestor;

public class ForeachToken
extends TemplateTokenContainer {
    private static final long serialVersionUID = 3256999947785286963L;
    public static final TokenAncestor[] ancestorRules = new TokenAncestor[]{new TokenAncestor("endfor")};
    private static final Class[] ITERATOR_ATTRIBUTES = new Class[0];
    private static final Object[] ITERATOR_PARAMETERS = new Object[0];
    private String loopVariable = null;
    private Operand sequence = null;
    private String evenStyle = null;
    private String oddStyle = null;

    public String getTokenName() {
        return "foreach";
    }

    public TokenAncestor[] getAncestorRules() {
        return ancestorRules;
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        this.setBodyStart(this.parseArguments() + 1);
    }

    public void setArgument(Operand argument, int idx) throws StatementException {
        switch (idx) {
            case 0: {
                this.loopVariable = argument.getValue().toString();
                break;
            }
            case 1: {
                this.sequence = argument;
                break;
            }
            case 2: {
                this.evenStyle = argument.getValue().toString();
                break;
            }
            case 3: {
                this.oddStyle = argument.getValue().toString();
                break;
            }
            default: {
                throw new StatementException("The log statement may take maximum four argument only.");
            }
        }
    }

    public void execute(Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        Iterator iter = this.getSequenceIterator(ctx);
        if (iter == null) {
            return;
        }
        String loopIndexVariable = this.loopVariable + "Idx";
        String loopStyleVariable = this.loopVariable + "Style";
        SequenceIndex idx = new SequenceIndex(0);
        ctx.setProperty(loopIndexVariable, idx);
        while (iter.hasNext()) {
            Object loopValue = iter.next();
            ctx.setProperty(this.loopVariable, loopValue);
            if (idx.intValue() % 2 == 0) {
                ctx.setProperty(loopStyleVariable, this.evenStyle);
            } else {
                ctx.setProperty(loopStyleVariable, this.oddStyle);
            }
            int numTokens = this.getTokenCount();
            for (int i = 0; i < numTokens; ++i) {
                TemplateToken subToken = this.getToken(i);
                subToken.execute(writer, ctx);
            }
            idx.increment();
        }
    }

    private Iterator getSequenceIterator(TemplateContext ctx) throws ExpressionException {
        Object sequenceHolder = this.interpreter.evalObjectExpr(this.sequence, ctx);
        if (sequenceHolder == null) {
            return null;
        }
        if (sequenceHolder instanceof Collection) {
            return ((Collection)sequenceHolder).iterator();
        }
        if (sequenceHolder instanceof Iterator) {
            return (Iterator)sequenceHolder;
        }
        if (sequenceHolder instanceof Map) {
            return ((Map)sequenceHolder).keySet().iterator();
        }
        if (sequenceHolder instanceof Table) {
            return ((Table)sequenceHolder).iterator();
        }
        if (sequenceHolder instanceof Object[]) {
            List<Object> sequenceList = Arrays.asList((Object[])sequenceHolder);
            return sequenceList.iterator();
        }
        if (sequenceHolder instanceof String) {
            StringTokenizer strTkn = new StringTokenizer(sequenceHolder.toString(), "-");
            if (strTkn.countTokens() == 2) {
                String strFrom = strTkn.nextToken();
                String strTo = strTkn.nextToken();
                int from = -1;
                try {
                    from = Integer.parseInt(strFrom);
                }
                catch (NumberFormatException ex) {
                    throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
                }
                int to = -1;
                try {
                    to = Integer.parseInt(strTo);
                }
                catch (NumberFormatException ex) {
                    throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
                }
                ArrayList<Integer> sequence = new ArrayList<Integer>();
                for (int i = from; i <= to; ++i) {
                    sequence.add(new Integer(i));
                }
                return sequence.iterator();
            }
            strTkn = new StringTokenizer(sequenceHolder.toString(), ",");
            if (strTkn.countTokens() < 2) {
                throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.");
            }
            ArrayList<String> sequence = new ArrayList<String>();
            while (strTkn.hasMoreTokens()) {
                sequence.add(strTkn.nextToken());
            }
            return sequence.iterator();
        }
        try {
            Method iteratorMethod = sequenceHolder.getClass().getMethod("iterator", ITERATOR_ATTRIBUTES);
            return (Iterator)iteratorMethod.invoke(sequenceHolder, ITERATOR_PARAMETERS);
        }
        catch (SecurityException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
        catch (ClassCastException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new StatementException("The _foreach_ sequence doesn't evaluate to a valid sequence.", ex);
        }
    }

    public String toString() {
        return this.getIndention() + "_foreach_(" + this.getArgumentsAsString() + ")\n" + super.toString();
    }

    protected String getArgumentsAsString() {
        return this.loopVariable + ", " + this.sequence.toString();
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        ForeachToken clone = (ForeachToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.sequence = (Operand)this.sequence.clone();
        clone.cloneChildTokens(this.procedureRegistry, this);
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }
}

