/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.template;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ujac.util.BeanUtils;
import org.ujac.util.exi.Operand;
import org.ujac.util.template.BaseTemplateInterpreter;
import org.ujac.util.template.StatementException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateRoot;
import org.ujac.util.template.TemplateToken;
import org.ujac.util.template.TemplateTokenContainer;

public class LogToken
extends TemplateToken {
    private static final long serialVersionUID = 3688503294611895861L;
    private static final Map LOG_LEVELS = new HashMap();
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final int ERROR = 4;
    private static final int FATAL = 5;
    private Operand logLevel = null;
    private Operand logMessage = null;
    private TemplateRoot logMessageTemplate = null;

    public String getTokenName() {
        return "log";
    }

    public void initialize(BaseTemplateInterpreter interpreter, char[] source, int position, int length) throws TemplateException {
        super.initialize(interpreter, source, position, length);
        int endPos = this.parseArguments();
        this.setLength(endPos - position);
        try {
            this.logMessageTemplate = interpreter.parse(BeanUtils.toString(this.logMessage.getValue()));
        }
        catch (IOException ex) {
            throw new StatementException("_log_ parameter parsing failed: " + ex.getMessage(), ex);
        }
    }

    public void setArgument(Operand argument, int idx) throws StatementException {
        switch (idx) {
            case 0: {
                this.logLevel = argument;
                break;
            }
            case 1: {
                this.logMessage = argument;
                break;
            }
            default: {
                throw new StatementException("The log statement may take two argument only.");
            }
        }
    }

    public void execute(Writer writer, TemplateContext ctx) throws TemplateException, IOException {
        Log log = LogFactory.getLog((String)"TemplateInterpreter");
        String logLevel = BeanUtils.toString(this.logLevel.getValue());
        StringWriter sw = new StringWriter();
        this.interpreter.execute(this.logMessageTemplate, (Writer)sw, ctx);
        String logMessage = sw.toString();
        Integer levelId = (Integer)LOG_LEVELS.get(logLevel);
        switch (levelId) {
            case 1: {
                log.debug((Object)logMessage);
                break;
            }
            case 2: {
                log.info((Object)logMessage);
                break;
            }
            case 3: {
                log.warn((Object)logMessage);
                break;
            }
            case 4: {
                log.error((Object)logMessage);
                break;
            }
            case 5: {
                log.fatal((Object)logMessage);
                break;
            }
            default: {
                log.info((Object)logMessage);
            }
        }
    }

    public String toString() {
        return this.getIndention() + "_log_(" + this.getArgumentsAsString() + ")\n";
    }

    protected TemplateToken cloneToken(BaseTemplateInterpreter interpreter, TemplateTokenContainer parent) {
        LogToken clone = (LogToken)this.clone();
        clone.interpreter = interpreter;
        clone.parent = parent;
        clone.logLevel = (Operand)this.logLevel.clone();
        clone.logMessage = (Operand)this.logMessage.clone();
        clone.logMessageTemplate = (TemplateRoot)clone.logMessageTemplate.cloneToken(interpreter, parent);
        return clone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone template token: " + ex.getMessage(), ex);
        }
    }

    static {
        LOG_LEVELS.put("debug", new Integer(1));
        LOG_LEVELS.put("DEBUG", new Integer(1));
        LOG_LEVELS.put("info", new Integer(2));
        LOG_LEVELS.put("INFO", new Integer(2));
        LOG_LEVELS.put("warn", new Integer(3));
        LOG_LEVELS.put("WARN", new Integer(3));
        LOG_LEVELS.put("error", new Integer(4));
        LOG_LEVELS.put("ERROR", new Integer(4));
        LOG_LEVELS.put("fatal", new Integer(5));
        LOG_LEVELS.put("FATAL", new Integer(5));
    }
}

