/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.types;

import org.ujac.util.BeanUtils;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.DataType;

public class LongType
implements DataType {
    public int getTypeId() {
        return 4;
    }

    public Object convertObject(Object value, FormatHelper formatHelper) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        String strVal = value.toString();
        try {
            long val = Long.parseLong(strVal);
            return new Long(val);
        }
        catch (NumberFormatException ex) {
            throw new TypeConverterException("Failed to parse long value out of given value '" + strVal + "'.", ex);
        }
    }

    public String formatValue(Object value, FormatHelper formatHelper) throws TypeConverterException {
        return BeanUtils.toString(this.convertObject(value, formatHelper));
    }
}

