/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.ujac.util.BeanUtils;
import org.ujac.util.xml.ComplexTypeDefinition;
import org.ujac.util.xml.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseObjectSerializer {
    private String encoding = "UTF-8";
    private XMLReader xmlReader;
    private ObjectHandler contentHandler = new ObjectHandler();
    protected BaseObjectSerializer parentSerializer;
    private int rootLevel = 0;

    public BaseObjectSerializer() {
    }

    public BaseObjectSerializer(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public Object getRootObject() {
        return this.contentHandler.getRoot();
    }

    public int getRootLevel() {
        return this.rootLevel;
    }

    public void setRootLevel(int rootLevel) {
        this.rootLevel = rootLevel;
    }

    public Object read(InputStream is) throws SAXException, IOException {
        InputSource formSource = new InputSource(is);
        return this.read(formSource);
    }

    public Object read(Reader reader) throws SAXException, IOException {
        InputSource formSource = new InputSource(reader);
        return this.read(formSource);
    }

    public Object read(InputSource src) throws SAXException, IOException {
        this.xmlReader = XmlUtils.createXmlReader(null);
        this.xmlReader.setContentHandler(this.contentHandler);
        this.xmlReader.parse(src);
        return this.contentHandler.getRoot();
    }

    public void write(OutputStream os, Object obj) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        this.write(osw, obj);
        osw.flush();
    }

    public void write(Writer writer, Object obj) throws IOException {
        this.write(new PrintWriter(writer), obj);
    }

    public void write(PrintWriter writer, Object obj) throws IOException {
        if (this.rootLevel == 0) {
            writer.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        }
    }

    public void writeTagBody(PrintWriter writer, Object value, boolean cData) {
        if (cData) {
            writer.print("<![CDATA[");
        }
        writer.print(value);
        if (cData) {
            writer.print("]]>");
        }
    }

    public void writeAttribute(PrintWriter writer, String name, String value) {
        if (value == null) {
            return;
        }
        writer.print(" ");
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.print("\"");
    }

    public void writeAttribute(PrintWriter writer, String name, boolean value) {
        if (!value) {
            return;
        }
        writer.print(" ");
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.print("=\"");
    }

    public void writeAttribute(PrintWriter writer, String name, int value) {
        writer.print(" ");
        writer.print(name);
        writer.print("=\"");
        writer.print(value);
        writer.print("=\"");
    }

    public void indent(PrintWriter writer, int level) {
        int absoluteLevel = this.rootLevel + level;
        for (int i = 0; i < absoluteLevel; ++i) {
            writer.write("\t");
        }
    }

    public void startNewLine(PrintWriter writer) {
        writer.write("\n");
    }

    public void writeOpenTag(PrintWriter writer, String name, boolean leaveOpen, boolean newLine) {
        writer.print("<");
        writer.print(name);
        if (leaveOpen) {
            return;
        }
        if (newLine) {
            writer.println(">");
        } else {
            writer.print(">");
        }
    }

    public void closeOpenTag(PrintWriter writer, boolean bodyLess, boolean newLine) {
        if (bodyLess) {
            writer.print("/");
        }
        if (newLine) {
            writer.println(">");
        } else {
            writer.print(">");
        }
    }

    public void writeCloseTag(PrintWriter writer, String name, boolean newLine) {
        writer.print("</");
        writer.print(name);
        if (newLine) {
            writer.println(">");
            return;
        }
        writer.print(">");
    }

    public void writeTag(PrintWriter writer, String name, Object value, boolean isCData) {
        if (value == null) {
            return;
        }
        writer.print("<");
        writer.print(name);
        writer.print(">");
        if (isCData) {
            writer.print("<![CDATA[");
        }
        writer.print(value);
        if (isCData) {
            writer.print("]]>");
        }
        writer.print("</");
        writer.print(name);
        writer.println(">");
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void delegateHandler(BaseObjectSerializer delegate) throws SAXException {
        delegate.contentHandler.startDocument();
        delegate.parentSerializer = this;
        delegate.xmlReader = this.xmlReader;
        this.xmlReader.setContentHandler(delegate.contentHandler);
    }

    public abstract void startElement(StackElement var1, StackElement var2, Object var3) throws SAXException;

    public abstract void endElement(StackElement var1, String var2, StackElement var3, Object var4) throws SAXException;

    protected int parseIntValue(String string, int defaultValue) {
        if (BeanUtils.isEmpty(string)) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }

    protected boolean parseBooleanValue(String string, boolean defaultValue) {
        if (BeanUtils.isEmpty(string)) {
            return defaultValue;
        }
        return new Boolean(string);
    }

    public class ObjectHandler
    extends DefaultHandler {
        private Object root = null;
        private StringBuffer contentBuf = new StringBuffer();
        private List elementStack = null;

        public Object getRoot() {
            return this.root;
        }

        public void startDocument() throws SAXException {
            this.root = null;
            this.elementStack = new ArrayList();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.contentBuf.setLength(0);
            StackElement parentElement = this.topElement();
            StackElement localElement = new StackElement(localName, new AttributesImpl(attributes), this.elementStack.size());
            BaseObjectSerializer.this.startElement(localElement, parentElement, this.root);
            if (parentElement == null) {
                this.root = localElement.getData();
            }
            this.pushElement(localElement);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentBuf.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            StackElement localElement = this.popElement();
            StackElement parentElement = this.topElement();
            BaseObjectSerializer.this.endElement(localElement, this.contentBuf.toString(), parentElement, this.root);
            if (this.elementStack.isEmpty() && BaseObjectSerializer.this.parentSerializer != null) {
                BaseObjectSerializer.this.xmlReader.setContentHandler(BaseObjectSerializer.this.parentSerializer.contentHandler);
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        private StackElement popElement() {
            int currentIdx = this.elementStack.size() - 1;
            return (StackElement)this.elementStack.remove(currentIdx);
        }

        private StackElement topElement() {
            int currentIdx = this.elementStack.size() - 1;
            if (currentIdx < 0) {
                return null;
            }
            return (StackElement)this.elementStack.get(currentIdx);
        }

        private void pushElement(StackElement element) {
            this.elementStack.add(element);
        }
    }

    public class StackElement {
        private String name = null;
        private Attributes attributes = null;
        private int level = -1;
        private Object data = null;
        private ComplexTypeDefinition typeDefinition = null;

        public StackElement(String name, Attributes attributes, int level) {
            this.name = name;
            this.attributes = attributes;
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public int getLevel() {
            return this.level;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public ComplexTypeDefinition getTypeDefinition() {
            return this.typeDefinition;
        }

        public void setTypeDefinition(ComplexTypeDefinition typeDefinition) {
            this.typeDefinition = typeDefinition;
        }
    }
}

