/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.ujac.util.table.Column;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.web.tag.BaseTag;
import org.ujac.web.tag.PrintTableTag;

public class DefineColumnTag
extends BaseTag {
    private static final long serialVersionUID = 3257852086476551222L;
    private String name;
    private String width;
    private String title;
    private String halign;
    private String action;
    private String script = null;

    public String getHalign() {
        return this.halign;
    }

    public void setHalign(String halign) {
        this.halign = halign.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        return 2;
    }

    public int doEndTag() throws JspException {
        String body = null;
        BodyContent bc = this.bodyContent;
        if (bc != null) {
            body = bc.getString();
        }
        PrintTableTag printTableTag = null;
        try {
            printTableTag = (PrintTableTag)this.getParent(PrintTableTag.class);
        }
        catch (ClassCastException ex) {
            throw new JspException("Parent tag of row-cell tag has to be print-row tag.");
        }
        if (printTableTag.isOutputStarted()) {
            return 1;
        }
        float width = -1.0f;
        if (this.width != null) {
            width = Float.parseFloat(this.width);
        }
        int hAlign = -1;
        if (this.halign != null) {
            if ("left".equals(this.halign)) {
                hAlign = 0;
            } else if ("right".equals(this.halign)) {
                hAlign = 2;
            } else if ("center".equals(this.halign)) {
                hAlign = 1;
            } else {
                throw new JspException("Unsupported alignment type '" + this.halign + "'.");
            }
        }
        if (this.action != null) {
            try {
                StringBuffer bodyBuf = new StringBuffer("<a href=\"");
                StringBuffer actionBuf = null;
                actionBuf = this.script != null ? new StringBuffer() : bodyBuf;
                boolean numKeys = false;
                Table table = printTableTag.getTable();
                String loopVariableName = printTableTag.getLoopVariable();
                int numColumns = table.getColumnCount();
                for (int i = 0; i < numColumns; ++i) {
                    Column col = table.getColumn(i);
                    if (!col.isKey()) continue;
                    if (!numKeys) {
                        actionBuf.append("?");
                    } else {
                        actionBuf.append("&");
                    }
                    String fieldName = col.getAlias();
                    if (fieldName == null) {
                        fieldName = col.getName();
                    }
                    actionBuf.append(fieldName).append("=${").append(loopVariableName).append(" formatValue '").append(col.getName()).append("'}");
                }
                if (this.script != null) {
                    int actionUrlIdx = this.script.indexOf("${ACTION_URL}");
                    if (actionUrlIdx != -1) {
                        bodyBuf.append(this.script.substring(0, actionUrlIdx)).append(actionBuf.toString()).append(this.script.substring(actionUrlIdx + 13));
                    } else {
                        bodyBuf.append(actionBuf.toString());
                    }
                }
                bodyBuf.append("\">").append(body).append("</a>");
                body = bodyBuf.toString();
            }
            catch (TableException ex) {
                throw new JspException("Table access failure: " + ex.getMessage(), (Throwable)ex);
            }
        }
        printTableTag.defineColumn(this.name, width, hAlign, this.title, body);
        return 1;
    }

    public void release() {
        super.release();
        this.name = null;
        this.width = null;
        this.title = null;
        this.halign = null;
        this.action = null;
    }
}

