/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.ujac.util.table.Column;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.web.tag.PrintTableTag;
import org.ujac.web.tag.RowCellHolder;

public class ExtraRowHolder {
    protected PrintTableTag rowContainer = null;
    private String style = null;
    private String height = null;
    private String valign = null;
    private float paddingLeft = -1.0f;
    private float paddingRight = -1.0f;
    private float paddingTop = -1.0f;
    private float paddingBottom = -1.0f;
    protected RowCellHolder[] registeredRowCells = null;

    public ExtraRowHolder(PrintTableTag rowContainer, RowCellHolder[] registeredRowCells, String style, String height, String valign, float paddingLeft, float paddingRight, float paddingTop, float paddingBottom) {
        this.rowContainer = rowContainer;
        this.registeredRowCells = registeredRowCells;
        this.style = style;
        this.height = height;
        this.valign = valign;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
    }

    public RowCellHolder[] getRowCells() {
        return this.registeredRowCells;
    }

    public void outputRow(JspWriter writer) throws JspException {
        try {
            JspWriter out = writer;
            out.print("  <tr");
            String style = this.style;
            if (style != null) {
                out.print(" class=\"" + style + "\"");
            }
            out.println(">");
            Row row = this.rowContainer.getCurrentRow();
            Column[] columns = this.rowContainer.getVisibleColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnIdx = column.getIndex();
                LayoutHints layoutHints = column.getLayoutHints();
                RowCellHolder rowCell = this.registeredRowCells[i];
                String width = null;
                String height = this.height;
                style = this.style;
                String valign = this.valign;
                String halign = null;
                if (columnIdx != -1) {
                    switch (row.getAlign(columnIdx)) {
                        case 0: {
                            halign = "left";
                            break;
                        }
                        case 2: {
                            halign = "right";
                            break;
                        }
                        case 1: {
                            halign = "center";
                            break;
                        }
                        default: {
                            halign = "left";
                        }
                    }
                }
                float paddingLeft = this.paddingLeft;
                float paddingRight = this.paddingRight;
                float paddingTop = this.paddingTop;
                float paddingBottom = this.paddingBottom;
                String content = null;
                int colspan = 1;
                if (rowCell != null) {
                    String tmpHalign;
                    width = rowCell.getWidth();
                    if (rowCell.getHeight() != null) {
                        height = rowCell.getHeight();
                    }
                    if (rowCell.getStyle() != null) {
                        style = rowCell.getStyle();
                    }
                    if (rowCell.getValign() != null) {
                        valign = rowCell.getValign();
                    }
                    if ((tmpHalign = rowCell.getHalign()) != null) {
                        halign = tmpHalign;
                    }
                    if (rowCell.getPaddingLeft() >= 0.0f) {
                        paddingLeft = rowCell.getPaddingLeft();
                    }
                    if (rowCell.getPaddingRight() >= 0.0f) {
                        paddingRight = rowCell.getPaddingRight();
                    }
                    if (rowCell.getPaddingTop() >= 0.0f) {
                        paddingTop = rowCell.getPaddingTop();
                    }
                    if (rowCell.getPaddingBottom() >= 0.0f) {
                        paddingBottom = rowCell.getPaddingBottom();
                    }
                    if (rowCell.hasContent()) {
                        content = this.rowContainer.evalTemplate(rowCell.getContent());
                    }
                    if (rowCell.getColspan() > 0) {
                        colspan = rowCell.getColspan();
                    }
                    if (rowCell.isFillRow()) {
                        colspan = columns.length - i;
                    }
                }
                String cellStyle = style;
                if (width == null && layoutHints.getWidth() > 0.0f) {
                    width = Integer.toString((int)layoutHints.getWidth()) + '%';
                }
                if (content == null) {
                    content = columnIdx != -1 && row.isVisible(columnIdx) ? row.getString(columnIdx) : "&nbsp;";
                }
                out.print("    <td");
                out.print(this.getCellAttributes(cellStyle, width, height, halign, valign, colspan, paddingLeft, paddingRight, paddingTop, paddingBottom));
                out.print(">");
                out.print(content);
                out.println("</td>");
                if (colspan <= 1) continue;
                i += colspan - 1;
            }
            out.println("  </tr>");
        }
        catch (IOException ex) {
            throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
        }
        catch (TableException ex) {
            throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new JspException("Parent tag of row-cell tag has to be print-row tag.");
        }
    }

    protected String getCellAttributes(String styleClass, String width, String height, String hAlign, String vAlign, int colspan, float paddingLeft, float paddingRight, float paddingTop, float paddingBottom) {
        boolean stylesDefined = false;
        StringBuffer styleBuffer = new StringBuffer(" style=\"");
        StringBuffer attributesBuffer = new StringBuffer();
        if (styleClass != null) {
            attributesBuffer.append(" class=\"" + styleClass + "\"");
        }
        if (hAlign != null) {
            stylesDefined = true;
            styleBuffer.append("text-align:" + hAlign + ";");
            attributesBuffer.append(" align=\"" + hAlign + "\"");
        }
        if (vAlign != null) {
            stylesDefined = true;
            styleBuffer.append("vertical-align:" + vAlign + ";");
            attributesBuffer.append(" valign=\"" + vAlign + "\"");
        }
        if (width != null) {
            stylesDefined = true;
            styleBuffer.append("width:" + width);
            if (!width.endsWith("%")) {
                styleBuffer.append("px");
            }
            styleBuffer.append(";");
            attributesBuffer.append(" width=\"" + width + "\"");
        }
        if (height != null) {
            stylesDefined = true;
            styleBuffer.append("height:" + height);
            if (!height.endsWith("%")) {
                styleBuffer.append("px");
            }
            styleBuffer.append(";");
            attributesBuffer.append(" height=\"" + height + "\"");
        }
        if (paddingLeft > 0.0f) {
            stylesDefined = true;
            styleBuffer.append("padding-left:" + paddingLeft);
            styleBuffer.append("px;");
        }
        if (paddingRight > 0.0f) {
            stylesDefined = true;
            styleBuffer.append("padding-right:" + paddingRight);
            styleBuffer.append("px;");
        }
        if (paddingTop > 0.0f) {
            stylesDefined = true;
            styleBuffer.append("padding-top:" + paddingTop);
            styleBuffer.append("px;");
        }
        if (paddingBottom > 0.0f) {
            stylesDefined = true;
            styleBuffer.append("padding-bottom:" + paddingBottom);
            styleBuffer.append("px;");
        }
        if (colspan > 1) {
            attributesBuffer.append(" colspan=\"" + colspan + "\"");
        }
        styleBuffer.append("\"");
        if (stylesDefined) {
            attributesBuffer.append(styleBuffer.toString());
        }
        return attributesBuffer.toString();
    }

    public String getStyle() {
        return this.style;
    }

    public String getHeight() {
        return this.height;
    }

    public String getValign() {
        return this.valign;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }
}

