/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.web.servlet.TemplateInterpreterHelper;
import org.ujac.web.tag.BaseConditionTag;

public class IfTag
extends BaseConditionTag {
    private static final long serialVersionUID = 3256440292037965106L;
    public static final String RESULT_ATTRIBUTE = "ujac-if-result";
    private String cond = null;
    private boolean result = false;

    public void setCond(String cond) {
        this.cond = cond;
    }

    public boolean getResult() {
        return this.result;
    }

    protected boolean evalCondition() throws JspException {
        PageContext ctx = this.pageContext;
        TemplateInterpreter interpreter = TemplateInterpreterHelper.getTemplateInterpreter(ctx);
        TemplateContext templateCtx = this.getTemplateContext();
        try {
            this.result = interpreter.evalBooleanExpr(this.cond, templateCtx);
        }
        catch (ExpressionException ex) {
            throw new JspException("Condition evaluation failed: " + ex.getMessage(), (Throwable)ex);
        }
        return this.result;
    }

    public int doEndTag() throws JspException {
        int rs = super.doEndTag();
        this.pageContext.setAttribute(RESULT_ATTRIBUTE, (Object)new Boolean(this.result));
        return rs;
    }

    public void release() {
        super.release();
        this.cond = null;
        this.result = false;
    }
}

