/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.web.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.TableException;
import org.ujac.web.tag.CellData;
import org.ujac.web.tag.ExtraRowHolder;
import org.ujac.web.tag.PrintRowTag;
import org.ujac.web.tag.PrintTableTag;
import org.ujac.web.tag.RowCellHolder;

public class PrintHeaderRowTag
extends PrintRowTag {
    private static final long serialVersionUID = 3688790280065267248L;

    protected boolean checkRowType(Row row) {
        return !this.rowContainer.isHeaderPrinted();
    }

    public int doEndTag() throws JspException {
        ExtraRowHolder extraRow;
        int i;
        int numExtraRows;
        List extraRows;
        if (this.isSkipped()) {
            this.setSkipped(false);
            return 6;
        }
        if (this.extraRowsBefore != null) {
            extraRows = this.extraRowsBefore;
            numExtraRows = extraRows.size();
            for (i = 0; i < numExtraRows; ++i) {
                extraRow = (ExtraRowHolder)extraRows.get(i);
                extraRow.outputRow(this.pageContext.getOut());
            }
        }
        this.outputRow();
        if (this.extraRowsAfter != null) {
            extraRows = this.extraRowsAfter;
            numExtraRows = extraRows.size();
            for (i = 0; i < numExtraRows; ++i) {
                extraRow = (ExtraRowHolder)extraRows.get(i);
                extraRow.outputRow(this.pageContext.getOut());
            }
        }
        this.rowContainer.setHeaderPrinted(true);
        return 6;
    }

    protected void outputRow() throws JspException {
        block55: {
            try {
                PrintTableTag parent = this.getRowContainer();
                String template = parent.getTemplate();
                String style = this.getStyle();
                if (BeanUtils.isEmpty(template)) {
                    JspWriter out = this.pageContext.getOut();
                    out.print("  <thead><tr");
                    if (style != null) {
                        out.print(" class=\"" + style + "\"");
                    }
                    out.println(">");
                    Row row = parent.getCurrentRow();
                    Column[] columns = parent.getVisibleColumns();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        int columnIdx = column.getIndex();
                        LayoutHints layoutHints = column.getLayoutHints();
                        RowCellHolder rowCell = this.registeredRowCells[i];
                        String width = null;
                        String height = this.getHeight();
                        style = this.getStyle();
                        String valign = this.getValign();
                        String halign = null;
                        if (columnIdx != -1) {
                            int align = layoutHints.getAlign();
                            if (row != null) {
                                align = row.getAlign(columnIdx);
                            }
                            switch (align) {
                                case 0: {
                                    halign = "left";
                                    break;
                                }
                                case 2: {
                                    halign = "right";
                                    break;
                                }
                                case 1: {
                                    halign = "center";
                                    break;
                                }
                                default: {
                                    halign = "left";
                                }
                            }
                        }
                        float paddingLeft = this.getPaddingLeft();
                        float paddingRight = this.getPaddingRight();
                        float paddingTop = this.getPaddingTop();
                        float paddingBottom = this.getPaddingBottom();
                        String content = null;
                        int colspan = 1;
                        if (rowCell != null) {
                            String tmpHalign;
                            width = rowCell.getWidth();
                            if (rowCell.getHeight() != null) {
                                height = rowCell.getHeight();
                            }
                            if (rowCell.getStyle() != null) {
                                style = rowCell.getStyle();
                            }
                            if (rowCell.getValign() != null) {
                                valign = rowCell.getValign();
                            }
                            if ((tmpHalign = rowCell.getHalign()) != null) {
                                halign = tmpHalign;
                            }
                            if (rowCell.getPaddingLeft() >= 0.0f) {
                                paddingLeft = rowCell.getPaddingLeft();
                            }
                            if (rowCell.getPaddingRight() >= 0.0f) {
                                paddingRight = rowCell.getPaddingRight();
                            }
                            if (rowCell.getPaddingTop() >= 0.0f) {
                                paddingTop = rowCell.getPaddingTop();
                            }
                            if (rowCell.getPaddingBottom() >= 0.0f) {
                                paddingBottom = rowCell.getPaddingBottom();
                            }
                            if (rowCell.hasContent()) {
                                content = this.rowContainer.evalTemplate(rowCell.getContent());
                            }
                            if (rowCell.getColspan() > 0) {
                                colspan = rowCell.getColspan();
                            }
                            if (rowCell.isFillRow()) {
                                colspan = columns.length - i;
                            }
                        }
                        String cellStyle = style;
                        if (width == null && layoutHints.getWidth() > 0.0f) {
                            width = Integer.toString((int)layoutHints.getWidth()) + '%';
                        }
                        if (content == null) {
                            boolean visible = layoutHints.isVisible();
                            if (row != null && columnIdx >= 0) {
                                visible = row.isVisible(columnIdx);
                            }
                            content = columnIdx != -1 && visible ? column.getLayoutHints().getHeader() : "&nbsp;";
                        }
                        out.print("    <th");
                        out.print(this.getCellAttributes(cellStyle, width, height, halign, valign, colspan, paddingLeft, paddingRight, paddingTop, paddingBottom));
                        out.print(">");
                        out.print(content);
                        out.println("</th>");
                        if (colspan <= 1) continue;
                        i += colspan - 1;
                    }
                    out.println("  </tr></thead>");
                    out.println("  <tbody>");
                    break block55;
                }
                try {
                    this.setAttribute("_TABLE_ROW_STYLE", style);
                    this.setAttribute("_TABLE_ROW_HEIGHT", this.getHeight());
                    float totalWidth = 0.0f;
                    ArrayList<CellData> actualCells = new ArrayList<CellData>();
                    Row row = parent.getCurrentRow();
                    this.setAttribute("_TABLE_ROW_TYPE", "header");
                    Column[] columns = parent.getVisibleColumns();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        int columnIdx = column.getIndex();
                        LayoutHints layoutHints = column.getLayoutHints();
                        RowCellHolder rowCell = this.registeredRowCells[i];
                        String width = null;
                        String height = this.getHeight();
                        style = this.getStyle();
                        String valign = this.getValign();
                        String halign = null;
                        if (columnIdx != -1) {
                            int align = layoutHints.getAlign();
                            if (row != null) {
                                align = row.getAlign(columnIdx);
                            }
                            switch (align) {
                                case 0: {
                                    halign = "left";
                                    break;
                                }
                                case 2: {
                                    halign = "right";
                                    break;
                                }
                                case 1: {
                                    halign = "center";
                                    break;
                                }
                                default: {
                                    halign = "left";
                                }
                            }
                        }
                        float paddingLeft = this.getPaddingLeft();
                        float paddingRight = this.getPaddingRight();
                        float paddingTop = this.getPaddingTop();
                        float paddingBottom = this.getPaddingBottom();
                        String content = null;
                        int colspan = 1;
                        if (rowCell != null) {
                            String tmpHalign;
                            width = rowCell.getWidth();
                            if (rowCell.getHeight() != null) {
                                height = rowCell.getHeight();
                            }
                            if (rowCell.getStyle() != null) {
                                style = rowCell.getStyle();
                            }
                            if (rowCell.getValign() != null) {
                                valign = rowCell.getValign();
                            }
                            if ((tmpHalign = rowCell.getHalign()) != null) {
                                halign = tmpHalign;
                            }
                            if (rowCell.getPaddingLeft() >= 0.0f) {
                                paddingLeft = rowCell.getPaddingLeft();
                            }
                            if (rowCell.getPaddingRight() >= 0.0f) {
                                paddingRight = rowCell.getPaddingRight();
                            }
                            if (rowCell.getPaddingTop() >= 0.0f) {
                                paddingTop = rowCell.getPaddingTop();
                            }
                            if (rowCell.getPaddingBottom() >= 0.0f) {
                                paddingBottom = rowCell.getPaddingBottom();
                            }
                            if (rowCell.hasContent()) {
                                content = this.rowContainer.evalTemplate(rowCell.getContent());
                            }
                            if (rowCell.getColspan() > 0) {
                                colspan = rowCell.getColspan();
                            }
                            if (rowCell.isFillRow()) {
                                colspan = columns.length - i;
                            }
                        }
                        String cellStyle = style;
                        if (width == null && layoutHints.getWidth() > 0.0f) {
                            width = Integer.toString((int)layoutHints.getWidth());
                        }
                        boolean visible = layoutHints.isVisible();
                        if (content == null) {
                            if (row != null && columnIdx >= 0) {
                                visible = row.isVisible(columnIdx);
                            }
                            content = column.getLayoutHints().getHeader();
                        }
                        CellData cellData = new CellData(column.getName(), content, colspan);
                        cellData.setVisible(visible);
                        cellData.setStyle(cellStyle);
                        cellData.setWidth(width);
                        cellData.setHeight(height);
                        cellData.setHalign(halign);
                        cellData.setValign(valign);
                        cellData.setPaddingLeft((int)paddingLeft);
                        cellData.setPaddingRight((int)paddingRight);
                        cellData.setPaddingTop((int)paddingTop);
                        cellData.setPaddingBottom((int)paddingBottom);
                        actualCells.add(cellData);
                        if (colspan > 1) {
                            i += colspan - 1;
                        }
                        totalWidth += layoutHints.getWidth();
                    }
                    this.setAttribute("_TABLE_CELLS", actualCells);
                    this.setAttribute("_TABLE_WIDTH", new Float(totalWidth));
                    this.pageContext.include(template + "-header.jsp");
                }
                catch (ServletException ex) {
                    this.log.error((Object)("Failed to include template file '" + template + "-body.jsp': " + ex.getMessage()), (Throwable)ex);
                    throw new JspException("Failed to include template file '" + template + "-body.jsp'.");
                }
            }
            catch (IOException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (TableException ex) {
                throw new JspException("Unable to print table row: " + ex.getMessage(), (Throwable)ex);
            }
            catch (ClassCastException ex) {
                throw new JspException("Parent tag of row-cell tag has to be print-row tag.");
            }
        }
    }
}

