/*
 * Decompiled with CFR 0.152.
 */
package er.jasperreports;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.appserver.ERXApplication;
import er.extensions.concurrency.ERXTaskPercentComplete;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXAssert;
import er.jasperreports.ERJRFoundationDataSource;
import er.jasperreports.ERJRUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERJRFetchSpecificationReportTask
implements Callable<File>,
ERXTaskPercentComplete {
    private static final Logger log = Logger.getLogger(ERJRFetchSpecificationReportTask.class);
    private File reportFile;
    private final String frameworkName;
    private final EOFetchSpecification fetchSpecification;
    private final String jasperCompiledReportFileName;
    private Map<String, Object> parameters;
    private ERJRFoundationDataSource jrDataSource;

    public ERJRFetchSpecificationReportTask(EOFetchSpecification fetchSpecification, String jasperCompiledReportFileName) {
        this(fetchSpecification, jasperCompiledReportFileName, null, null);
    }

    public ERJRFetchSpecificationReportTask(EOFetchSpecification fetchSpecification, String jasperCompiledReportFileName, HashMap<String, Object> parameters) {
        this(fetchSpecification, jasperCompiledReportFileName, null, parameters);
    }

    public ERJRFetchSpecificationReportTask(EOFetchSpecification fetchSpecification, String jasperCompiledReportFileName, String frameworkName, HashMap<String, Object> parameters) {
        ERXAssert.PRE.notNull((Object)fetchSpecification);
        ERXAssert.PRE.notNull((Object)jasperCompiledReportFileName);
        EOFetchSpecification fs = null;
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            fs = this.schemaBasedFetchSpecification(fetchSpecification);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert fetchSpecification to schema-based", e);
        }
        finally {
            ec.unlock();
        }
        this.fetchSpecification = fs;
        this.jasperCompiledReportFileName = jasperCompiledReportFileName;
        this.frameworkName = frameworkName;
        this.parameters = parameters;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
    }

    @Override
    public File call() throws Exception {
        ERXApplication._startRequest();
        try {
            File file = this._call();
            return file;
        }
        catch (Exception e) {
            log.error((Object)"Error in JR task", (Throwable)e);
            throw e;
        }
        finally {
            ERXApplication._endRequest();
        }
    }

    private File _call() {
        if (ERXApplication.isDevelopmentModeSafe()) {
            this.parameters.put("_isDevelopmentMode", Boolean.TRUE);
        } else {
            this.parameters.put("_isDevelopmentMode", Boolean.FALSE);
        }
        this.reportFile = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting JasperReportTask: " + this.toString()));
        }
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            NSArray objects = ec.objectsWithFetchSpecification(this.fetchSpecification);
            this.jrDataSource = new ERJRFoundationDataSource((NSArray<? extends NSKeyValueCodingAdditions>)objects);
            if (this.jasperCompiledReportFileName != null) {
                this.reportFile = ERJRUtilities.runCompiledReportToPDFFile(this.jasperCompiledReportFileName, this.frameworkName, this.parameters, this.jrDataSource);
            }
        }
        catch (Exception e) {
            throw new NestableRuntimeException((Throwable)e);
        }
        finally {
            ec.unlock();
        }
        return this.reportFile;
    }

    public File file() {
        return this.reportFile;
    }

    public Double percentComplete() {
        if (this.jrDataSource == null) {
            return 0.1;
        }
        double percent = 0.1 + this.jrDataSource.percentProcessed() * 0.8;
        return percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EOFetchSpecification schemaBasedFetchSpecification(EOFetchSpecification fetchSpecification) {
        EOQualifier q = fetchSpecification.qualifier();
        if (q != null) {
            fetchSpecification = (EOFetchSpecification)fetchSpecification.clone();
            EOEditingContext ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                EOEntity entity = ERXEOAccessUtilities.entityMatchingString((EOEditingContext)ec, (String)fetchSpecification.entityName());
                q = entity.schemaBasedQualifier(q);
                fetchSpecification.setQualifier(q);
            }
            finally {
                ec.unlock();
            }
        }
        return fetchSpecification;
    }
}

