/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;

public class _FrontBasePlugIn
extends JDBCPlugIn {
    private static final String QUERY_STRING_USE_BUNDLED_JDBC_INFO = "useBundledJdbcInfo";
    static final boolean USE_NAMED_CONSTRAINTS = true;
    static final String _frontbaseIncludeSynonyms = System.getProperty("jdbcadaptor.frontbase.includeSynonyms", null);
    static final String _frontbaseWildcardPatternForAttributes = System.getProperty("jdbcadaptor.frontbase.wildcardPatternForAttributes", null);
    static final String _frontbaseWildcardPatternForTables = System.getProperty("jdbcadaptor.frontbase.wildcardPatternForTables", "%");
    static final String _frontbaseWildcardPatternForSchema = System.getProperty("jdbcadaptor.frontbase.wildcardPatternForSchema", null);
    static final String _frontbaseSqlStatementForGettingProcedureNames = System.getProperty("jdbcadaptor.frontbase.sqlStatementForGettingProcedureNames", null);
    static final String _frontbaseStoredProcedureCatalogPattern = System.getProperty("jdbcadaptor.frontbase.storedProcedureCatalogPattern", null);
    static final String _frontbaseStoredProcedureSchemaPattern = System.getProperty("jdbcadaptor.frontbase.storedProcedureSchemaPattern", null);
    static final String _frontbaseSqlStatementForGettingTableNames = System.getProperty("jdbcadaptor.frontbase.sqlStatementForGettingTableNames", null);
    protected static final int FB_Boolean = 1;
    protected static final int FB_Integer = 2;
    protected static final int FB_SmallInteger = 3;
    protected static final int FB_Float = 4;
    protected static final int FB_Real = 5;
    protected static final int FB_Double = 6;
    protected static final int FB_Numeric = 7;
    protected static final int FB_Decimal = 8;
    protected static final int FB_Character = 9;
    protected static final int FB_VCharacter = 10;
    protected static final int FB_Bit = 11;
    protected static final int FB_VBit = 12;
    protected static final int FB_Date = 13;
    protected static final int FB_Time = 14;
    protected static final int FB_TimeTZ = 15;
    protected static final int FB_Timestamp = 16;
    protected static final int FB_TimestampTZ = 17;
    protected static final int FB_YearMonth = 18;
    protected static final int FB_DayTime = 19;
    protected static final int FB_CLOB = 20;
    protected static final int FB_BLOB = 21;
    protected static final int FB_TinyInteger = 22;
    protected static final int FB_LongInteger = 23;

    public _FrontBasePlugIn(JDBCAdaptor jdbcadaptor) {
        super(jdbcadaptor);
    }

    public static String getPlugInVersion() {
        return "2.6.4";
    }

    public boolean canDescribeStoredProcedure(String s) {
        return true;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new FrontbaseSynchronizationFactory((EOAdaptor)this._adaptor);
    }

    public String defaultDriverName() {
        return "com.frontbase.jdbc.FBJDriver";
    }

    public String databaseProductName() {
        return "FrontBase";
    }

    public String name() {
        return "FrontBase";
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = false;
        String url = this.connectionURL();
        if (url != null) {
            shouldUseBundledJdbcInfo = url.toLowerCase().matches(".*/" + QUERY_STRING_USE_BUNDLED_JDBC_INFO.toLowerCase() + "=(true|yes)(\\/|$)");
        }
        return shouldUseBundledJdbcInfo;
    }

    public Class defaultExpressionClass() {
        return FrontbaseExpression.class;
    }

    public String wildcardPatternForSchema() {
        if (_frontbaseWildcardPatternForSchema != null) {
            return _frontbaseWildcardPatternForSchema;
        }
        String schema = (String)this.adaptor().connectionDictionary().objectForKey((Object)"schema");
        return schema != null ? schema.toUpperCase() : "CURRENT_SCHEMA";
    }

    public String schemaNameForEntity(EOEntity eoentity) {
        String s = super.schemaNameForEntity(eoentity);
        if (s == null) {
            s = (String)this.adaptor().connectionDictionary().objectForKey((Object)"schema");
            return s != null ? s.toUpperCase() : "CURRENT_SCHEMA";
        }
        return s;
    }

    public String storedProcedureSchemaPattern() {
        if (_frontbaseStoredProcedureSchemaPattern != null) {
            return _frontbaseStoredProcedureSchemaPattern;
        }
        return "CURRENT_SCHEMA";
    }

    public Properties connectionPropertiesForConnectionDictionary(NSDictionary connectionDictionary) {
        Properties properties = super.connectionPropertiesForConnectionDictionary(connectionDictionary);
        Object temp = connectionDictionary.objectForKey((Object)"dbpasswd");
        if (temp != null) {
            properties.put("dbpasswd", temp);
        }
        if ((temp = connectionDictionary.objectForKey((Object)"session")) != null) {
            properties.put("session", temp);
        }
        if ((temp = connectionDictionary.objectForKey((Object)"system")) != null) {
            properties.put("system", temp);
        }
        if ((temp = connectionDictionary.objectForKey((Object)"isolation")) != null) {
            properties.put("isolation", temp);
        }
        if ((temp = connectionDictionary.objectForKey((Object)"locking")) != null) {
            properties.put("locking", temp);
        }
        if ((temp = connectionDictionary.objectForKey((Object)"readOnly")) != null) {
            properties.put("readOnly", temp);
        }
        return properties;
    }

    public NSDictionary jdbcInfo() {
        NSMutableDictionary mutableJdbcInfo;
        block9: {
            NSDictionary jdbcInfo;
            boolean shouldUseBundledJdbcInfo = this.shouldUseBundledJdbcInfo();
            if (shouldUseBundledJdbcInfo) {
                InputStream jdbcInfoStream;
                if (NSLog.debugLoggingAllowedForLevel((int)3)) {
                    NSLog.debug.appendln((Object)"Loading jdbcInfo from JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
                }
                if ((jdbcInfoStream = ((Object)((Object)this)).getClass().getResourceAsStream("/FrontBaseJDBCInfo.plist")) == null) {
                    throw new IllegalStateException("Unable to find 'FrontBaseJDBCInfo.plist' in this plugin jar.");
                }
                try {
                    jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load 'FrontBaseJDBCInfo.plist' from this plugin jar.", e);
                }
            } else {
                jdbcInfo = super.jdbcInfo();
            }
            mutableJdbcInfo = new NSMutableDictionary(jdbcInfo);
            NSMutableDictionary typeInfoDict = new NSMutableDictionary((NSDictionary)mutableJdbcInfo.objectForKey((Object)"typeInfo"));
            NSDictionary typeDict = (NSDictionary)typeInfoDict.objectForKey((Object)"CHARACTER");
            typeInfoDict.setObjectForKey((Object)typeDict, (Object)"CHAR");
            typeDict = (NSDictionary)typeInfoDict.objectForKey((Object)"CHARACTER VARYING");
            typeInfoDict.setObjectForKey((Object)typeDict, (Object)"VARCHAR");
            typeInfoDict.setObjectForKey((Object)typeDict, (Object)"CHAR VARYING");
            typeDict = (NSDictionary)typeInfoDict.objectForKey((Object)"BIT");
            typeInfoDict.setObjectForKey((Object)typeDict, (Object)"BYTE");
            typeDict = (NSDictionary)typeInfoDict.objectForKey((Object)"BIT VARYING");
            typeInfoDict.setObjectForKey((Object)typeDict, (Object)"BYTE VARYING");
            mutableJdbcInfo.setObjectForKey((Object)typeInfoDict, (Object)"typeInfo");
            if (!shouldUseBundledJdbcInfo) {
                JDBCContext jdbccontext = this.adaptor()._cachedAdaptorContext();
                try {
                    jdbccontext.connection().commit();
                }
                catch (SQLException sqlexception) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)65536L)) break block9;
                    NSLog.debug.appendln((Throwable)sqlexception);
                }
            }
        }
        return mutableJdbcInfo;
    }

    EOQualifier primaryKeyQualifier(EOQualifier eoqualifier, EOEntity eoentity) {
        if (eoqualifier instanceof EOAndQualifier) {
            NSArray qualifiers = ((EOAndQualifier)eoqualifier).qualifiers();
            NSArray attributeNames = eoentity.primaryKeyAttributeNames();
            NSMutableArray nsmutablearray = new NSMutableArray();
            for (int i = 0; i < qualifiers.count(); ++i) {
                EOKeyValueQualifier eokeyvaluequalifier;
                EOQualifier eoqualifier1 = (EOQualifier)qualifiers.objectAtIndex(i);
                if (!(eoqualifier1 instanceof EOKeyValueQualifier) || !attributeNames.containsObject((Object)(eokeyvaluequalifier = (EOKeyValueQualifier)eoqualifier1).key())) continue;
                nsmutablearray.addObject((Object)eokeyvaluequalifier);
            }
            if (nsmutablearray.count() == 1) {
                return (EOQualifier)nsmutablearray.objectAtIndex(0);
            }
            return new EOAndQualifier(qualifiers);
        }
        return eoqualifier;
    }

    public void updateLOBs(JDBCChannel channel, JDBCExpression expression, NSDictionary dictionary, EOEntity entity) {
        FrontbaseExpression frontbaseexpression = (FrontbaseExpression)expression;
        if (!frontbaseexpression.hasLOBsToUpdate()) {
            return;
        }
        NSArray array = frontbaseexpression.lobList();
        try {
            Connection con = ((JDBCContext)channel.adaptorContext()).connection();
            NSMutableDictionary d = new NSMutableDictionary();
            for (int i = 0; i < array.count(); i += 2) {
                d.setObjectForKey((Object)this.getLobHandle(con, array.objectAtIndex(i), array.objectAtIndex(i + 1)), (Object)((EOAttribute)array.objectAtIndex(i)).name());
            }
            EOQualifier qualifier = frontbaseexpression.qualifier();
            qualifier = qualifier == null ? entity.qualifierForPrimaryKey(dictionary) : this.primaryKeyQualifier(qualifier, entity);
            frontbaseexpression.resetlobList();
            channel.updateValuesInRowsDescribedByQualifier((NSDictionary)d, qualifier, entity);
        }
        catch (SQLException e) {
            System.err.print(e.getMessage());
        }
    }

    String getLobHandle(Connection con, Object attribute, Object value) throws SQLException {
        try {
            switch (_FrontBasePlugIn.internalTypeForExternal(((EOAttribute)attribute).externalType())) {
                case 21: {
                    Method writeBLOBBytes = con.getClass().getMethod("writeBLOB", byte[].class);
                    return (String)writeBLOBBytes.invoke((Object)con, new Object[]{((NSData)value).bytes()});
                }
                case 20: {
                    Method writeCLOBString = con.getClass().getMethod("writeCLOB", String.class);
                    return (String)writeCLOBString.invoke((Object)con, (String)value);
                }
            }
            return "NULL";
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new RuntimeException("Failed to get LOB handle.", e);
        }
    }

    public Object fetchBLOB(ResultSet resultset, int i, EOAttribute attribute, boolean flag) throws SQLException {
        Blob blob = resultset.getBlob(i);
        if (blob == null) {
            return null;
        }
        if (!flag) {
            return blob;
        }
        try {
            return attribute.newValueForBytes(blob.getBytes(1L, (int)blob.length()), 0);
        }
        catch (Exception ioexception) {
            throw new JDBCAdaptorException(ioexception.getMessage(), null);
        }
    }

    public Object fetchCLOB(ResultSet resultset, int i, EOAttribute attribute, boolean flag) throws SQLException {
        Clob clob = resultset.getClob(i);
        if (clob == null) {
            return null;
        }
        if (!flag) {
            return clob;
        }
        return clob.getSubString(1L, (int)clob.length());
    }

    public NSArray newPrimaryKeys(int numberOfKeys, EOEntity eoentity, JDBCChannel jdbcchannel) {
        int thisKeyBatchSize;
        NSMutableArray pkDicts = new NSMutableArray();
        boolean pksGenerated = true;
        int keyBatchSize = 10;
        for (int numberOfKeysLeft = numberOfKeys; pksGenerated && numberOfKeysLeft > 0; numberOfKeysLeft -= thisKeyBatchSize) {
            thisKeyBatchSize = Math.min(keyBatchSize, numberOfKeysLeft);
            pksGenerated = this._newPrimaryKeys(thisKeyBatchSize, eoentity, jdbcchannel, pkDicts);
        }
        if (!pksGenerated) {
            pkDicts = null;
        }
        return pkDicts;
    }

    private boolean _newPrimaryKeys(int keyBatchSize, EOEntity eoentity, JDBCChannel jdbcchannel, NSMutableArray pkDicts) {
        if (keyBatchSize == 0) {
            return true;
        }
        NSArray primaryKeyAttributes = eoentity.primaryKeyAttributes();
        if (primaryKeyAttributes == null) {
            return false;
        }
        EOAttribute firstPrimaryKeyAttribute = (EOAttribute)primaryKeyAttributes.lastObject();
        boolean isNSData = firstPrimaryKeyAttribute.className().endsWith("NSData");
        NSMutableArray attributesToFetch = new NSMutableArray();
        StringBuffer sql = new StringBuffer();
        sql.append("VALUES (");
        for (int keyNum = 0; keyNum < keyBatchSize; ++keyNum) {
            if (isNSData) {
                if (firstPrimaryKeyAttribute.externalType().startsWith("BIT")) {
                    sql.append("NEW_UID(" + (firstPrimaryKeyAttribute.width() >> 3) + ")");
                } else {
                    sql.append("NEW_UID(" + firstPrimaryKeyAttribute.width() + ")");
                }
            } else {
                sql.append("SELECT UNIQUE FROM " + _FrontBasePlugIn.quoteTableName(eoentity.primaryKeyRootName()));
            }
            if (keyNum < keyBatchSize - 1) {
                sql.append(", ");
            }
            EOAttribute generatedPrimaryKeyAttribute = new EOAttribute();
            generatedPrimaryKeyAttribute.setName("Unique" + keyNum);
            generatedPrimaryKeyAttribute.setColumnName(firstPrimaryKeyAttribute.columnName());
            generatedPrimaryKeyAttribute.setExternalType(firstPrimaryKeyAttribute.externalType());
            generatedPrimaryKeyAttribute.setClassName(firstPrimaryKeyAttribute.className());
            generatedPrimaryKeyAttribute.setValueType(firstPrimaryKeyAttribute.valueType());
            generatedPrimaryKeyAttribute.setPrecision(firstPrimaryKeyAttribute.precision());
            generatedPrimaryKeyAttribute.setScale(firstPrimaryKeyAttribute.scale());
            generatedPrimaryKeyAttribute.setWidth(firstPrimaryKeyAttribute.width());
            generatedPrimaryKeyAttribute.setAllowsNull(firstPrimaryKeyAttribute.allowsNull());
            this.adaptor().plugIn().assignTypeForAttribute(generatedPrimaryKeyAttribute);
            attributesToFetch.addObject((Object)generatedPrimaryKeyAttribute);
        }
        sql.append(")");
        boolean pksGenerated = false;
        EOSQLExpression eosqlexpression = this.expressionFactory().expressionForString(sql.toString());
        EOAdaptorContext adaptorContext = jdbcchannel.adaptorContext();
        adaptorContext.transactionDidBegin();
        jdbcchannel.evaluateExpression(eosqlexpression);
        if (jdbcchannel._errorEvaluateExpression()) {
            adaptorContext.transactionDidRollback();
            jdbcchannel._setErrorEvaluateExpression(false);
        } else {
            NSArray pkValues;
            jdbcchannel.setAttributesToFetch((NSArray)attributesToFetch);
            NSMutableDictionary row = jdbcchannel.fetchRow();
            jdbcchannel.cancelFetch();
            adaptorContext.transactionDidCommit();
            if (row != null && row.count() > 0 && (pkValues = row.allValues()).count() == keyBatchSize) {
                Enumeration keysEnum = pkValues.objectEnumerator();
                while (keysEnum.hasMoreElements()) {
                    Object obj = keysEnum.nextElement();
                    NSMutableDictionary pkDict = new NSMutableDictionary();
                    Enumeration pkAttributeEnum = primaryKeyAttributes.objectEnumerator();
                    while (pkAttributeEnum.hasMoreElements()) {
                        EOAttribute pkAttribute = (EOAttribute)pkAttributeEnum.nextElement();
                        pkDict.setObjectForKey(obj, (Object)pkAttribute.name());
                    }
                    pkDicts.addObject((Object)pkDict);
                }
                pksGenerated = true;
            }
        }
        return pksGenerated;
    }

    protected static String notNullConstraintName(EOAttribute attribute) {
        return _FrontBasePlugIn.notNullConstraintName(attribute.entity().externalName(), attribute.columnName());
    }

    protected static String notNullConstraintName(String tableName, String columnName) {
        StringBuffer constraintBuffer = new StringBuffer();
        constraintBuffer.append("NOT_NULL_");
        constraintBuffer.append(tableName);
        constraintBuffer.append("__");
        constraintBuffer.append(columnName);
        return constraintBuffer.toString();
    }

    protected static String quoteTableName(String s) {
        if (s == null) {
            return null;
        }
        int i = s.lastIndexOf(46);
        if (i == -1) {
            return "\"" + s + "\"";
        }
        return "\"" + s.substring(0, i) + "\".\"" + s.substring(i + 1, s.length()) + "\"";
    }

    protected static int internalTypeForExternal(String externalType) {
        String upperExternalType = externalType.toUpperCase();
        if (upperExternalType.equals("BOOLEAN")) {
            return 1;
        }
        if (upperExternalType.equals("INTEGER") || upperExternalType.equals("INT")) {
            return 2;
        }
        if (upperExternalType.equals("SMALLINT")) {
            return 3;
        }
        if (upperExternalType.equals("LONGINT")) {
            return 23;
        }
        if (upperExternalType.equals("TINYINT")) {
            return 22;
        }
        if (upperExternalType.equals("FLOAT")) {
            return 4;
        }
        if (upperExternalType.equals("REAL")) {
            return 5;
        }
        if (upperExternalType.equals("DOUBLE PRECISION")) {
            return 6;
        }
        if (upperExternalType.equals("NUMERIC")) {
            return 7;
        }
        if (upperExternalType.equals("DECIMAL")) {
            return 8;
        }
        if (upperExternalType.equals("CHAR") || upperExternalType.equals("CHARACTER")) {
            return 9;
        }
        if (upperExternalType.equals("VARCHAR") || upperExternalType.equals("CHARACTER VARYING") || upperExternalType.equals("CHAR VARYING")) {
            return 10;
        }
        if (upperExternalType.equals("BIT") || upperExternalType.equals("BYTE")) {
            return 11;
        }
        if (upperExternalType.equals("BIT VARYING") || upperExternalType.equals("BYTE VARYING")) {
            return 12;
        }
        if (upperExternalType.equals("DATE")) {
            return 13;
        }
        if (upperExternalType.equals("TIME")) {
            return 14;
        }
        if (upperExternalType.equals("TIME WITH TIME ZONE")) {
            return 15;
        }
        if (upperExternalType.equals("TIMESTAMP")) {
            return 16;
        }
        if (upperExternalType.equals("TIMESTAMP WITH TIME ZONE")) {
            return 17;
        }
        if (upperExternalType.equals("BLOB")) {
            return 21;
        }
        if (upperExternalType.equals("CLOB")) {
            return 20;
        }
        return -1;
    }

    public static class FrontbaseExpression
    extends JDBCExpression {
        private boolean _useBindVariables;
        EOQualifier _qualifier;
        NSMutableArray _lobList;
        private NSMutableArray _alreadyJoined = new NSMutableArray();

        public FrontbaseExpression(EOEntity eoentity) {
            super(eoentity);
            this._useBindVariables = "true".equalsIgnoreCase(System.getProperty("FrontBasePlugIn.useBindVariables"));
            this._rtrimFunctionName = null;
            this._externalQuoteChar = "\"";
        }

        public void addCreateClauseForAttribute(EOAttribute attribute) {
            boolean isLOB;
            StringBuffer sql = new StringBuffer();
            sql.append("\"");
            sql.append(attribute.columnName());
            sql.append("\" ");
            sql.append(this.columnTypeStringForAttribute(attribute));
            NSDictionary dictionary = attribute.userInfo();
            int internalType = _FrontBasePlugIn.internalTypeForExternal(attribute.externalType());
            boolean bl = isLOB = internalType == 21 || internalType == 20;
            if (dictionary == null) {
                this._appendNotNullConstraintIfNecessary(attribute, sql);
            } else {
                if (dictionary.valueForKey("Default") != null) {
                    sql.append(" DEFAULT ");
                    sql.append(dictionary.valueForKey("Default"));
                }
                if (dictionary.valueForKey("er.extensions.eoattribute.default") != null) {
                    sql.append(" DEFAULT ");
                    sql.append(this.formatValueForAttribute(dictionary.valueForKey("er.extensions.eoattribute.default"), attribute));
                }
                this._appendNotNullConstraintIfNecessary(attribute, sql);
                if (dictionary.valueForKey("Unique") != null && dictionary.valueForKey("Unique").equals("true")) {
                    sql.append(" UNIQUE");
                }
                if (dictionary.valueForKey("Check") != null) {
                    sql.append(" CHECK ");
                    sql.append(dictionary.valueForKey("Check"));
                }
                if (dictionary.valueForKey("Collate") != null) {
                    sql.append(" COLLATE ");
                    sql.append(dictionary.valueForKey("Collate"));
                }
            }
            this.appendItemToListString(sql.toString(), this._listString());
        }

        protected boolean shouldAllowNull(EOAttribute attribute) {
            boolean shouldAllowNull = attribute.allowsNull();
            if (!shouldAllowNull) {
                EOEntity entity = attribute.entity();
                EOEntity parentEntity = entity.parentEntity();
                String externalName = entity.externalName();
                if (externalName != null) {
                    EOAttribute parentAttribute;
                    boolean singleTableInheritance;
                    boolean bl = singleTableInheritance = parentEntity != null && externalName.equals(parentEntity.externalName());
                    if (singleTableInheritance && (parentAttribute = parentEntity.attributeNamed(attribute.name())) == null) {
                        shouldAllowNull = true;
                    }
                }
            }
            return shouldAllowNull;
        }

        private void _appendNotNullConstraintIfNecessary(EOAttribute attribute, StringBuffer sql) {
            if (!this.shouldAllowNull(attribute)) {
                boolean isLOB;
                sql.append(" CONSTRAINT ");
                sql.append(_FrontBasePlugIn.notNullConstraintName(attribute));
                sql.append(" NOT NULL");
                int internalType = _FrontBasePlugIn.internalTypeForExternal(attribute.externalType());
                boolean bl = isLOB = internalType == 21 || internalType == 20;
                if (isLOB) {
                    sql.append(" DEFERRABLE INITIALLY DEFERRED");
                }
            }
        }

        public String columnTypeStringForAttribute(EOAttribute attribute) {
            int createParams;
            NSDictionary externalTypeInfo;
            String externalTypeName = attribute.externalType();
            NSDictionary typeInfo = (NSDictionary)this.jdbcInfo().objectForKey((Object)"typeInfo");
            if (typeInfo == null) {
                typeInfo = JDBCAdaptor.typeInfoForModel((EOModel)((EOEntity)attribute.parent()).model());
            }
            if ((externalTypeInfo = (NSDictionary)typeInfo.objectForKey((Object)externalTypeName)) == null && externalTypeName != null) {
                externalTypeInfo = (NSDictionary)typeInfo.objectForKey((Object)externalTypeName.toUpperCase());
            }
            if (externalTypeInfo == null) {
                throw new JDBCAdaptorException("Unable to find type information for external type '" + externalTypeName + "' in attribute '" + attribute.name() + "' of entity '" + ((EOEntity)attribute.parent()).name() + "'.  Check spelling and capitalization.", null);
            }
            try {
                Object createParamsObj = externalTypeInfo.objectForKey((Object)"createParams");
                createParams = createParamsObj instanceof Integer ? (Integer)createParamsObj : Integer.parseInt((String)createParamsObj);
            }
            catch (NumberFormatException numberformatexception) {
                createParams = 0;
            }
            switch (createParams) {
                case 2: {
                    int precision = attribute.precision();
                    if (precision == 0) {
                        return attribute.externalType();
                    }
                    int scale = attribute.scale();
                    if (scale == 0) {
                        return attribute.externalType() + "(" + precision + ")";
                    }
                    return attribute.externalType() + "(" + precision + "," + scale + ")";
                }
                case 1: {
                    int length = attribute.width();
                    if (length == 0) {
                        length = attribute.precision();
                    }
                    if (length == 0) {
                        return attribute.externalType();
                    }
                    return attribute.externalType() + "(" + length + ")";
                }
            }
            return attribute.externalType();
        }

        public Class _synchronizationFactoryClass() {
            return FrontbaseSynchronizationFactory.class;
        }

        EOQualifier qualifier() {
            return this._qualifier;
        }

        public String sqlStringForSelector(NSSelector qualifierOperator, Object value) {
            if (qualifierOperator.equals((Object)EOQualifier.QualifierOperatorContains)) {
                if (value == NSKeyValueCoding.NullValue) {
                    return "is";
                }
                return "like";
            }
            return super.sqlStringForSelector(qualifierOperator, value);
        }

        public String externalNameQuoteCharacter() {
            return "\"";
        }

        public String sqlStringForAttribute(EOAttribute attribute) {
            String value = super.sqlStringForAttribute(attribute);
            if (!this.useAliases()) {
                value = "\"" + value + "\"";
            }
            return value;
        }

        public void addJoinClause(String leftName, String rightName, int semantic) {
            this.assembleJoinClause(leftName, rightName, semantic);
        }

        public String assembleJoinClause(String leftName, String rightName, int semantic) {
            EOEntity rightEntity;
            NSArray k;
            EOEntity leftEntity;
            if (!this.useAliases()) {
                return super.assembleJoinClause(leftName, rightName, semantic);
            }
            String leftAlias = leftName.substring(0, leftName.indexOf("."));
            String rightAlias = rightName.substring(0, rightName.indexOf("."));
            String relationshipKey = null;
            if (leftAlias.equals("t0")) {
                leftEntity = this.entity();
            } else {
                k = this.aliasesByRelationshipPath().allKeysForObject((Object)leftAlias);
                relationshipKey = k.count() > 0 ? (String)k.lastObject() : "";
                leftEntity = this.entityForKeyPath(relationshipKey);
            }
            if (rightAlias.equals("t0")) {
                rightEntity = this.entity();
            } else {
                k = this.aliasesByRelationshipPath().allKeysForObject((Object)rightAlias);
                relationshipKey = k.count() > 0 ? (String)k.lastObject() : "";
                rightEntity = this.entityForKeyPath(relationshipKey);
            }
            int dotIndex = relationshipKey.indexOf(".");
            relationshipKey = dotIndex == -1 ? relationshipKey : relationshipKey.substring(relationshipKey.lastIndexOf(".") + 1);
            EORelationship r = rightEntity.anyRelationshipNamed(relationshipKey);
            if (r == null || r.destinationEntity() != leftEntity) {
                r = leftEntity.anyRelationshipNamed(relationshipKey);
            }
            String rightTable = rightEntity.valueForSQLExpression((EOSQLExpression)this);
            String leftTable = leftEntity.valueForSQLExpression((EOSQLExpression)this);
            JoinClause jc = new JoinClause();
            jc.table1 = leftTable + " " + leftAlias;
            jc.table2 = rightTable + " " + rightAlias;
            switch (semantic) {
                case 2: {
                    jc.op = " LEFT OUTER JOIN ";
                    break;
                }
                case 3: {
                    jc.op = " RIGHT OUTER JOIN ";
                    break;
                }
                case 1: {
                    jc.op = " FULL OUTER JOIN ";
                    break;
                }
                case 0: {
                    jc.op = " INNER JOIN ";
                }
            }
            NSArray joins = r.joins();
            int joinsCount = joins.count();
            NSMutableArray joinStrings = new NSMutableArray(joinsCount);
            for (int i = 0; i < joinsCount; ++i) {
                EOJoin currentJoin = (EOJoin)joins.objectAtIndex(i);
                String left = leftAlias + "." + this.sqlStringForSchemaObjectName(currentJoin.sourceAttribute().columnName());
                String right = rightAlias + "." + this.sqlStringForSchemaObjectName(currentJoin.destinationAttribute().columnName());
                joinStrings.addObject((Object)(left + " = " + right));
            }
            jc.joinCondition = " ON " + joinStrings.componentsJoinedByString(" AND ");
            if (!this._alreadyJoined.containsObject((Object)jc)) {
                this._alreadyJoined.insertObjectAtIndex((Object)jc, 0);
                return jc.toString();
            }
            return null;
        }

        public String assembleSelectStatementWithAttributes(NSArray attributes, boolean lock, EOQualifier qualifier, NSArray fetchOrder, String selectString, String columnList, String tableList, String whereClause, String joinClause, String orderByClause, String lockClause) {
            if (orderByClause != null && orderByClause.length() > 0) {
                int i = 0;
                while (i != -1) {
                    int k;
                    int j;
                    if (orderByClause.indexOf(32, i) == i + 1) {
                        i += 2;
                    }
                    if ((j = orderByClause.indexOf(32, i)) > (k = orderByClause.indexOf(44, i)) && k != -1) {
                        j = k;
                    } else if (j == -1 && k == -1) {
                        j = orderByClause.length();
                    }
                    String orderColumn = orderByClause.substring(i, j);
                    if (columnList.indexOf(orderColumn) == -1) {
                        columnList = columnList.concat(", " + orderColumn);
                    }
                    i = orderByClause.indexOf(44, i);
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append(selectString);
            sb.append(columnList);
            if (selectString.indexOf(" DISTINCT") != -1) {
                String[] columns = orderByClause.split(",");
                for (int i = 0; i < columns.length; ++i) {
                    String column = columns[i].replaceFirst("\\s+(ASC|DESC)\\s*", "");
                    if (columnList.indexOf(column) != -1) continue;
                    sb.append(", ");
                    sb.append(column);
                }
            }
            sb.append(" FROM ");
            String fieldString = this._alreadyJoined.count() > 0 ? this.joinClauseString() : tableList;
            sb.append(fieldString);
            if (whereClause != null && whereClause.length() > 0 || joinClause != null && joinClause.length() > 0) {
                sb.append(" WHERE ");
                if (joinClause != null && joinClause.length() > 0) {
                    sb.append(joinClause);
                    if (whereClause != null && whereClause.length() > 0) {
                        sb.append(" AND ");
                    }
                }
                if (whereClause != null && whereClause.length() > 0) {
                    sb.append(whereClause);
                }
            }
            if (orderByClause != null && orderByClause.length() > 0) {
                sb.append(" ORDER BY ");
                sb.append(orderByClause);
            }
            if (lockClause != null && lockClause.length() > 0) {
                sb.append(" ");
                sb.append(lockClause);
            }
            return sb.toString();
        }

        public String joinClauseString() {
            JoinClause jc;
            NSMutableDictionary seenIt = new NSMutableDictionary();
            StringBuffer sb = new StringBuffer();
            EOSortOrdering.sortArrayUsingKeyOrderArray((NSMutableArray)this._alreadyJoined, (NSArray)new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"sortKey", (NSSelector)EOSortOrdering.CompareCaseInsensitiveAscending)));
            if (this._alreadyJoined.count() > 0) {
                jc = (JoinClause)this._alreadyJoined.objectAtIndex(0);
                sb.append(jc);
                seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table1);
                seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table2);
            }
            for (int i = 1; i < this._alreadyJoined.count(); ++i) {
                jc = (JoinClause)this._alreadyJoined.objectAtIndex(i);
                sb.append(jc.op);
                if (seenIt.objectForKey((Object)jc.table1) == null) {
                    sb.append(jc.table1);
                    seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table1);
                } else if (seenIt.objectForKey((Object)jc.table2) == null) {
                    sb.append(jc.table2);
                    seenIt.setObjectForKey((Object)Boolean.TRUE, (Object)jc.table2);
                }
                sb.append(jc.joinCondition);
            }
            return sb.toString();
        }

        public void addOrderByAttributeOrdering(EOSortOrdering eosortordering) {
            NSSelector sortOrdering = eosortordering.selector();
            String attribute = eosortordering.key();
            String column = this.sqlStringForAttributeNamed(attribute);
            if (column == null) {
                super.addOrderByAttributeOrdering(eosortordering);
            }
            StringBuffer sql = new StringBuffer(column);
            if (sortOrdering == EOSortOrdering.CompareCaseInsensitiveAscending) {
                if (this.entity()._attributeForPath(attribute).adaptorValueType() == 1) {
                    sql.append(" COLLATE INFORMATION_SCHEMA.CASE_INSENSITIVE ASC");
                } else {
                    sql.append(" ASC");
                }
            } else if (sortOrdering == EOSortOrdering.CompareCaseInsensitiveDescending) {
                if (this.entity()._attributeForPath(attribute).adaptorValueType() == 1) {
                    sql.append(" COLLATE INFORMATION_SCHEMA.CASE_INSENSITIVE DESC");
                } else {
                    sql.append(" DESC");
                }
            } else if (sortOrdering == EOSortOrdering.CompareAscending) {
                sql.append(" ASC");
            } else if (sortOrdering == EOSortOrdering.CompareDescending) {
                sql.append(" DESC");
            }
            this.appendItemToListString(sql.toString(), this._orderByString());
        }

        public String assembleDeleteStatementWithQualifier(EOQualifier eoqualifier, String table, String qualifier) {
            if (table != null && table.indexOf(34) == -1) {
                return super.assembleDeleteStatementWithQualifier(eoqualifier, _FrontBasePlugIn.quoteTableName(table), qualifier);
            }
            return super.assembleDeleteStatementWithQualifier(eoqualifier, table, qualifier);
        }

        public String assembleInsertStatementWithRow(NSDictionary nsdictionary, String table, String columns, String values) {
            if (table != null && table.indexOf(34) == -1) {
                return super.assembleInsertStatementWithRow(nsdictionary, _FrontBasePlugIn.quoteTableName(table), columns, values);
            }
            return super.assembleInsertStatementWithRow(nsdictionary, table, columns, values);
        }

        public String assembleUpdateStatementWithRow(NSDictionary dictionary, EOQualifier qualifier, String table, String values, String sqlQualifier) {
            this._qualifier = qualifier;
            if (table != null && table.indexOf(34) == -1) {
                return super.assembleUpdateStatementWithRow(dictionary, qualifier, _FrontBasePlugIn.quoteTableName(table), values, sqlQualifier);
            }
            return super.assembleUpdateStatementWithRow(dictionary, qualifier, table, values, sqlQualifier);
        }

        public String lockClause() {
            return "";
        }

        public boolean useBindVariables() {
            return this._useBindVariables;
        }

        public boolean shouldUseBindVariableForAttribute(EOAttribute eoattribute) {
            return this.useBindVariables() && !this.isLOBAttribute(eoattribute);
        }

        private boolean isLOBAttribute(EOAttribute att) {
            int internalType = _FrontBasePlugIn.internalTypeForExternal(att.externalType());
            return internalType == 21 || internalType == 20;
        }

        public boolean mustUseBindVariableForAttribute(EOAttribute eoattribute) {
            return false;
        }

        public String sqlStringForCaseInsensitiveLike(String value, String column) {
            StringBuffer sql = new StringBuffer();
            sql.append(column);
            sql.append(" LIKE ");
            sql.append(value);
            sql.append(" COLLATE INFORMATION_SCHEMA.CASE_INSENSITIVE");
            return sql.toString();
        }

        boolean hasLOBsToUpdate() {
            return this._lobList != null && this._lobList.count() > 0;
        }

        void resetlobList() {
            this._lobList = null;
        }

        NSArray lobList() {
            return this._lobList != null ? this._lobList : NSArray.EmptyArray;
        }

        public String sqlStringForKeyValueQualifier(EOKeyValueQualifier eokeyvaluequalifier) {
            String value;
            boolean flag;
            String attrubute = eokeyvaluequalifier.key();
            String column = this.sqlStringForAttributeNamed(attrubute);
            if (column == null) {
                throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + eokeyvaluequalifier.getClass().getName() + " " + eokeyvaluequalifier + " failed because attribute identified by key '" + attrubute + "' was not reachable from from entity '" + this._entity.name() + "'");
            }
            Object qualifier = eokeyvaluequalifier.value();
            if (qualifier instanceof EOQualifierVariable) {
                throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + eokeyvaluequalifier.getClass().getName() + " " + eokeyvaluequalifier + " failed because the qualifier variable '$" + ((EOQualifierVariable)qualifier).key() + "' is unbound.");
            }
            column = this.formatSQLString(column, this._entity._attributeForPath(attrubute).readFormat());
            NSSelector nsselector = eokeyvaluequalifier.selector();
            boolean bl = flag = nsselector.equals((Object)EOQualifier.QualifierOperatorLike) || nsselector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike) || nsselector.equals((Object)EOQualifier.QualifierOperatorContains);
            if (flag) {
                qualifier = this.sqlPatternFromShellPattern(qualifier.toString());
            }
            StringBuffer sql = new StringBuffer();
            char sqlEscapeChar = this.sqlEscapeChar();
            if (nsselector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike)) {
                value = this.sqlStringForValue(qualifier, attrubute);
                sql.append(this.sqlStringForCaseInsensitiveLike(value, column));
            } else {
                value = this.sqlStringForValue(qualifier, attrubute);
                sql.append(column);
                sql.append(" ");
                sql.append(this.sqlStringForSelector(nsselector, qualifier));
                sql.append(" ");
                sql.append(value);
            }
            if (value.indexOf(sqlEscapeChar) != -1 && flag) {
                sql.append(" ESCAPE '");
                sql.append(sqlEscapeChar);
                sql.append("'");
            }
            return sql.toString();
        }

        public String formatValueForAttribute(Object obj, EOAttribute eoattribute) {
            if (obj != null && obj != NSKeyValueCoding.NullValue) {
                if (eoattribute.valueFactoryMethod() != null && eoattribute.valueFactoryMethod().implementedByObject(obj) && eoattribute.adaptorValueConversionMethod().implementedByObject(obj)) {
                    obj = eoattribute.adaptorValueByConvertingAttributeValue(obj);
                }
                if (eoattribute.externalType() == null) {
                    throw new EOGeneralAdaptorException("Attribute " + eoattribute.name() + " on entity " + eoattribute.entity().name() + " with prototype named " + eoattribute.prototypeName() + " has no external type defined");
                }
                switch (_FrontBasePlugIn.internalTypeForExternal(eoattribute.externalType())) {
                    case 9: 
                    case 10: {
                        return this.escapedString(obj);
                    }
                    case 19: {
                        return this.escapedString(obj);
                    }
                    case 21: {
                        if (obj instanceof String && ((String)obj).length() == 27 && ((String)obj).startsWith("@")) {
                            return (String)obj;
                        }
                        if (this._lobList == null) {
                            this._lobList = new NSMutableArray();
                        }
                        this._lobList.addObject((Object)eoattribute);
                        this._lobList.addObject(obj);
                        return "NULL";
                    }
                    case 20: {
                        if (obj instanceof String && ((String)obj).length() == 27 && ((String)obj).startsWith("@")) {
                            return (String)obj;
                        }
                        if (this._lobList == null) {
                            this._lobList = new NSMutableArray();
                        }
                        this._lobList.addObject((Object)eoattribute);
                        this._lobList.addObject(obj);
                        return "NULL";
                    }
                    case 11: 
                    case 12: {
                        if (obj instanceof NSData) {
                            return this.formatBit((NSData)obj);
                        }
                        return "ERROR: Can not convert value from " + obj + " to Bit or Byte data type";
                    }
                    case 14: {
                        NSTimestampFormatter f = new NSTimestampFormatter("%H:%M:%S.%F");
                        StringBuffer time = new StringBuffer("TIME '");
                        f.format(obj, time, new FieldPosition(0));
                        time.append("'");
                        return time.toString();
                    }
                    case 15: {
                        NSTimestampFormatter f = new NSTimestampFormatter("%H:%M:%S.%F");
                        StringBuffer time = new StringBuffer("TIME '");
                        f.format(obj, time, new FieldPosition(0));
                        time.append(this.getTimeZone((TimeZone)NSTimeZone.defaultTimeZone()));
                        time.append("'");
                        return time.toString();
                    }
                    case 16: {
                        NSTimestampFormatter f = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");
                        StringBuffer time = new StringBuffer("TIMESTAMP '");
                        f.format(obj, time, new FieldPosition(0));
                        time.append("'");
                        return time.toString();
                    }
                    case 17: {
                        NSTimestampFormatter f = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S.%F");
                        StringBuffer time = new StringBuffer("TIMESTAMP '");
                        f.format(obj, time, new FieldPosition(0));
                        time.append(this.getTimeZone(TimeZone.getDefault()));
                        time.append("'");
                        return time.toString();
                    }
                    case 13: {
                        NSTimestampFormatter f = new NSTimestampFormatter("%Y-%m-%d");
                        StringBuffer time = new StringBuffer("DATE '");
                        f.format(obj, time, new FieldPosition(0));
                        time.append("'");
                        return time.toString();
                    }
                    case 1: {
                        if (obj instanceof Boolean) {
                            return obj.toString();
                        }
                        if (obj instanceof String) {
                            String str = (String)obj;
                            if ("yes".equalsIgnoreCase(str) || "y".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str)) {
                                return "TRUE";
                            }
                            if ("no".equalsIgnoreCase(str) || "n".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str) || "0".equalsIgnoreCase(str)) {
                                return "FALSE";
                            }
                            throw new IllegalArgumentException("Unknown boolean value '" + str + "' for the attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
                        }
                        if (obj instanceof NSData) {
                            return ((NSData)obj).bytes()[0] == 0 ? "FALSE" : "TRUE";
                        }
                        if (((Number)obj).intValue() == 0) {
                            return "FALSE";
                        }
                        return "TRUE";
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 22: 
                    case 23: {
                        if (obj instanceof BigDecimal) {
                            return ((BigDecimal)obj).setScale(eoattribute.scale(), 4).toString();
                        }
                        if (obj instanceof Number) {
                            String valueType = eoattribute.valueType();
                            if (valueType == null || "i".equals(valueType)) {
                                return String.valueOf(((Number)obj).intValue());
                            }
                            if ("l".equals(valueType)) {
                                return String.valueOf(((Number)obj).longValue());
                            }
                            if ("f".equals(valueType)) {
                                return String.valueOf(((Number)obj).floatValue());
                            }
                            if ("d".equals(valueType)) {
                                return String.valueOf(((Number)obj).doubleValue());
                            }
                            if ("s".equals(valueType)) {
                                return String.valueOf(((Number)obj).shortValue());
                            }
                            if ("c".equals(valueType)) {
                                return String.valueOf(((Number)obj).intValue());
                            }
                            throw new IllegalArgumentException("Unknown number value type '" + valueType + "' for the attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
                        }
                        if (obj instanceof Boolean) {
                            String valueType = eoattribute.valueType();
                            return String.valueOf((Boolean)obj != false ? 1 : 0);
                        }
                        if (obj instanceof String) {
                            String str = (String)obj;
                            String valueType = eoattribute.valueType();
                            if (valueType == null || "i".equals(valueType)) {
                                return String.valueOf(Integer.parseInt(str));
                            }
                            if ("l".equals(valueType)) {
                                return String.valueOf(Long.parseLong(str));
                            }
                            if ("f".equals(valueType)) {
                                return String.valueOf(Float.parseFloat(str));
                            }
                            if ("d".equals(valueType)) {
                                return String.valueOf(Double.parseDouble(str));
                            }
                            if ("s".equals(valueType)) {
                                return String.valueOf(Short.parseShort(str));
                            }
                            if ("c".equals(valueType)) {
                                return String.valueOf(Integer.parseInt(str));
                            }
                            throw new IllegalArgumentException("Unknown number value type '" + valueType + "' for attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
                        }
                        throw new IllegalArgumentException("Unknown number value '" + obj + "' for attribute " + eoattribute.entity().name() + "." + eoattribute.name() + ".");
                    }
                }
                return this.escapedString(obj);
            }
            return super.formatValueForAttribute(obj, eoattribute);
        }

        public String escapedString(Object obj) {
            String value = obj.toString();
            String escapedStr = value.indexOf("'") == -1 ? "'" + value + "'" : "'" + this.addEscapeChars(value) + "'";
            return escapedStr;
        }

        public String addEscapeChars(String value) {
            StringBuffer sb = new StringBuffer(value);
            int index = 0;
            int i = 0;
            while (i < value.length() && (index = value.indexOf("'", index)) != -1) {
                sb.insert(index + i, "'");
                ++i;
                ++index;
            }
            return sb.toString();
        }

        String formatBit(NSData data) {
            char[] heximals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            byte[] bytes = data.bytes();
            StringBuffer result = new StringBuffer(2 * data.length() + 3);
            result.append("X'");
            for (int i = 0; i < data.length(); ++i) {
                int b = bytes[i] & 0xFF;
                result.append(heximals[b / 16]);
                result.append(heximals[b % 16]);
            }
            result.append("'");
            return result.toString();
        }

        private String getTimeZone(TimeZone tz) {
            String sign = "+";
            int tzOffset = tz.getRawOffset();
            if (tz.useDaylightTime() && tz.inDaylightTime(new Date(System.currentTimeMillis()))) {
                tzOffset = (int)((long)tzOffset + 3600000L);
            }
            if (tzOffset < 0) {
                tzOffset = -tzOffset;
                sign = "-";
            }
            int hour = tzOffset / 3600000;
            int minute = tzOffset % 3600000 / 60000;
            String hourString = String.valueOf(hour);
            String minuteString = String.valueOf(minute);
            if (hourString.length() < 2) {
                hourString = "0" + hourString;
            }
            if (minuteString.length() < 2) {
                minuteString = "0" + minuteString;
            }
            return sign + hourString + ":" + minuteString;
        }

        private EOEntity entityForKeyPath(String keyPath) {
            NSArray keys = NSArray.componentsSeparatedByString((String)keyPath, (String)".");
            EOEntity ent = this.entity();
            for (int i = 0; i < keys.count(); ++i) {
                String k = (String)keys.objectAtIndex(i);
                EORelationship rel = ent.anyRelationshipNamed(k);
                if (rel == null) {
                    if (ent.anyAttributeNamed(k) != null) break;
                    throw new IllegalArgumentException("relationship " + keyPath + " generated null");
                }
                ent = rel.destinationEntity();
            }
            return ent;
        }

        public class JoinClause {
            String table1;
            String op;
            String table2;
            String joinCondition;

            public String toString() {
                return this.table1 + this.op + this.table2 + this.joinCondition;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof JoinClause)) {
                    return false;
                }
                return this.toString().equals(obj.toString());
            }

            public String sortKey() {
                return this.table1.substring(this.table1.indexOf(" ") + 1);
            }
        }
    }

    public static class FrontbaseSynchronizationFactory
    extends EOSynchronizationFactory {
        public FrontbaseSynchronizationFactory(EOAdaptor eoadaptor) {
            super(eoadaptor);
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }

        public static boolean boolValueForKeyDefault(NSDictionary nsdictionary, String s, boolean flag) {
            String s1 = (String)nsdictionary.objectForKey((Object)s);
            if (s1 == null) {
                return flag;
            }
            return s1.equals("YES");
        }

        public String schemaCreationScriptForEntities(NSArray allEntities, NSDictionary options) {
            StringBuffer result = new StringBuffer();
            if (options == null) {
                options = NSDictionary.EmptyDictionary;
            }
            NSArray statements = this.schemaCreationStatementsForEntities(allEntities, options);
            int count = statements.count();
            for (int i = 0; i < count; ++i) {
                this.appendExpressionToScript((EOSQLExpression)statements.objectAtIndex(i), result);
            }
            return new String(result);
        }

        public NSArray schemaCreationStatementsForEntities(NSArray entities, NSDictionary options) {
            NSMutableArray result = new NSMutableArray();
            if (entities == null || entities.count() == 0) {
                return result;
            }
            result.addObject((Object)this._expressionForString("SET TRANSACTION ISOLATION LEVEL SERIALIZABLE, LOCKING PESSIMISTIC"));
            NSDictionary nsdictionary1 = ((EOEntity)entities.lastObject()).model().connectionDictionary();
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "dropDatabase", false)) {
                result.addObjectsFromArray(this.dropDatabaseStatementsForConnectionDictionary(nsdictionary1, null));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "createDatabase", false)) {
                result.addObjectsFromArray(this.createDatabaseStatementsForConnectionDictionary(nsdictionary1, null));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "dropPrimaryKeySupport", true)) {
                NSArray nsarray1 = this.primaryKeyEntityGroupsForEntities(entities);
                result.addObjectsFromArray(this.dropPrimaryKeySupportStatementsForEntityGroups(nsarray1));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "dropTables", true)) {
                NSArray nsarray2 = this.tableEntityGroupsForEntities(entities);
                result.addObjectsFromArray(this.dropTableStatementsForEntityGroups(nsarray2));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "createTables", true)) {
                NSArray nsarray3 = this.tableEntityGroupsForEntities(entities);
                result.addObjectsFromArray(this.createTableStatementsForEntityGroups(nsarray3));
                result.addObjectsFromArray(this.createIndexStatementsForEntityGroups(nsarray3));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "createPrimaryKeySupport", true)) {
                NSArray nsarray4 = this.primaryKeyEntityGroupsForEntities(entities);
                result.addObjectsFromArray(this.primaryKeySupportStatementsForEntityGroups(nsarray4));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "primaryKeyConstraints", true)) {
                NSArray nsarray5 = this.tableEntityGroupsForEntities(entities);
                result.addObjectsFromArray(this.primaryKeyConstraintStatementsForEntityGroups(nsarray5));
            }
            if (FrontbaseSynchronizationFactory.boolValueForKeyDefault(options, "foreignKeyConstraints", false)) {
                NSMutableSet nsmutableset = new NSMutableSet();
                NSArray nsarray6 = this.tableEntityGroupsForEntities(entities);
                for (int i = 0; i < nsarray6.count(); ++i) {
                    result.addObjectsFromArray(this._foreignKeyConstraintStatementsForEntityGroup((NSArray)nsarray6.objectAtIndex(i)));
                }
            }
            result.addObject((Object)this._expressionForString("COMMIT"));
            return result;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray nsarray) {
            return new NSArray((Object)this._expressionForString("-- The 'Drop Primary Key Support' option is unavailable."));
        }

        public NSArray dropDatabaseStatementsForConnectionDictionary(NSDictionary nsdictionary, NSDictionary nsdictionary1) {
            return new NSArray((Object)this._expressionForString("-- The 'Drop Database' option is unavailable."));
        }

        public NSArray createDatabaseStatementsForConnectionDictionary(NSDictionary nsdictionary, NSDictionary nsdictionary1) {
            return new NSArray((Object)this._expressionForString("-- The 'Create Database' option is unavailable."));
        }

        public NSArray dropTableStatementsForEntityGroups(NSArray entityGroups) {
            NSLog.debug.appendln((Object)"In dropTableStatementsForEntityGroups");
            return super.dropTableStatementsForEntityGroups(entityGroups);
        }

        public NSArray dropTableStatementsForEntityGroup(NSArray nsarray) {
            NSDictionary dictionary;
            NSLog.debug.appendln((Object)"In dropTableStatementsForEntityGroup (no s)");
            EOEntity entity = (EOEntity)nsarray.objectAtIndex(0);
            String dropType = " CASCADE";
            if (entity.userInfo() != null && (dictionary = entity.userInfo()).valueForKey("Restrict") != null && ((String)dictionary.valueForKey("Restrict")).equals("true")) {
                dropType = " RESTRICT";
            }
            EOSQLExpression expression = this._expressionForString("DROP TABLE " + _FrontBasePlugIn.quoteTableName(entity.externalName()) + dropType);
            return new NSArray((Object)expression);
        }

        public NSArray primaryKeySupportStatementsForEntityGroup(NSArray entityGroup) {
            if (entityGroup == null) {
                return NSArray.EmptyArray;
            }
            NSMutableArray result = new NSMutableArray();
            EOEntity eoentity = null;
            for (int i = entityGroup.count() - 1; i >= 0; --i) {
                eoentity = (EOEntity)entityGroup.objectAtIndex(i);
                String externalName = eoentity.externalName();
                if (externalName == null || externalName.length() <= 0) continue;
                String unique = null;
                if (eoentity.model() != null && (unique = System.getProperty("com.frontbase.unique." + eoentity.model().name() + "." + eoentity.name())) == null) {
                    unique = System.getProperty("com.frontbase.unique." + eoentity.model().name());
                }
                if (unique == null) {
                    unique = System.getProperty("com.frontbase.unique");
                }
                if (unique == null) {
                    unique = "1000000";
                }
                result.addObject((Object)this._expressionForString("SET UNIQUE = " + unique + " FOR " + _FrontBasePlugIn.quoteTableName(externalName)));
            }
            return result;
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
            if (!relationship.isToMany() && this.isPrimaryKeyAttributes(relationship.destinationEntity(), relationship.destinationAttributes())) {
                StringBuffer sql = new StringBuffer();
                String tableName = relationship.entity().externalName();
                sql.append("ALTER TABLE ");
                sql.append(_FrontBasePlugIn.quoteTableName(tableName.toUpperCase()));
                sql.append(" ADD");
                StringBuffer constraint = new StringBuffer(" CONSTRAINT \"FOREIGN_KEY_");
                constraint.append(tableName);
                StringBuffer fkSql = new StringBuffer(" FOREIGN KEY (");
                NSArray attributes = relationship.sourceAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    fkSql.append("\"");
                    String columnName = ((EOAttribute)attributes.objectAtIndex(i)).columnName();
                    fkSql.append(columnName.toUpperCase());
                    constraint.append(columnName);
                    fkSql.append("\"");
                }
                fkSql.append(") REFERENCES ");
                constraint.append("_");
                String referencedExternalName = relationship.destinationEntity().externalName();
                fkSql.append(_FrontBasePlugIn.quoteTableName(referencedExternalName.toUpperCase()));
                constraint.append(referencedExternalName);
                fkSql.append(" (");
                attributes = relationship.destinationAttributes();
                for (int i = 0; i < attributes.count(); ++i) {
                    constraint.append("_");
                    if (i != 0) {
                        fkSql.append(", ");
                    }
                    fkSql.append("\"");
                    String referencedColumnName = ((EOAttribute)attributes.objectAtIndex(i)).columnName();
                    fkSql.append(referencedColumnName.toUpperCase());
                    constraint.append(referencedColumnName);
                    fkSql.append("\"");
                }
                constraint.append("\"");
                fkSql.append(") DEFERRABLE INITIALLY DEFERRED");
                sql.append(constraint);
                sql.append(fkSql);
                return new NSArray((Object)this._expressionForString(sql.toString()));
            }
            return NSArray.EmptyArray;
        }

        public NSArray createTableStatementsForEntityGroups(NSArray nsarray) {
            NSMutableArray nsmutablearray = new NSMutableArray();
            for (int i = 0; i < nsarray.count(); ++i) {
                nsmutablearray.addObjectsFromArray(this.createTableStatementsForEntityGroup((NSArray)nsarray.objectAtIndex(i)));
            }
            return nsmutablearray;
        }

        public NSArray createTableStatementsForEntityGroup(NSArray nsarray) {
            int j;
            EOSQLExpression eosqlexpression = null;
            EOEntity eoentity = null;
            NSMutableArray nsmutablearray = new NSMutableArray();
            int n = j = nsarray != null ? nsarray.count() : 0;
            if (j == 0) {
                return NSArray.EmptyArray;
            }
            StringBuffer columns = new StringBuffer();
            eosqlexpression = this._expressionForEntity((EOEntity)nsarray.objectAtIndex(0));
            for (int i = 0; i < j; ++i) {
                eoentity = (EOEntity)nsarray.objectAtIndex(i);
                NSArray nsarray1 = eoentity.attributes();
                int l = nsarray1 != null ? nsarray1.count() : 0;
                for (int k = 0; k < l; ++k) {
                    EOAttribute eoattribute = (EOAttribute)nsarray1.objectAtIndex(k);
                    String column = eoattribute.columnName();
                    if (eoattribute.isDerived() || eoattribute.isFlattened() || column == null || column.length() <= 0 || nsmutablearray.indexOfObject((Object)column) != -1) continue;
                    if (columns.length() > 0) {
                        columns.append(',');
                        columns.append('\n');
                        columns.append('\t');
                    }
                    columns.append(this.addCreateClauseForAttribute(eoattribute));
                    nsmutablearray.addObject((Object)column);
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ");
            sql.append(_FrontBasePlugIn.quoteTableName(eoentity.externalName()));
            sql.append(" (\n\t");
            sql.append(columns.toString());
            sql.append("\n)");
            eosqlexpression.setStatement(sql.toString());
            return new NSArray((Object)eosqlexpression);
        }

        public NSArray createIndexStatementsForEntityGroups(NSArray nsarray) {
            NSMutableArray nsmutablearray = new NSMutableArray();
            for (int i = 0; i < nsarray.count(); ++i) {
                nsmutablearray.addObjectsFromArray(this.createIndexStatementsForEntityGroup((NSArray)nsarray.objectAtIndex(i)));
            }
            return nsmutablearray;
        }

        public NSArray createIndexStatementsForEntityGroup(NSArray nsarray) {
            int j;
            NSMutableArray result = new NSMutableArray();
            EOSQLExpression eosqlexpression = null;
            EOEntity eoentity = null;
            NSMutableArray nsmutablearray = new NSMutableArray();
            int n = j = nsarray != null ? nsarray.count() : 0;
            if (j == 0) {
                return NSArray.EmptyArray;
            }
            eosqlexpression = this._expressionForEntity((EOEntity)nsarray.objectAtIndex(0));
            for (int i = 0; i < j; ++i) {
                eoentity = (EOEntity)nsarray.objectAtIndex(i);
                NSDictionary dictionary = eoentity.userInfo();
                if (dictionary == null || dictionary.valueForKey("Index") == null) continue;
                dictionary = (NSDictionary)dictionary.valueForKey("Index");
                Enumeration e = dictionary.keyEnumerator();
                while (e.hasMoreElements()) {
                    eosqlexpression.setStatement((String)dictionary.objectForKey(e.nextElement()));
                    result.addObject((Object)eosqlexpression);
                }
            }
            return result;
        }

        public StringBuffer addCreateClauseForAttribute(EOAttribute eoattribute) {
            EOSQLExpression expression = this._expressionForEntity(eoattribute.entity());
            expression.addCreateClauseForAttribute(eoattribute);
            return new StringBuffer(expression.listString());
        }

        public String columnTypeStringForAttribute(EOAttribute eoattribute) {
            EOSQLExpression expression = this._expressionForEntity(eoattribute.entity());
            return expression.columnTypeStringForAttribute(eoattribute);
        }

        public NSArray statementsToConvertColumnType(String columnName, String tableName, EOSchemaSynchronization.ColumnTypes oldType, EOSchemaSynchronization.ColumnTypes newType, NSDictionary nsdictionary) {
            String columnTypeString = this.statementToCreateDataTypeClause(newType);
            NSArray statements = new NSArray((Object)this._expressionForString("alter column " + _FrontBasePlugIn.quoteTableName(tableName) + "." + _FrontBasePlugIn.quoteTableName(columnName) + " to " + columnTypeString));
            return statements;
        }

        public NSArray statementsToModifyColumnNullRule(String columnName, String tableName, boolean allowsNull, NSDictionary nsdictionary) {
            NSArray statements = allowsNull ? new NSArray((Object)this._expressionForString("alter table " + _FrontBasePlugIn.quoteTableName(tableName) + " drop constraint " + _FrontBasePlugIn.quoteTableName(_FrontBasePlugIn.notNullConstraintName(tableName, columnName)) + " cascade")) : new NSArray((Object)this._expressionForString("alter table " + _FrontBasePlugIn.quoteTableName(tableName) + " add constraint " + _FrontBasePlugIn.quoteTableName(_FrontBasePlugIn.notNullConstraintName(tableName, columnName)) + " check (" + _FrontBasePlugIn.quoteTableName(columnName) + " is not null)"));
            return statements;
        }

        public NSArray statementsToDeleteColumnNamed(String columnName, String tableName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("alter table " + _FrontBasePlugIn.quoteTableName(tableName) + " drop column \"" + columnName.toUpperCase() + "\" cascade"));
        }

        public String _columnCreationClauseForAttribute(EOAttribute attribute) {
            return this.addCreateClauseForAttribute(attribute).toString();
        }

        public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
            String clause = this._columnCreationClauseForAttribute(attribute);
            return new NSArray((Object)this._expressionForString("alter table " + _FrontBasePlugIn.quoteTableName(attribute.entity().externalName()) + " add " + clause));
        }

        private String statementToCreateDataTypeClause(EOSchemaSynchronization.ColumnTypes columntypes) {
            switch (_FrontBasePlugIn.internalTypeForExternal(columntypes.name())) {
                case 7: 
                case 8: {
                    int j = columntypes.precision();
                    if (j == 0) {
                        return columntypes.name();
                    }
                    int k = columntypes.scale();
                    if (k == 0) {
                        return columntypes.name() + "(" + j + ")";
                    }
                    return columntypes.name() + "(" + j + "," + k + ")";
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int l = columntypes.width();
                    if (l == 0) {
                        l = columntypes.precision();
                    }
                    if (l == 0) {
                        return columntypes.name();
                    }
                    return columntypes.name() + "(" + l + ")";
                }
                case 16: {
                    int m = columntypes.precision();
                    if (m == 0) {
                        return columntypes.name();
                    }
                    return columntypes.name() + "(" + m + ")";
                }
            }
            return columntypes.name();
        }

        public NSArray statementsToRenameColumnNamed(String columnName, String tableName, String newName, NSDictionary nsdictionary) {
            return new NSArray((Object)this._expressionForString("alter column name " + _FrontBasePlugIn.quoteTableName(tableName) + "." + _FrontBasePlugIn.quoteTableName(columnName) + " to " + _FrontBasePlugIn.quoteTableName(newName)));
        }

        public NSArray statementsToRenameTableNamed(String tableName, String newName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("alter table name " + _FrontBasePlugIn.quoteTableName(tableName) + " to " + _FrontBasePlugIn.quoteTableName(newName)));
        }

        boolean isPrimaryKeyAttributes(EOEntity entity, NSArray attributes) {
            boolean result;
            NSArray keys = entity.primaryKeyAttributeNames();
            boolean bl = result = attributes.count() == keys.count();
            if (result) {
                for (int i = 0; i < keys.count() && (result = keys.indexOfObject((Object)((EOAttribute)attributes.objectAtIndex(i)).name()) != -1); ++i) {
                }
            }
            return result;
        }

        public NSArray primaryKeyConstraintStatementsForEntityGroups(NSArray entityGroups) {
            NSMutableArray result = new NSMutableArray();
            for (int i = 0; i < entityGroups.count(); ++i) {
                result.addObjectsFromArray(this.primaryKeyConstraintStatementsForEntityGroup((NSArray)entityGroups.objectAtIndex(i)));
            }
            return result;
        }

        public NSArray primaryKeyConstraintStatementsForEntityGroup(NSArray entityGroup) {
            if (entityGroup.count() != 0) {
                EOEntity entity = (EOEntity)entityGroup.objectAtIndex(0);
                String tableName = entity.externalName();
                NSArray keys = entity.primaryKeyAttributeNames();
                StringBuffer sql = new StringBuffer();
                if (tableName != null && keys.count() > 0) {
                    sql.append("ALTER TABLE ");
                    sql.append(_FrontBasePlugIn.quoteTableName(tableName.toUpperCase()));
                    sql.append(" ADD");
                    StringBuffer constraint = new StringBuffer(" CONSTRAINT \"PRIMARY_KEY_");
                    constraint.append(tableName);
                    StringBuffer pkSql = new StringBuffer(" PRIMARY KEY (");
                    for (int j = 0; j < keys.count(); ++j) {
                        constraint.append("_");
                        if (j != 0) {
                            pkSql.append(",");
                        }
                        pkSql.append("\"");
                        String columnName = entity.attributeNamed((String)keys.objectAtIndex(j)).columnName();
                        pkSql.append(columnName.toUpperCase());
                        pkSql.append("\"");
                        constraint.append(columnName);
                    }
                    constraint.append("\"");
                    pkSql.append(") NOT DEFERRABLE INITIALLY IMMEDIATE");
                    sql.append(constraint);
                    sql.append(pkSql);
                    return new NSArray((Object)this._expressionForString(sql.toString()));
                }
            }
            return NSArray.EmptyArray;
        }
    }
}

