/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woenvironment.frameworks;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.woenvironment.frameworks.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFolderRoot<T extends IFramework>
extends Root<T> {
    private File rootFolder;
    private File frameworksFolder;

    public AbstractFolderRoot(String string, String string2, File file, File file2) {
        super(string, string2);
        this.rootFolder = file;
        this.frameworksFolder = file2;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public File getFrameworksFolder() {
        return this.frameworksFolder;
    }

    protected abstract T createFramework(File var1);

    @Override
    public Set<T> getFrameworks() {
        File[] fileArray;
        TreeSet<T> treeSet = new TreeSet<T>();
        if (this.frameworksFolder != null && this.frameworksFolder.exists() && (fileArray = this.frameworksFolder.listFiles()) != null) {
            for (File file : fileArray) {
                String string = file.getName();
                if (!string.endsWith(".framework") || !new File(file, "Resources/Java").exists()) continue;
                treeSet.add(this.createFramework(file));
            }
        }
        return treeSet;
    }

    public String toString() {
        return "[Root: name = " + this.getName() + "; folder = " + this.frameworksFolder + "]";
    }
}

