/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.PatternSet;
import org.objectstyle.woenvironment.env.WOVariables;
import org.objectstyle.woproject.ant.FrameworkSet;
import org.objectstyle.woproject.ant.OtherClasspathSet;
import org.objectstyle.woproject.ant.ProjectFormat;
import org.objectstyle.woproject.ant.WOApplication;
import org.objectstyle.woproject.ant.WOTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppFormat
extends ProjectFormat {
    protected HashMap<String, String> templateMap = new HashMap();
    protected HashMap<String, FilterSetCollection> filterMap = new HashMap();
    protected String appPaths;
    protected String frameworkPaths;
    protected String otherClasspaths;

    public AppFormat(WOTask wOTask) {
        super(wOTask);
        this.prepare();
    }

    private void prepare() {
        this.log("AppFormat prepare", 3);
        this.preparePaths();
        this.prepare52();
        this.prepareWindows();
        this.prepareUnix();
        this.prepareMac();
        String string = new File(this.getApplicatonTask().contentsDir(), "Info.plist").getPath();
        this.createMappings(string, this.woappPlusVersion() + "/Info.plist", this.infoFilter(null));
        if (((WOApplication)this.task).webXML) {
            String string2 = new File(this.getApplicatonTask().contentsDir(), "web.xml").getPath();
            this.createMappings(string2, this.woappPlusVersion() + "/web.xml", this.webXMLFilter());
        }
    }

    private void preparePaths() {
        this.appPaths = this.buildAppPaths();
        this.frameworkPaths = this.buildFrameworkPaths();
        this.otherClasspaths = this.buildOtherClassPaths();
    }

    private void prepare52() {
        if (this.getApplicatonTask().getWOEnvironment().wo52()) {
            Copy copy = new Copy();
            copy.setProject(this.getApplicatonTask().getProject());
            copy.setTaskName("copy bootstrap");
            copy.setFile(this.getApplicatonTask().getWOEnvironment().bootstrap());
            copy.setTodir(this.getApplicatonTask().taskDir());
            copy.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String buildAppPaths() {
        FileSet fileSet = null;
        PatternSet.NameEntry nameEntry = null;
        PatternSet.NameEntry nameEntry2 = null;
        DirectoryScanner directoryScanner = null;
        String[] stringArray = null;
        StringBuffer stringBuffer = null;
        try {
            fileSet = new FileSet();
            fileSet.setDir(this.getApplicatonTask().contentsDir());
            nameEntry = fileSet.createInclude();
            nameEntry.setName("Resources/Java/**/*.jar");
            nameEntry2 = fileSet.createInclude();
            nameEntry2.setName("Resources/Java/**/*.zip");
            directoryScanner = fileSet.getDirectoryScanner(this.task.getProject());
            stringArray = directoryScanner.getIncludedFiles();
            stringBuffer = new StringBuffer();
            stringBuffer.append("APPROOT").append(File.separatorChar).append("Resources").append(File.separatorChar).append("Java").append(File.separatorChar).append(System.getProperty("line.separator"));
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (i == 0 && stringArray[j].toString().indexOf("webobjects") >= 0 || i == 1 && stringArray[j].toString().indexOf("webobjects") < 0) continue;
                    stringBuffer.append("APPROOT").append(File.separatorChar).append(stringArray[j]).append(System.getProperty("line.separator"));
                }
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            this.log(exception.getMessage(), 1);
        }
        finally {
            fileSet = null;
            nameEntry = null;
            nameEntry2 = null;
            directoryScanner = null;
            stringArray = null;
            stringBuffer = null;
        }
        return "";
    }

    protected String buildFrameworkPaths() {
        WOVariables wOVariables = this.getApplicatonTask().getWOEnvironment().getWOVariables();
        String string = this.getApplicatonTask().relativeEmbeddedFrameworksDir();
        String string2 = FrameworkSet.jarsPathForFrameworkSets(this.task.getProject(), string, this.getApplicatonTask().getFrameworkSets(), wOVariables);
        return string2;
    }

    protected String buildOtherClassPaths() {
        StringBuffer stringBuffer = new StringBuffer();
        List<OtherClasspathSet> list = this.getApplicatonTask().getOtherClasspath();
        Project project = this.task.getProject();
        HashSet<File> hashSet = new HashSet<File>();
        int n = list.size();
        try {
            for (int i = 0; i < n; ++i) {
                OtherClasspathSet otherClasspathSet = list.get(i);
                otherClasspathSet.collectClassPaths(project, hashSet);
            }
        }
        catch (BuildException buildException) {
            this.log(buildException.getMessage(), 1);
        }
        if (hashSet.size() > 0) {
            File[] fileArray = hashSet.toArray(new File[0]);
            n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                String string = this.getApplicatonTask().getWOEnvironment().getWOVariables().encodePathForFile(fileArray[i]);
                boolean bl2 = bl = string.endsWith(".jar") || string.endsWith(".zip");
                if (!bl && !string.endsWith("/")) {
                    string = string + "/";
                }
                stringBuffer.append(string).append("\r\n");
            }
        }
        return stringBuffer.toString();
    }

    private void prepareWindows() {
        File file = new File(this.getApplicatonTask().contentsDir(), "Windows");
        String string = new File(file, "CLSSPATH.TXT").getPath();
        this.createMappings(string, this.woappPlusVersion() + "/Contents/Windows/CLSSPATH.TXT", this.classpathFilter('\\'));
        String string2 = new File(file, "SUBPATHS.TXT").getPath();
        this.createMappings(string2, this.woappPlusVersion() + "/Contents/Windows/SUBPATHS.TXT");
        String string3 = new File(file, this.getName() + ".cmd").getPath();
        this.createMappings(string3, this.woappPlusVersion() + "/Contents/Windows/appstart.cmd", this.startupScriptFilter());
        File file2 = this.getApplicatonTask().taskDir();
        String string4 = this.getApplicatonTask().startupScriptName;
        if (string4 == null || string4.length() == 0) {
            string4 = this.getName();
        }
        String string5 = new File(file2, string4 + ".cmd").getPath();
        this.createMappings(string5, this.woappPlusVersion() + "/Contents/Windows/appstart.cmd", this.startupScriptFilter());
    }

    private void prepareUnix() {
        File file = new File(this.getApplicatonTask().contentsDir(), "UNIX");
        String string = new File(file, "UNIXClassPath.txt").getPath();
        this.createMappings(string, this.woappPlusVersion() + "/Contents/UNIX/UNIXClassPath.txt", this.classpathFilter('/'));
    }

    private void prepareMac() {
        File file = new File(this.getApplicatonTask().contentsDir(), "MacOS");
        String string = new File(file, "MacOSClassPath.txt").getPath();
        this.createMappings(string, this.woappPlusVersion() + "/Contents/MacOS/MacOSClassPath.txt", this.classpathFilter('/'));
        String string2 = new File(file, "MacOSXServerClassPath.txt").getPath();
        this.createMappings(string2, this.woappPlusVersion() + "/Contents/MacOS/MacOSXServerClassPath.txt", this.classpathFilter('/'));
        String string3 = new File(file, this.getName()).getPath();
        this.createMappings(string3, this.woappPlusVersion() + "/Contents/MacOS/appstart", this.startupScriptFilter());
        File file2 = this.getApplicatonTask().taskDir();
        String string4 = this.getApplicatonTask().startupScriptName;
        if (string4 == null || string4.length() == 0) {
            string4 = this.getName();
        }
        String string5 = new File(file2, string4).getPath();
        this.createMappings(string5, this.woappPlusVersion() + "/Contents/MacOS/appstart", this.startupScriptFilter());
    }

    private FilterSet classpathFilter(char c) {
        FilterSet filterSet = new FilterSet();
        if (c == File.separatorChar) {
            filterSet.addFilter("APP_JAR", this.appPaths);
            filterSet.addFilter("FRAMEWORK_JAR", this.frameworkPaths);
            filterSet.addFilter("OTHER_PATHS", this.otherClasspaths);
        } else {
            filterSet.addFilter("APP_JAR", this.appPaths.replace(File.separatorChar, c));
            filterSet.addFilter("FRAMEWORK_JAR", this.frameworkPaths.replace(File.separatorChar, c));
            filterSet.addFilter("OTHER_PATHS", this.otherClasspaths.replace(File.separatorChar, c));
        }
        return filterSet;
    }

    private String getAppClass() {
        return this.task.getPrincipalClass();
    }

    private String getServletAdaptor() {
        return this.task.getServletAdaptor();
    }

    private void createMappings(String string, String string2, FilterSet filterSet) {
        FilterSetCollection filterSetCollection = new FilterSetCollection(filterSet);
        FilterSet filterSet2 = this.additionalBuildSettingsFilter();
        filterSet.addFilter("APP_CLASS", this.getAppClass());
        filterSet.addFilter("JAR_NAME", this.getJarName());
        if (filterSet2 != null) {
            filterSetCollection.addFilterSet(filterSet2);
        }
        this.createMappings(string, string2, filterSetCollection);
    }

    private void createMappings(String string, String string2) {
        this.createMappings(string, string2, (FilterSetCollection)null);
    }

    private void createMappings(String string, String string2, FilterSetCollection filterSetCollection) {
        this.templateMap.put(string, string2);
        this.filterMap.put(string, filterSetCollection);
    }

    private WOApplication getApplicatonTask() {
        return (WOApplication)this.task;
    }

    @Override
    public Iterator<String> fileIterator() {
        return this.templateMap.keySet().iterator();
    }

    @Override
    public String templateForTarget(String string) throws BuildException {
        String string2 = this.templateMap.get(string);
        if (string2 == null) {
            throw new BuildException("Invalid target, no template found: " + string);
        }
        return string2;
    }

    @Override
    public FilterSetCollection filtersForTarget(String string) throws BuildException {
        if (!this.filterMap.containsKey(string)) {
            throw new BuildException("Invalid target: " + string);
        }
        return this.filterMap.get(string);
    }

    public String woappPlusVersion() {
        if (this.getApplicatonTask().getWOEnvironment().wo5or51()) {
            return "woapp";
        }
        return "woapp_52";
    }

    private FilterSet additionalBuildSettingsFilter() {
        String string = this.getApplicatonTask().getJvmOptions();
        String string2 = this.getApplicatonTask().getJVM();
        String string3 = this.getApplicatonTask().getJDB();
        String string4 = this.getApplicatonTask().getJDBOptions();
        String string5 = this.getApplicatonTask().getJavaVersion();
        if (string != null) {
            FilterSet filterSet = new FilterSet();
            filterSet.addFilter("JVM_OPTIONS", string);
            filterSet.addFilter("JVM", string2);
            filterSet.addFilter("JDB", string3);
            filterSet.addFilter("JDB_OPTIONS", string4);
            filterSet.addFilter("JAVA_VERSION", string5);
            return filterSet;
        }
        return null;
    }

    @Override
    public void release() {
        super.release();
    }

    public FilterSetCollection startupScriptFilter() {
        FilterSet filterSet = new FilterSet();
        String string = this.getApplicatonTask().getFrameworksBaseURL();
        string = string != null && string.length() > 0 ? "-WOFrameworksBaseURL " + string : "";
        filterSet.addFilter("-WOFrameworksBaseURL", string);
        return new FilterSetCollection(filterSet);
    }

    protected String stripPath(String string) {
        string = string.replace("WOROOT", "");
        string = string.replace("APPROOT", "");
        string = string.replace("LOCALROOT", "");
        return string;
    }

    public FilterSetCollection webXMLFilter() {
        FilterSet filterSet = new FilterSet();
        String string = "WEBINFROOT";
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.appPaths != null && this.appPaths.length() > 0) {
            this.appPaths = this.appPaths.trim();
            for (String string2 : this.appPaths.split("\n")) {
                linkedList.add(string + this.stripPath(string2));
            }
        }
        if (this.frameworkPaths != null && this.frameworkPaths.length() > 0) {
            this.frameworkPaths = this.frameworkPaths.trim();
            for (String string2 : this.frameworkPaths.split("\n")) {
                linkedList.add(string + "/" + this.getApplicatonTask().getName() + ".woa/Contents" + this.stripPath(string2));
            }
        }
        if (this.otherClasspaths != null && this.otherClasspaths.length() > 0) {
            this.otherClasspaths = this.otherClasspaths.trim();
            for (String string2 : this.otherClasspaths.split("\n")) {
                linkedList.add(string + this.stripPath(string2));
            }
        }
        String[] stringArray = new StringBuffer();
        for (String string3 : linkedList) {
            stringArray.append(string3);
            stringArray.append("\n");
        }
        WOApplication wOApplication = (WOApplication)this.task;
        this.log(" AppFormat.webXMLFilter().woappTask: " + wOApplication, 3);
        filterSet.addFilter("WOROOT", wOApplication.getWebXML_WOROOT());
        filterSet.addFilter("LOCALROOT", wOApplication.getWebXML_LOCALROOT());
        filterSet.addFilter("WOAINSTALLROOT", wOApplication.getWebXML_WOAINSTALLROOT());
        filterSet.addFilter("WOAppMode", wOApplication.getWebXML_WOAppMode());
        filterSet.addFilter("WOClasspath", stringArray.toString());
        filterSet.addFilter("WOApplicationClass", this.getAppClass());
        filterSet.addFilter("WOServletAdaptor", this.getServletAdaptor());
        filterSet.addFilter("WOTagLib", wOApplication.getWebXML_WOtaglib());
        String string4 = wOApplication.getWebXML_CustomContent();
        if (string4 == null) {
            string4 = "";
        }
        filterSet.addFilter("CustomContent", string4);
        return new FilterSetCollection(filterSet);
    }
}

