/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileUtil {
    FileUtil() {
    }

    static void ensureParentDirExists(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory() && !file2.mkdirs()) {
            throw new BuildException("Failed to create directory " + file2.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(String string, File file) throws BuildException {
        int n = 8192;
        FileUtil.ensureParentDirExists(file);
        InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new BuildException("Resource not found: " + string);
        }
        try {
            inputStream = new BufferedInputStream(inputStream, n);
            byte[] byArray = new byte[n];
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), n);
            try {
                int n2;
                while ((n2 = inputStream.read(byArray, 0, n)) >= 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            finally {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error copying resource " + string, (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<Node> getClasspathEntriesOfKind(File file, String string) throws SAXException, IOException, ParserConfigurationException {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        File file2 = new File(file, ".classpath");
        if (!file2.exists()) {
            throw new BuildException("You specified eclipse = 'true', but " + file2 + " does not exist.");
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file2);
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("classpathentry");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("kind");
            String string2 = node2.getTextContent();
            if (!string.equals(string2)) continue;
            linkedList.add(node);
        }
        return linkedList;
    }
}

