/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.woproject.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.objectstyle.woproject.ant.SubtaskFactory;
import org.objectstyle.woproject.ant.WOFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WOTask
extends Task {
    protected Vector<WOFileSet> classes = new Vector();
    protected String name;
    protected String destDir;
    protected String wsDestDir;
    protected String principalClass;
    protected String servletAdaptor = "com.webobjects.jspservlet.WOServletAdaptor";
    protected String manifest;
    protected String jarName;
    protected String customInfoPListContent;
    protected Vector<WOFileSet> sources = new Vector();
    protected Vector<WOFileSet> resources = new Vector();
    protected Vector<WOFileSet> wsresources = new Vector();
    protected Vector<FileSet> flattenfiles = new Vector();
    protected Vector<FileSet> lib = new Vector();
    protected boolean hasComponents = true;
    protected String version;
    protected String cfbundleversion;
    protected String cfbundleshortversion;
    protected String cfbundleID;
    protected String javaVersion;
    private SubtaskFactory subtaskFactory;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getCFBundleVersion() {
        return this.cfbundleversion == null || this.cfbundleversion.equals("${cfBundleVersion}") ? "" : this.cfbundleversion;
    }

    public void setCFBundleVersion(String string) {
        this.cfbundleversion = string;
    }

    public String getCFBundleShortVersion() {
        return this.cfbundleshortversion == null || this.cfbundleshortversion.equals("${cfBundleShortVersion}") ? "" : this.cfbundleshortversion;
    }

    public void setCFBundleShortVersion(String string) {
        this.cfbundleshortversion = string;
    }

    public String getCFBundleID() {
        return this.cfbundleID == null || this.cfbundleID.equals("${cfBundleID}") ? "com.apple.myapp" : this.cfbundleID;
    }

    public void setCFBundleID(String string) {
        this.cfbundleID = string;
    }

    public String getJavaVersion() {
        return this.javaVersion == null || this.javaVersion.equals("${javaVersion}") ? "1.5+" : this.javaVersion;
    }

    public void setJavaVersion(String string) {
        this.javaVersion = string;
    }

    public void setJarName(String string) {
        this.jarName = string;
    }

    public String getJarName() {
        if (this.jarName == null) {
            this.jarName = this.getName().toLowerCase();
        }
        return this.jarName;
    }

    public void setPrincipalClass(String string) {
        if (string.equals("${principalClass}")) {
            string = "Application";
        }
        this.principalClass = string;
    }

    public void setManifest(String string) {
        this.manifest = string;
    }

    public void setWsDestDir(String string) {
        this.wsDestDir = string;
    }

    public String getPrincipalClass() {
        return this.principalClass;
    }

    public void setServletAdaptor(String string) {
        this.servletAdaptor = string;
    }

    public String getServletAdaptor() {
        return this.servletAdaptor;
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getCustomInfoPListContent() {
        return this.customInfoPListContent;
    }

    public void setCustomInfoPListContent(String string) {
        this.customInfoPListContent = string;
    }

    public void setDestDir(String string) {
        this.destDir = string;
    }

    public void addClasses(WOFileSet wOFileSet) {
        this.classes.addElement(wOFileSet);
    }

    public void addSources(WOFileSet wOFileSet) {
        this.sources.addElement(wOFileSet);
    }

    public void addResources(WOFileSet wOFileSet) {
        this.resources.addElement(wOFileSet);
    }

    public void addLib(FileSet fileSet) {
        this.lib.addElement(fileSet);
    }

    public void addWsresources(WOFileSet wOFileSet) {
        this.wsresources.addElement(wOFileSet);
    }

    public void addFlattenfiles(FileSet fileSet) {
        this.flattenfiles.addElement(fileSet);
    }

    protected File webServerDir() {
        return this.getProject().resolveFile(this.wsDestDir);
    }

    protected abstract File taskDir();

    protected abstract File resourcesDir();

    protected abstract File wsresourcesDir();

    protected abstract File wsresourcesDestDir();

    protected void validateAttributes() throws BuildException {
        if (this.name == null) {
            throw new BuildException("'name' attribute is missing.");
        }
        if (this.destDir == null) {
            throw new BuildException("'destDir' attribute is missing.");
        }
    }

    protected void createDirectories() throws BuildException {
        Mkdir mkdir = this.getSubtaskFactory().getMkdir();
        File file = this.taskDir();
        mkdir.setDir(file);
        mkdir.execute();
        File file2 = this.resourcesDir();
        mkdir.setDir(file2);
        mkdir.execute();
        mkdir.setDir(new File(file2, "Java"));
        mkdir.execute();
        if (this.hasWs()) {
            mkdir.setDir(this.wsresourcesDir());
            mkdir.execute();
        }
    }

    public boolean hasWs() {
        return this.wsresources.size() > 0;
    }

    public boolean hasFlattenfiles() {
        return this.flattenfiles.size() > 0;
    }

    public boolean doingSplitInstall() {
        return this.wsDestDir != null && this.hasWs();
    }

    public boolean hasResources() {
        return this.resources.size() > 0;
    }

    public boolean hasSources() {
        return this.sources.size() > 0;
    }

    public boolean hasClasses() {
        return this.classes.size() > 0;
    }

    public boolean hasManifest() {
        return this.manifest != null;
    }

    public File getManifestFile() {
        return new File(this.manifest);
    }

    protected void jarSources() throws BuildException {
        Jar jar = this.getSubtaskFactory().getJar();
        File file = new File(this.resourcesDir(), "Java" + File.separator + "src.jar");
        jar.setDestFile(file);
        boolean bl = false;
        if (this.hasSources()) {
            Enumeration<WOFileSet> enumeration = this.sources.elements();
            while (enumeration.hasMoreElements()) {
                WOFileSet wOFileSet = enumeration.nextElement();
                if (!wOFileSet.testIfCondition()) continue;
                jar.addFileset((FileSet)wOFileSet);
                bl = true;
            }
        }
        if (bl) {
            jar.execute();
        }
    }

    protected void jarClasses() throws BuildException {
        Jar jar = this.getSubtaskFactory().getJar();
        File file = new File(this.resourcesDir(), "Java" + File.separator + this.getJarName() + ".jar");
        jar.setDestFile(file);
        if (this.hasClasses()) {
            Enumeration<WOFileSet> enumeration = this.classes.elements();
            while (enumeration.hasMoreElements()) {
                WOFileSet wOFileSet = enumeration.nextElement();
                if (!wOFileSet.testIfCondition()) continue;
                jar.addFileset((FileSet)wOFileSet);
            }
        }
        if (this.hasManifest()) {
            jar.setManifest(this.getManifestFile());
        }
        jar.execute();
    }

    protected void copyResources() throws BuildException {
        Copy copy = this.getSubtaskFactory().getResourceCopy();
        copy.setTodir(this.resourcesDir());
        int n = 0;
        Enumeration<WOFileSet> enumeration = this.resources.elements();
        while (enumeration.hasMoreElements()) {
            WOFileSet wOFileSet = enumeration.nextElement();
            if (!wOFileSet.testIfCondition()) continue;
            copy.addFileset((FileSet)wOFileSet);
            ++n;
        }
        if (n > 0) {
            copy.execute();
        }
    }

    protected void copyWsresources() throws BuildException {
        Copy copy = this.getSubtaskFactory().getResourceCopy();
        copy.setTodir(this.wsresourcesDir());
        int n = 0;
        Enumeration<WOFileSet> enumeration = this.wsresources.elements();
        while (enumeration.hasMoreElements()) {
            WOFileSet wOFileSet = enumeration.nextElement();
            if (!wOFileSet.testIfCondition()) continue;
            copy.addFileset((FileSet)wOFileSet);
            ++n;
        }
        if (n > 0) {
            copy.execute();
            if (this.doingSplitInstall()) {
                this.log("Split install WebServerResources of " + this.name + " in " + this.wsDestDir);
                copy.setTodir(this.wsresourcesDestDir());
                copy.execute();
            }
        }
    }

    protected void copyLibs() throws BuildException {
        Copy copy = this.getSubtaskFactory().getResourceCopy();
        copy.setTodir(new File(this.resourcesDir(), "Java"));
        copy.setFlatten(true);
        Enumeration<FileSet> enumeration = this.lib.elements();
        while (enumeration.hasMoreElements()) {
            copy.addFileset(enumeration.nextElement());
        }
        copy.execute();
    }

    protected boolean hasLib() {
        return this.lib.size() > 0;
    }

    protected boolean hasJava() {
        return this.classes.size() > 0 || this.lib.size() > 0;
    }

    public Iterator<String> getLibNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<FileSet> enumeration = this.lib.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fileSet = enumeration.nextElement();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                arrayList.add(file.getPath());
            }
        }
        return arrayList.iterator();
    }

    public SubtaskFactory getSubtaskFactory() {
        if (this.subtaskFactory == null) {
            this.subtaskFactory = new SubtaskFactory(this);
        }
        return this.subtaskFactory;
    }

    public void release() {
        this.subtaskFactory.release();
        this.subtaskFactory = null;
    }

    public Iterator<String> getFlattenfileNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<FileSet> enumeration = this.flattenfiles.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fileSet = enumeration.nextElement();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList.iterator();
    }

    public boolean getHasComponents() {
        return this.hasComponents;
    }

    public void setHasComponents(boolean bl) {
        this.hasComponents = bl;
    }
}

