/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSchemaSynchronization;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _MySQLPlugIn
extends JDBCPlugIn {
    private static final String DriverClassName = "com.mysql.jdbc.Driver";
    private static final String DriverProductName = "MySQL";
    private static final String QUERY_STRING_USE_BUNDLED_JDBC_INFO = "useBundledJdbcInfo";

    public _MySQLPlugIn(JDBCAdaptor adaptor) {
        super(adaptor);
    }

    public String name() {
        return DriverProductName;
    }

    public String defaultDriverName() {
        return DriverClassName;
    }

    public String databaseProductName() {
        return DriverProductName;
    }

    public Class<MySQLExpression> defaultExpressionClass() {
        return MySQLExpression.class;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new MySQLSynchronizationFactory((EOAdaptor)this._adaptor);
    }

    public NSDictionary jdbcInfo() {
        NSDictionary jdbcInfo;
        if (this.shouldUseBundledJdbcInfo()) {
            InputStream jdbcInfoStream;
            if (NSLog.debugLoggingAllowedForLevel((int)3)) {
                NSLog.debug.appendln((Object)"Loading jdbcInfo from JDBCInfo.plist as opposed to using the JDBCPlugIn default implementation.");
            }
            if ((jdbcInfoStream = NSBundle.bundleForClass(((Object)((Object)this)).getClass()).inputStreamForResourcePath("JDBCInfo.plist")) == null) {
                throw new IllegalStateException("Unable to find 'JDBCInfo.plist' in this plugin jar.");
            }
            try {
                jdbcInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromData((NSData)new NSData(jdbcInfoStream, 2048), (String)"US-ASCII");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load 'JDBCInfo.plist' from this plugin jar.", e);
            }
        } else {
            Object rawCreateParams;
            NSMutableDictionary mutableInfo = super.jdbcInfo().mutableClone();
            NSMutableDictionary typeInfo = ((NSDictionary)mutableInfo.objectForKey((Object)"typeInfo")).mutableClone();
            NSDictionary textTypeInfo = (NSDictionary)typeInfo.objectForKey((Object)"TEXT");
            if (textTypeInfo != null && !(rawCreateParams = textTypeInfo.objectForKey((Object)"createParams")).equals("1")) {
                NSMutableDictionary newRawTypeInfo = textTypeInfo.mutableClone();
                newRawTypeInfo.setObjectForKey((Object)"1", (Object)"createParams");
                typeInfo.setObjectForKey((Object)newRawTypeInfo, (Object)"RAW");
            }
            JDBCPlugIn._takeValueForKeyPath((NSMutableDictionary)typeInfo, (Object)"0", (String)"BLOB", (String)"createParams");
            JDBCPlugIn._takeValueForKeyPath((NSMutableDictionary)typeInfo, (Object)"0", (String)"LONGBLOB", (String)"createParams");
            JDBCPlugIn._takeValueForKeyPath((NSMutableDictionary)typeInfo, (Object)"0", (String)"MEDIUMBLOB", (String)"createParams");
            JDBCPlugIn._takeValueForKeyPath((NSMutableDictionary)typeInfo, (Object)"0", (String)"TINYBLOB", (String)"createParams");
            mutableInfo.setObjectForKey((Object)typeInfo, (Object)"typeInfo");
            NSLog.debug.appendln((Object)("fetched MySQL (" + this.databaseProductName() + ") JDBC Info = " + mutableInfo));
            jdbcInfo = mutableInfo.immutableClone();
        }
        return jdbcInfo;
    }

    public Object fetchBLOB(ResultSet rs, int column, EOAttribute attribute, boolean materialize) throws SQLException {
        NSData data = null;
        Blob blob = rs.getBlob(column);
        if (blob == null) {
            return null;
        }
        if (!materialize) {
            return blob;
        }
        try {
            InputStream stream = blob.getBinaryStream();
            int chunkSize = (int)blob.length();
            data = chunkSize == 0 ? NSData.EmptyData : new NSData(stream, chunkSize);
            stream.close();
        }
        catch (IOException e) {
            throw new JDBCAdaptorException(e.getMessage(), null);
        }
        return data;
    }

    protected boolean shouldUseBundledJdbcInfo() {
        boolean shouldUseBundledJdbcInfo = false;
        String url = this.connectionURL();
        if (url != null) {
            shouldUseBundledJdbcInfo = url.toLowerCase().matches(".*(\\?|\\?.*&)" + QUERY_STRING_USE_BUNDLED_JDBC_INFO.toLowerCase() + "=(true|yes)(\\&|$)");
        }
        return shouldUseBundledJdbcInfo;
    }

    private void writeJDBCInfo(NSDictionary jdbcInfo) {
        try {
            String jdbcInfoS = NSPropertyListSerialization.stringFromPropertyList((Object)jdbcInfo);
            FileOutputStream fos = new FileOutputStream("/tmp/JDBCInfo.plist");
            fos.write(jdbcInfoS.getBytes());
            fos.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("problem writing JDBCInfo.plist", e);
        }
    }

    public static class MySQLSynchronizationFactory
    extends EOSynchronizationFactory {
        public MySQLSynchronizationFactory(EOAdaptor adaptor) {
            super(adaptor);
        }

        public String _alterPhraseInsertionClausePrefixAtIndex(int columnIndex) {
            return columnIndex != 0 ? "" : " ADD ";
        }

        protected String formatTableName(String name) {
            return name;
        }

        protected String formatColumnName(String name) {
            return name;
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            String pkTable = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            NSMutableArray statements = new NSMutableArray();
            statements.addObject((Object)this._expressionForString("CREATE TABLE " + pkTable + " (NAME CHAR(40) PRIMARY KEY, PK INT)"));
            return statements;
        }

        public EOAttribute attributeInEntityWithColumnName(EOEntity entity, String columnName) {
            Enumeration e = entity.attributes().objectEnumerator();
            while (e.hasMoreElements()) {
                EOAttribute attribute = (EOAttribute)e.nextElement();
                if (!attribute.columnName().equals(columnName)) continue;
                return attribute;
            }
            return null;
        }

        public NSArray statementsToModifyColumnNullRule(String columnName, String tableName, boolean allowsNull, NSDictionary options) {
            String nullStatement = allowsNull ? " NULL" : " NOT NULL";
            EOAttribute attribute = this.attributeInEntityWithColumnName(this.entityForTableName(tableName), columnName);
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " MODIFY " + this.formatColumnName(columnName) + " " + attribute.externalType() + nullStatement));
        }

        public boolean supportsDirectColumnNullRuleModification() {
            return true;
        }

        public NSArray statementsToRenameColumnNamed(String columnName, String tableName, String newName, NSDictionary options) {
            EOAttribute attribute = this.attributeInEntityWithColumnName(this.entityForTableName(tableName), newName);
            String nullStatement = attribute.allowsNull() ? " NULL" : " NOT NULL";
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + this.formatTableName(tableName) + " CHANGE " + this.formatColumnName(columnName) + " " + this.formatColumnName(newName) + " " + attribute.externalType() + nullStatement));
        }

        private String statementToCreateDataTypeClause(EOSchemaSynchronization.ColumnTypes columntypes) {
            int size = columntypes.precision();
            if (size == 0) {
                size = columntypes.width();
            }
            if (size == 0) {
                return columntypes.name();
            }
            int scale = columntypes.scale();
            if (scale == 0) {
                return columntypes.name() + "(" + size + ")";
            }
            return columntypes.name() + "(" + size + "," + scale + ")";
        }

        public NSArray statementsToConvertColumnType(String columnName, String tableName, EOSchemaSynchronization.ColumnTypes oldType, EOSchemaSynchronization.ColumnTypes newType, NSDictionary options) {
            String columnTypeString = this.statementToCreateDataTypeClause(newType);
            StringBuffer sb = new StringBuffer();
            sb.append("ALTER TABLE ").append(this.formatTableName(tableName));
            sb.append(" MODIFY ").append(this.formatColumnName(columnName));
            sb.append(' ').append(columnTypeString);
            NSArray statements = new NSArray((Object)this._expressionForString(sb.toString()));
            return statements;
        }

        public boolean supportsDirectColumnRenaming() {
            return true;
        }

        private EOEntity entityForTableName(String tableName) {
            EOModelGroup modelGroup = EOModelGroup.globalModelGroup();
            Enumeration modelEnumeration = modelGroup.models().objectEnumerator();
            while (modelEnumeration.hasMoreElements()) {
                EOModel model = (EOModel)modelEnumeration.nextElement();
                Enumeration entityEnumeration = model.entities().objectEnumerator();
                while (entityEnumeration.hasMoreElements()) {
                    EOEntity entity = (EOEntity)entityEnumeration.nextElement();
                    if (!entity.externalName().equalsIgnoreCase(tableName)) continue;
                    return entity;
                }
            }
            return null;
        }

        public NSArray statementsToDeleteColumnNamed(String columnName, String tableName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + tableName + " DROP COLUMN " + columnName));
        }

        public NSArray statementsToInsertColumnForAttribute(EOAttribute attribute, NSDictionary options) {
            String columnCreationClause = this._columnCreationClauseForAttribute(attribute);
            return new NSArray((Object)this._expressionForString("ALTER TABLE " + attribute.entity().externalName() + this._alterPhraseInsertionClausePrefixAtIndex(0) + columnCreationClause));
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray entityGroups) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName() + " CASCADE"));
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String tableName) {
            return new NSArray((Object)this._expressionForString("alter table " + tableName + " drop primary key"));
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship relationship) {
            return null;
        }

        public NSArray statementsToRenameTableNamed(String tableName, String newName, NSDictionary options) {
            return new NSArray((Object)this._expressionForString("rename table " + tableName + " to " + newName));
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }
    }

    public static class MySQLExpression
    extends JDBCExpression {
        public MySQLExpression(EOEntity entity) {
            super(entity);
        }

        public char sqlEscapeChar() {
            return '|';
        }
    }
}

