/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.validity;

import com.gammastream.validity.GSVEntity;
import com.webobjects.appserver.xml.WOXMLCoder;
import com.webobjects.appserver.xml.WOXMLCoding;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;

public final class GSVModel
implements WOXMLCoding {
    public static final String MODEL_NAME = "Validity";
    public static final String MODEL_EXTENSION = "model";
    private NSMutableArray _entities = null;
    private String _eomodelPath = null;
    private String _eomodelName = null;
    private boolean inited = false;
    private EOModelGroup _eomodelGroup = null;

    public GSVModel(String path) throws IllegalArgumentException {
        if (!this.validateEOModelForPath(path)) {
            throw new IllegalArgumentException("Could not find a valid EOModel at: " + path);
        }
        this._entities = new NSMutableArray();
        this._eomodelPath = path;
        this._eomodelName = NSPathUtilities.stringByDeletingPathExtension((String)NSPathUtilities.lastPathComponent((String)this._eomodelPath));
        this._eomodelGroup = new EOModelGroup();
        this._eomodelGroup.addModelWithPath(this._eomodelPath);
    }

    public boolean validateEOModelForPath(String path) {
        try {
            File f = new File(path);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveModel() {
        String codedString = WOXMLCoder.coder().encodeRootObjectForKey((Object)this, "Model");
        String fullFileName = NSPathUtilities.stringByAppendingPathExtension((String)MODEL_NAME, (String)MODEL_EXTENSION);
        String xmlPath = NSPathUtilities.stringByAppendingPathComponent((String)this._eomodelPath, (String)fullFileName);
        try {
            File configurationFile = new File(xmlPath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(configurationFile), "UTF-8");
            osw.write(codedString);
            osw.close();
            NSLog.out.appendln((Object)"did save model to file");
            return true;
        }
        catch (IOException e) {
            NSLog.out.appendln((Throwable)e);
            return false;
        }
    }

    public EOModelGroup eomodelGroup() {
        return this._eomodelGroup;
    }

    public String eomodelName() {
        return this._eomodelName;
    }

    public String eomodelPath() {
        return this._eomodelPath;
    }

    public void setEomodelPath(String path) {
        this._eomodelPath = path;
    }

    public NSArray entities() {
        return this._entities;
    }

    public void addEntity(GSVEntity newEntity) throws IllegalArgumentException {
        GSVEntity currentEntity = null;
        for (int i = 0; i < this._entities.count(); ++i) {
            currentEntity = (GSVEntity)this._entities.objectAtIndex(i);
            if (!currentEntity.name().equals(newEntity.name())) continue;
            throw new IllegalArgumentException("Entity for name '" + newEntity.name() + "' already exsits in model named " + this.eomodelName());
        }
        this._entities.addObject((Object)newEntity);
    }

    public void removeEntity(GSVEntity oldEntity) {
        this._entities.removeObject((Object)oldEntity);
    }

    public GSVEntity entityForObject(Object object) {
        if (object instanceof EOEnterpriseObject) {
            GSVEntity currentEntity = null;
            for (int i = 0; i < this._entities.count(); ++i) {
                currentEntity = (GSVEntity)this._entities.objectAtIndex(i);
                if (!currentEntity.name().equals(((EOEnterpriseObject)object).entityName())) continue;
                return currentEntity;
            }
        }
        return null;
    }

    public GSVEntity entityNamed(String name) {
        GSVEntity currentEntity = null;
        for (int i = 0; i < this._entities.count(); ++i) {
            currentEntity = (GSVEntity)this._entities.objectAtIndex(i);
            if (!currentEntity.name().equals(name)) continue;
            return currentEntity;
        }
        return null;
    }

    public NSArray entityNames() {
        NSMutableArray names = new NSMutableArray();
        GSVEntity currentEntity = null;
        for (int i = 0; i < this._entities.count(); ++i) {
            currentEntity = (GSVEntity)this._entities.objectAtIndex(i);
            names.addObject((Object)currentEntity.name());
        }
        return names;
    }

    public void savePath(String s) {
        this._eomodelPath = s;
        this._eomodelGroup.addModelWithPath(this._eomodelPath);
        this.saveModel();
    }

    public void encodeWithWOXMLCoder(WOXMLCoder coder) {
        coder.encodeObjectForKey((Object)this._entities.immutableClone(), "Entities");
        coder.encodeObjectForKey((Object)this._eomodelName, "EOModelName");
        coder.encodeObjectForKey((Object)this._eomodelPath, "EOModelPath");
    }

    public GSVModel(WOXMLDecoder decoder) {
        this._entities = new NSMutableArray((NSArray)decoder.decodeObjectForKey("Entities"));
        this._eomodelName = (String)decoder.decodeObjectForKey("EOModelName");
        if (this._eomodelName == null) {
            this._eomodelName = (String)decoder.decodeObjectForKey("Name");
        }
        this._eomodelGroup = new EOModelGroup();
        this._eomodelPath = (String)decoder.decodeObjectForKey("EOModelPath");
    }

    public Class classForCoder() {
        try {
            return Class.forName("com.gammastream.validity.GSVModel");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void init(EOModel eomodel) {
        if (!this.inited) {
            this.inited = true;
            Enumeration e = this.entities().immutableClone().objectEnumerator();
            while (e.hasMoreElements()) {
                GSVEntity entity = (GSVEntity)e.nextElement();
                String name = entity.name();
                EOEntity eoentity = eomodel.entityNamed(name);
                if (eoentity == null) {
                    this.removeEntity(entity);
                    continue;
                }
                entity.init(this, eoentity);
            }
        }
    }
}

