/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.util.Enumeration;

public class WOStatisticsStore
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    private static final int DefaultTransactionMovingAverageCount = 100;
    private static final int DefaultSessionMovingAverageCount = 10;
    private static final String _PagesTotalServed = "Served";
    private static final String _PagesAvgResponseTime = "Avg Resp. Time";
    private static final String _PagesMinResponseTime = "Min Resp. Time";
    private static final String _PagesMaxResponseTime = "Max Resp. Time";
    private static final String _MemoryCommittedNT = "Committed";
    private static final String _MemoryReservedNT = "Reserved";
    private static final String _MemoryUnknown = "Unknown";
    private static final String _MemoryProcessImageSizeSUN = "Process Image Size";
    private static final String _MemoryResident = "Resident Set Size";
    private static final String _MemoryVirtual = "Virtual";
    private static final String _Memory = "Memory";
    private static final String _StartingDate = "StartedAt";
    private static final String _PagesStatistics = "Pages";
    private static final String _WebServiceStatistics = "WebService";
    private static final String _DirectActionStatistics = "DirectActions";
    private static final String _DetailsStatistics = "Details";
    private static final String _LogInfo = "LogFile";
    private static final String _TransactionsCount = "Transactions";
    private static final String _WSTransactionsCount = "Web Service Transactions";
    private static final String _DATransactionsCount = "Direct Action Transactions";
    private static final String _CATransactionsCount = "Component Action Transactions";
    private static final String _WSTransactionTime = "Web Service Avg. Transaction Time";
    private static final String _DATransactionTime = "Direct Action Avg. Transaction Time";
    private static final String _CATransactionTime = "Component Action  Avg. Transaction Time";
    private static final String _IdleTime = "Avg. Idle Time";
    private static final String _MovingIdleTime = "Moving Avg. Idle Time";
    private static final String _TransactionTime = "Avg. Transaction Time";
    private static final String _MovingTransactionTime = "Moving Avg. Transaction Time";
    private static final String _SampleSize = "Sample Size For Moving Avg.";
    private static final String _TransactionsStatistics = "Transactions";
    private static final String _TransactionRate = "Transaction Rate";
    private static final String _SessionsCount = "Total Sessions Created";
    private static final String _CurrentSessionsCount = "Current Active Sessions";
    private static final String _MaxActiveSessions = "Peak Active Sessions";
    private static final String _MaxActiveSessionsDate = "Peak Active Sessions Date";
    private static final String _MovingTransactionsPerSession = "Moving Avg. Transactions Per Session";
    private static final String _MovingSessionLife = "Moving Avg. Session Life";
    private static final String _TransactionsPerSession = "Avg. Transactions Per Session";
    private static final String _SessionLife = "Avg. Session Life";
    private static final String _SessionMemory = "Avg. Memory Per Session";
    private static final String _LastSessionStatistics = "Last Session's Statistics";
    private static final String _SessionsStatistics = "Sessions";
    private static final String _SessionRate = "Session Rate";
    private static final NSTimestampFormatter TheDateFormat = new NSTimestampFormatter("%d/%b/%Y:%H:%M:%S ");
    private static final NSTimeZone TheDateFormatTZ;
    private static final NSTimestampFormatter TheFileDateFormat;
    private volatile int _transactionMovingAverageSampleCount = 100;
    private volatile int _sessionMovingAverageSampleCount = 10;
    private volatile int _transactionsCount;
    private volatile int _lastStatsTransactionsCount;
    private volatile int _webServiceTransactionsCount;
    private volatile int _directActionTransactionsCount;
    private volatile int _componentActionTransactionsCount;
    private volatile int _sessionsCount;
    private volatile int _lastStatsSessionsCount;
    private volatile int _maxActiveSessionsCount;
    private volatile NSTimestamp _maxActiveSessionsDate;
    private volatile int _averageSessionLife;
    private volatile NSArray _lastSessionStatistics;
    private volatile int _movingAverageSessionLife;
    private volatile double _movingAverageRequestsPerSession;
    private volatile int _movingAverageSessionsCount;
    private final NSTimestamp _startDate = new NSTimestamp();
    private final long _startDateMillis = this._startDate.getTime();
    private long _lastStatsDateMillis = System.currentTimeMillis();
    private long _lastWillHandleRequestTimeIntervalMillis;
    private long _lastDidHandleRequestTimeIntervalMillis;
    private long _totalIdleTimeIntervalMillis;
    private long _totalTransactionTimeIntervalMillis;
    private long _totalWSTransactionTimeIntervalMillis;
    private long _totalDATransactionTimeIntervalMillis;
    private long _totalCATransactionTimeIntervalMillis;
    private long _movingIdleTimeIntervalMillis;
    private long _movingTransactionTimeIntervalMillis;
    private volatile int _movingAverageTransactionsCount;
    private final NSDictionary _initializationMemory = this.memoryUsage();
    private final NSMutableDictionary _pagesStatistics = new NSMutableDictionary();
    private final NSMutableDictionary _pathsStatistics;
    private volatile String _logPath;
    private long _logRotation;
    private long _logCreationDate;
    private volatile String _password;
    private final NSMutableDictionary _webServiceStatistics = new NSMutableDictionary();
    private final NSMutableDictionary _directActionStatistics = new NSMutableDictionary();
    private int _statStoreSessionMax;
    private volatile String _currentPage;
    private static final double msecPerDay = 8.64E7;
    private static final double dayPerMsec = 1.1574074074074074E-8;

    protected WOStatisticsStore() {
        this._pathsStatistics = new NSMutableDictionary();
        if (WOProperties.TheStatisticsStorePassword == null) {
            WOProperties.TheStatisticsStorePassword = NSProperties.getProperty((String)WOProperties._StatisticsStorePasswordKey);
        }
        this._password = WOProperties.TheStatisticsStorePassword;
        if (WOProperties.TheStatisticsStoreSessionMax == -1) {
            WOProperties.TheStatisticsStoreSessionMax = Integer.valueOf(NSProperties.getProperty((String)WOProperties._StatisticsStoreSessionMaxKey));
        }
        this._statStoreSessionMax = WOProperties.TheStatisticsStoreSessionMax;
    }

    public int transactionMovingAverageSampleSize() {
        return this._transactionMovingAverageSampleCount;
    }

    public void setTransactionMovingAverageSampleSize(int n) {
        this._movingAverageTransactionsCount = 0;
        this._transactionMovingAverageSampleCount = n > 0 ? n : 0;
    }

    public int sessionMovingAverageSampleSize() {
        return this._sessionMovingAverageSampleCount;
    }

    public void setSessionMovingAverageSampleSize(int n) {
        this._movingAverageSessionsCount = 0;
        this._sessionMovingAverageSampleCount = n > 0 ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSDictionary statistics() {
        Number number = null;
        WOApplication wOApplication = WOApplication.application();
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary();
        NSMutableDictionary nSMutableDictionary3 = new NSMutableDictionary();
        double d = 0.0;
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            nSMutableDictionary.setObjectForKey((Object)this._startDate, (Object)_StartingDate);
            long l = System.currentTimeMillis();
            d = l - this._lastStatsDateMillis;
            this._lastStatsDateMillis = l;
            nSMutableDictionary.setObjectForKey((Object)this._pagesStatistics(), (Object)_PagesStatistics);
            nSMutableDictionary.setObjectForKey((Object)this._webServiceStatistics(), (Object)_WebServiceStatistics);
            nSMutableDictionary.setObjectForKey((Object)this._directActionStatistics(), (Object)_DirectActionStatistics);
            nSMutableDictionary.setObjectForKey((Object)this._pathsStatistics(), (Object)_DetailsStatistics);
            nSMutableDictionary.setObjectForKey((Object)this.memoryUsage(), (Object)_Memory);
            if (this._logPath != null) {
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(this._logPath);
                stringBuffer.append(" rotated every ");
                stringBuffer.append((double)this._logRotation * 1.1574074074074074E-8);
                stringBuffer.append(" days");
                nSMutableDictionary.setObjectForKey((Object)new String(stringBuffer), (Object)_LogInfo);
            }
            int n = this._transactionsCount;
            number = new Long(n);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)"Transactions");
            double d2 = d == 0.0 ? 0.0 : 1000.0 * (double)(n - this._lastStatsTransactionsCount) / d;
            number = new Double(d2);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_TransactionRate);
            this._lastStatsTransactionsCount = n;
            number = new Long(this._componentActionTransactionsCount);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_CATransactionsCount);
            number = new Long(this._webServiceTransactionsCount);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_WSTransactionsCount);
            number = new Long(this._directActionTransactionsCount);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_DATransactionsCount);
            number = new Double((double)this._averageIdleTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_IdleTime);
            number = new Double((double)this._movingAverageIdleTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_MovingIdleTime);
            number = new Double((double)this._averageTransactionTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_TransactionTime);
            number = new Double((double)this._averageWSTransactionTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_WSTransactionTime);
            number = new Double((double)this._averageDATransactionTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_DATransactionTime);
            number = new Double((double)this._averageCATransactionTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_CATransactionTime);
            number = new Double((double)this._movingAverageTransactionTime() / 1000.0);
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_MovingTransactionTime);
            number = new Long(this.transactionMovingAverageSampleSize());
            nSMutableDictionary2.setObjectForKey((Object)number, (Object)_SampleSize);
            nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary2, (Object)"Transactions");
            int n2 = this._sessionsCount;
            number = new Long(n2);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_SessionsCount);
            double d3 = d == 0.0 ? 0.0 : 1000000.0 * (double)(n2 - this._lastStatsSessionsCount) / d;
            number = new Double((double)((long)d3) / 1000.0);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_SessionRate);
            this._lastStatsSessionsCount = n2;
            number = new Long(wOApplication.activeSessionsCount());
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_CurrentSessionsCount);
            number = new Long(this._maxActiveSessionsCount);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_MaxActiveSessions);
            if (this._maxActiveSessionsDate != null) {
                nSMutableDictionary3.setObjectForKey((Object)this._maxActiveSessionsDate, (Object)_MaxActiveSessionsDate);
            }
            number = new Double((double)((long)(this._averageRequestsPerSession() * 1000.0)) / 1000.0);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_TransactionsPerSession);
            number = new Double((double)this._averageSessionLife / 1000.0);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_SessionLife);
            number = new Long(this.sessionMovingAverageSampleSize());
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_SampleSize);
            number = new Double((double)((long)(this._movingAverageRequestsPerSession() * 1000.0)) / 1000.0);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_MovingTransactionsPerSession);
            number = new Double((double)this._movingAverageSessionLife() / 1000.0);
            nSMutableDictionary3.setObjectForKey((Object)number, (Object)_MovingSessionLife);
            nSMutableDictionary3.setObjectForKey((Object)this._averageSessionMemory(), (Object)_SessionMemory);
            if (this._lastSessionStatistics != null) {
                nSMutableDictionary3.setObjectForKey((Object)this._lastSessionStatistics(), (Object)_LastSessionStatistics);
            }
            nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary3, (Object)_SessionsStatistics);
        }
        return nSMutableDictionary;
    }

    private void _applicationWillHandleRequest() {
        ++this._transactionsCount;
        long l = System.currentTimeMillis();
        this._lastWillHandleRequestTimeIntervalMillis = l - this._startDateMillis;
        long l2 = this._lastWillHandleRequestTimeIntervalMillis - this._lastDidHandleRequestTimeIntervalMillis;
        this._totalIdleTimeIntervalMillis += l2;
        int n = this._transactionMovingAverageSampleCount;
        if (n != 0) {
            ++this._movingAverageTransactionsCount;
            this._movingIdleTimeIntervalMillis += l2;
            if (this._movingAverageTransactionsCount > n) {
                this._movingIdleTimeIntervalMillis -= this._movingIdleTimeIntervalMillis / (long)n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationWillHandleComponentActionRequest() {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            ++this._componentActionTransactionsCount;
            this._applicationWillHandleRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationWillHandleWebServiceRequest() {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            ++this._webServiceTransactionsCount;
            this._applicationWillHandleRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationWillHandleDirectActionRequest() {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            ++this._directActionTransactionsCount;
            this._applicationWillHandleRequest();
        }
    }

    private long _applicationDidHandleRequest() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        this._lastDidHandleRequestTimeIntervalMillis = l2 - this._startDateMillis;
        l = this._lastDidHandleRequestTimeIntervalMillis - this._lastWillHandleRequestTimeIntervalMillis;
        this._totalTransactionTimeIntervalMillis += l;
        int n = this._transactionMovingAverageSampleCount;
        if (n != 0) {
            this._movingTransactionTimeIntervalMillis += l;
            if (this._movingAverageTransactionsCount > n) {
                this._movingTransactionTimeIntervalMillis -= this._movingTransactionTimeIntervalMillis / (long)n;
            }
        }
        return l;
    }

    private void _applicationDidHandleWebServiceRequestWithActionNamed(String string) {
        long l = this._applicationDidHandleRequest();
        this._totalWSTransactionTimeIntervalMillis += l;
        this._updateHandlerStatistics(this._webServiceStatistics, string, l);
    }

    private void _applicationDidHandleDirectActionRequestWithActionNamed(String string) {
        long l = this._applicationDidHandleRequest();
        this._totalDATransactionTimeIntervalMillis += l;
        this._updateHandlerStatistics(this._directActionStatistics, string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDidHandleWebServiceRequestWithActionNamed(String string) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this._applicationDidHandleWebServiceRequestWithActionNamed(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDidHandleDirectActionRequestWithActionNamed(String string) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this._applicationDidHandleDirectActionRequestWithActionNamed(string);
        }
    }

    private void _applicationDidHandleComponentActionRequest() {
        long l = this._applicationDidHandleRequest();
        this._totalCATransactionTimeIntervalMillis += l;
        this._updateHandlerStatistics(this._pagesStatistics, this._currentPage, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDidHandleComponentActionRequestWithPageNamed(String string) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this._applicationDidHandleComponentActionRequest();
        }
    }

    private void applicationCreatedSession(WOSession wOSession) {
        int n = WOApplication.application().activeSessionsCount();
        ++this._sessionsCount;
        if (this._maxActiveSessionsCount < n) {
            this._maxActiveSessionsDate = new NSTimestamp();
            this._maxActiveSessionsCount = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _applicationCreatedSession(WOSession wOSession) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this.applicationCreatedSession(wOSession);
        }
    }

    private void sessionTerminating(WOSession wOSession) {
        long l = this._sessionsCount - WOApplication.application().activeSessionsCount();
        NSArray nSArray = wOSession.statistics();
        if (nSArray != null) {
            this._lastSessionStatistics = nSArray;
            this._updatePathsStatisticsWithPaths(this._lastSessionStatistics);
            if (this._logPath != null) {
                this.logString(wOSession._formattedStatistics());
            }
        }
        if (l > 0L) {
            long l2 = wOSession._lifeInMillis();
            int n = wOSession._requestCounter();
            this._averageSessionLife = (int)((long)this._averageSessionLife + (long)((double)(l2 - (long)this._averageSessionLife) / (1.0 * (double)l)));
            int n2 = this._sessionMovingAverageSampleCount;
            if (n2 != 0) {
                ++this._movingAverageSessionsCount;
                this._movingAverageSessionLife = (int)((long)this._movingAverageSessionLife + l2);
                this._movingAverageRequestsPerSession += (double)n;
                if (this._movingAverageSessionsCount > n2) {
                    this._movingAverageSessionLife -= this._movingAverageSessionLife / n2;
                    this._movingAverageRequestsPerSession -= this._movingAverageRequestsPerSession / (double)n2;
                }
            }
        } else {
            this._sessionsCount = 0;
            this._averageSessionLife = 0;
            this._movingAverageSessionLife = 0;
            this._movingAverageRequestsPerSession = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sessionTerminating(WOSession wOSession) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this.sessionTerminating(wOSession);
        }
    }

    private void _updateHandlerStatistics(NSMutableDictionary nSMutableDictionary, String string, long l) {
        if (string == null) {
            return;
        }
        long[] lArray = (long[])nSMutableDictionary.objectForKey((Object)string);
        if (lArray == null) {
            lArray = new long[]{1L, l, l, l};
            nSMutableDictionary.setObjectForKey((Object)lArray, (Object)string);
        } else {
            lArray[0] = lArray[0] + 1L;
            lArray[1] = lArray[1] + l;
            if (lArray[2] > l) {
                lArray[2] = l;
            }
            if (lArray[3] < l) {
                lArray[3] = l;
            }
        }
    }

    private void _updatePathsStatisticsWithPaths(NSArray nSArray) {
        this._purgePathsStatistics();
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Number number = (Number)this._pathsStatistics.objectForKey((Object)string);
            if (number != null) {
                long l = number.longValue() + 1L;
                Long l2 = new Long(l);
                this._pathsStatistics.setObjectForKey((Object)l2, (Object)string);
                continue;
            }
            this._pathsStatistics.setObjectForKey((Object)new Long(1L), (Object)string);
        }
    }

    private void _purgePathsStatistics() {
        int n = 2;
        while (this._pathsStatistics.count() > 100) {
            String string;
            Enumeration enumeration = this._pathsStatistics.keyEnumerator();
            Enumeration enumeration2 = null;
            NSMutableArray nSMutableArray = new NSMutableArray(this._pathsStatistics.count());
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if ((Long)this._pathsStatistics.objectForKey((Object)string) >= (long)n) continue;
                nSMutableArray.addObject((Object)string);
            }
            enumeration2 = nSMutableArray.objectEnumerator();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                this._pathsStatistics.removeObjectForKey((Object)string);
            }
            ++n;
        }
    }

    public void recordStatisticsForResponse(WOResponse wOResponse, WOContext wOContext) {
        WOComponent wOComponent = wOContext.page();
        if (wOComponent != null) {
            this._currentPage = wOComponent.name();
        }
    }

    public String descriptionForResponse(WOResponse wOResponse, WOContext wOContext) {
        WOComponent wOComponent = wOContext.page();
        if (null == this._currentPage) {
            this._currentPage = "WORedirect";
        }
        String string = wOComponent != null ? wOComponent.descriptionForResponse(wOResponse, wOContext) : null;
        return string;
    }

    public String formatDescription(String string, WOResponse wOResponse, WOContext wOContext) {
        String string2;
        String string3;
        String string4 = null;
        if (string == null) {
            return null;
        }
        WORequest wORequest = wOContext.request();
        String string5 = string.replace(' ', '_');
        String string6 = string3 = wORequest != null ? wORequest.headerForKey("remote_host") : "?";
        if (null == string3 || string3.length() == 0) {
            String string7 = string3 = wORequest != null ? wORequest.headerForKey("remote_addr") : "?";
        }
        if (null == string3 || string3.length() == 0) {
            String string8 = string3 = wORequest != null ? wORequest.headerForKey("x-webobjects-remote-host") : "?";
            if (null == string3 || string3.length() == 0) {
                String string9 = string3 = wORequest != null ? wORequest.headerForKey("x-webobjects-remote-addr") : "?";
            }
        }
        if (null == string3 || string3.length() == 0) {
            string3 = "-";
        }
        String string10 = string2 = wORequest != null ? wORequest.headerForKey("remote_user") : "?";
        if (null == string2 || string2.length() == 0) {
            String string11 = string2 = wORequest != null ? wORequest.headerForKey("x-webobjects-remote-user") : "?";
            if (null == string2 || string2.length() == 0) {
                string2 = "-";
            }
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string3);
        stringBuffer.append(" - ");
        stringBuffer.append(string2);
        stringBuffer.append(" [");
        NSTimestamp nSTimestamp = new NSTimestamp();
        stringBuffer.append(TheDateFormat.format((Object)nSTimestamp));
        stringBuffer.append(" ");
        int n = TheDateFormatTZ.secondsFromGMTForTimestamp(nSTimestamp);
        String string12 = "+";
        if (n < 0) {
            string12 = "-";
            n *= -1;
        }
        int n2 = (n /= 60) % 60;
        int n3 = n /= 60;
        n2 /= 60;
        stringBuffer.append(string12);
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append("] \"");
        stringBuffer.append(wORequest != null ? wORequest.method() : "?");
        stringBuffer.append(" /");
        stringBuffer.append(WOApplication.application().name());
        stringBuffer.append('/');
        stringBuffer.append(string5);
        stringBuffer.append(' ');
        stringBuffer.append(wORequest != null ? wORequest.httpVersion() : "?");
        stringBuffer.append("\" ");
        stringBuffer.append(wOResponse.status());
        stringBuffer.append(' ');
        stringBuffer.append(String.valueOf(wOResponse._contentLength()));
        stringBuffer.append('\n');
        string4 = new String(stringBuffer);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogFile(String string, long l) {
        WOStatisticsStore wOStatisticsStore = this;
        synchronized (wOStatisticsStore) {
            this._logPath = string;
            if (l >= 0L) {
                this._logRotation = l;
            }
        }
    }

    public void setLogFile(String string, double d) {
        this.setLogFile(string, (long)(d * 8.64E7));
    }

    public String logFile() {
        return this._logPath;
    }

    public long logFileRotationFrequency() {
        return this._logRotation;
    }

    public double logFileRotationFrequencyInDays() {
        return (double)this._logRotation * 1.1574074074074074E-8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logString(String string) {
        block15: {
            if (this._logPath != null) {
                try {
                    Object object;
                    File file = new File(this._logPath);
                    if (0L == this._logCreationDate) {
                        object = this;
                        synchronized (object) {
                            this._logCreationDate = System.currentTimeMillis();
                        }
                    }
                    object = new NSTimestamp();
                    long l = object.getTime();
                    if (this._logRotation > 0L && l - this._logCreationDate > this._logRotation) {
                        WOStatisticsStore wOStatisticsStore = this;
                        synchronized (wOStatisticsStore) {
                            this._logCreationDate = l;
                            String string2 = this._logPath + "." + TheFileDateFormat.format(object);
                            File file2 = new File(string2);
                            if (!file.renameTo(file2)) {
                                NSLog.err.appendln((Object)("Could not rotate the '" + this._logPath + "' log file into a '" + string2 + "' back-up file."));
                            }
                        }
                    }
                    if ((object = string) == null || ((String)object).equals("")) {
                        object = "<NULL>";
                    }
                    if (file.exists()) {
                        _NSStringUtilities.appendToFile((File)file, (String)object);
                    } else {
                        _NSStringUtilities.writeToFile((File)file, (String)object);
                    }
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)("<" + this.getClass().getName() + " Exception occurred while saving statistics in file '" + this._logPath + "': " + exception.toString()));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8196L)) break block15;
                    NSLog.debug.appendln((Throwable)exception);
                }
            }
        }
    }

    private long _averageIdleTime() {
        return this._transactionsCount != 0 ? this._totalIdleTimeIntervalMillis / (long)this._transactionsCount : 0L;
    }

    private long _averageTransactionTime() {
        return this._transactionsCount - 1 > 0 ? this._totalTransactionTimeIntervalMillis / (long)(this._transactionsCount - 1) : 0L;
    }

    private long _averageWSTransactionTime() {
        return this._webServiceTransactionsCount - 1 > 0 ? this._totalWSTransactionTimeIntervalMillis / (long)(this._webServiceTransactionsCount - 1) : 0L;
    }

    private long _averageDATransactionTime() {
        return this._directActionTransactionsCount - 1 > 0 ? this._totalDATransactionTimeIntervalMillis / (long)(this._directActionTransactionsCount - 1) : 0L;
    }

    private long _averageCATransactionTime() {
        return this._componentActionTransactionsCount - 1 > 0 ? this._totalCATransactionTimeIntervalMillis / (long)(this._componentActionTransactionsCount - 1) : 0L;
    }

    private long _movingAverageIdleTime() {
        int n = this._transactionMovingAverageSampleCount;
        long l = n == 0 ? 0L : (this._movingAverageTransactionsCount > n ? this._movingIdleTimeIntervalMillis / (long)n : (this._movingAverageTransactionsCount != 0 ? this._movingIdleTimeIntervalMillis / (long)this._movingAverageTransactionsCount : 0L));
        return l;
    }

    private long _movingAverageTransactionTime() {
        int n = this._transactionMovingAverageSampleCount;
        long l = n == 0 ? 0L : (this._movingAverageTransactionsCount > n ? this._movingTransactionTimeIntervalMillis / (long)n : (this._movingAverageTransactionsCount - 1 > 0 ? this._movingTransactionTimeIntervalMillis / (long)(this._movingAverageTransactionsCount - 1) : 0L));
        return l;
    }

    private double _averageRequestsPerSession() {
        if (this._sessionsCount > 0) {
            return (double)this._transactionsCount / (double)this._sessionsCount;
        }
        return 0.0;
    }

    private double _movingAverageRequestsPerSession() {
        int n = this._sessionMovingAverageSampleCount;
        double d = n == 0 ? 0.0 : (this._movingAverageSessionsCount > n ? this._movingAverageRequestsPerSession / (double)n : (this._movingAverageSessionsCount != 0 ? this._movingAverageRequestsPerSession / (double)this._movingAverageSessionsCount : 0.0));
        return d;
    }

    private long _movingAverageSessionLife() {
        int n = this._sessionMovingAverageSampleCount;
        long l = n == 0 ? 0L : (this._movingAverageSessionsCount > n ? (long)(this._movingAverageSessionLife / n) : (long)(this._movingAverageSessionsCount != 0 ? this._movingAverageSessionLife / this._movingAverageSessionsCount : 0));
        return l;
    }

    private NSMutableDictionary _averageSessionMemory() {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        NSMutableDictionary nSMutableDictionary2 = this.memoryUsage();
        Enumeration enumeration = nSMutableDictionary2.keyEnumerator();
        int n = WOApplication.application().activeSessionsCount();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Long l = null;
            l = n == 0 ? new Long(0L) : new Long(((Long)nSMutableDictionary2.objectForKey((Object)string) - (Long)this._initializationMemory.objectForKey((Object)string)) / (long)n);
            nSMutableDictionary.setObjectForKey((Object)l, (Object)string);
        }
        return nSMutableDictionary;
    }

    public NSMutableDictionary memoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        nSMutableDictionary.setObjectForKey((Object)new Long(runtime.totalMemory()), (Object)"Total Memory");
        nSMutableDictionary.setObjectForKey((Object)new Long(runtime.freeMemory()), (Object)"Free Memory");
        return nSMutableDictionary;
    }

    private NSArray _lastSessionStatistics() {
        return (NSArray)this._lastSessionStatistics.clone();
    }

    private static NSMutableDictionary _hashtableForHandlerStatistics(NSMutableDictionary nSMutableDictionary) {
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary();
        Enumeration enumeration = nSMutableDictionary.keyEnumerator();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            long[] lArray = (long[])nSMutableDictionary.objectForKey((Object)string);
            NSMutableDictionary nSMutableDictionary3 = new NSMutableDictionary();
            nSMutableDictionary3.setObjectForKey((Object)new Long(lArray[0]), (Object)_PagesTotalServed);
            nSMutableDictionary3.setObjectForKey((Object)new Double((double)((long)((double)lArray[1] / ((double)lArray[0] * 1.0))) / 1000.0), (Object)_PagesAvgResponseTime);
            nSMutableDictionary3.setObjectForKey((Object)new Double((double)lArray[2] / 1000.0), (Object)_PagesMinResponseTime);
            nSMutableDictionary3.setObjectForKey((Object)new Double((double)lArray[3] / 1000.0), (Object)_PagesMaxResponseTime);
            nSMutableDictionary2.setObjectForKey((Object)nSMutableDictionary3, (Object)string);
        }
        return nSMutableDictionary2;
    }

    private NSDictionary _pagesStatistics() {
        return WOStatisticsStore._hashtableForHandlerStatistics(this._pagesStatistics);
    }

    private NSDictionary _webServiceStatistics() {
        return WOStatisticsStore._hashtableForHandlerStatistics(this._webServiceStatistics);
    }

    private NSDictionary _directActionStatistics() {
        return WOStatisticsStore._hashtableForHandlerStatistics(this._directActionStatistics);
    }

    private NSDictionary _pathsStatistics() {
        return (NSDictionary)this._pathsStatistics.clone();
    }

    protected String _password() {
        return this._password;
    }

    protected int _statisticStoreSessionMax() {
        return this._statStoreSessionMax;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public boolean validateLogin(String string, WOSession wOSession) {
        boolean bl = false;
        if (string.equals(this._password)) {
            wOSession._allowToViewStatistics();
            bl = true;
        }
        return bl;
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    static {
        TheDateFormat.setDefaultFormatTimeZone(TheDateFormat.defaultFormatTimeZone());
        TheDateFormatTZ = TheDateFormat.defaultFormatTimeZone();
        TheFileDateFormat = new NSTimestampFormatter("%d-%m-%Y-%H%M%S");
    }
}

