/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver._WORunLoop;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;

public class WOTimer {
    private NSTimestamp _fireDate;
    private Object _target;
    private NSSelector _selector;
    private Object _userInfo;
    private boolean _firing;
    private boolean _repeats;
    private boolean _invalid;
    private boolean _hasUserInfoClass;
    private long _timeInterval;

    public static WOTimer scheduledTimer(long l, Object object, String string, Object object2, boolean bl) {
        WOTimer wOTimer = new WOTimer(l, object, string, object2, null, bl);
        wOTimer.schedule();
        return wOTimer;
    }

    public static WOTimer scheduledTimer(long l, Object object, String string, Object object2, Class clazz, boolean bl) {
        WOTimer wOTimer = new WOTimer(l, object, string, object2, clazz, bl);
        wOTimer.schedule();
        return wOTimer;
    }

    public WOTimer(long l, Object object, String string, Object object2, Class clazz, boolean bl) {
        this(null, l, object, string, object2, clazz, bl);
    }

    public WOTimer(NSTimestamp nSTimestamp, long l, Object object, String string, Object object2, Class clazz, boolean bl) {
        Class[] classArray;
        if (object == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Can not instantiate WOTimer with null target");
        }
        if (l <= 0L) {
            l = 0L;
        }
        this._fireDate = nSTimestamp == null ? new NSTimestamp(System.currentTimeMillis() + l) : nSTimestamp;
        this._target = object;
        this._userInfo = object2;
        this._hasUserInfoClass = clazz != null;
        this._repeats = bl;
        this._timeInterval = l;
        if (this._userInfo != null || this._hasUserInfoClass) {
            classArray = new Class[1];
            classArray[0] = this._hasUserInfoClass ? clazz : this.getClass();
        } else {
            classArray = new Class[]{};
        }
        this._selector = new NSSelector(string, classArray);
        try {
            this._selector.methodOnClass(this._target.getClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NSForwardException((Throwable)noSuchMethodException, this.toString() + ": the method '" + string + "' is not a public method, or the number of arguments does not match any existing method in the class.");
        }
    }

    public void fire() {
        if (!this._firing && !this._invalid) {
            block9: {
                this._firing = true;
                try {
                    if (this._userInfo != null || this._hasUserInfoClass) {
                        if (this._hasUserInfoClass) {
                            this._selector.invoke(this._target, this._userInfo);
                        } else {
                            this._selector.invoke(this._target, (Object)this);
                        }
                    } else {
                        this._selector.invoke(this._target);
                    }
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)(this.toString() + ": ignoring exception that occurred during fire():\n" + exception.toString()));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) break block9;
                    NSLog.debug.appendln((Throwable)exception);
                }
            }
            this._firing = false;
            if (this._repeats && !this._invalid) {
                long l;
                long l2 = this._fireDate.getTime();
                this._fireDate = l2 + this._timeInterval < (l = System.currentTimeMillis()) ? new NSTimestamp(l) : new NSTimestamp(l2 + this._timeInterval);
            } else {
                this.invalidate();
            }
        }
    }

    public NSTimestamp fireDate() {
        return this._fireDate;
    }

    public double timeInterval() {
        return (double)this._timeInterval / 1000.0;
    }

    public void invalidate() {
        if (!this._invalid) {
            this._invalid = true;
            _WORunLoop.currentRunLoop().removeTimer(this);
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    public Object userInfo() {
        return this._userInfo;
    }

    public Object target() {
        return this._target;
    }

    public NSSelector selector() {
        return this._selector;
    }

    public void schedule() {
        _WORunLoop.currentRunLoop().addTimer(this);
    }

    public String toString() {
        if (this._hasUserInfoClass) {
            return "<" + this.getClass().getName() + " firing method " + (this._target != null ? this._target.getClass().getName() : null) + "." + this._selector.name() + "(" + (this._userInfo != null ? this._userInfo.toString() : "null") + ")" + " at " + this._fireDate + " >";
        }
        return "<" + this.getClass().getName() + " firing method " + (this._target != null ? this._target.getClass().getName() : null) + "." + this._selector.name() + "()" + " at " + this._fireDate + " >";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WOTimer)) {
            return false;
        }
        WOTimer wOTimer = (WOTimer)object;
        NSSelector nSSelector = wOTimer.selector();
        Object object2 = wOTimer.target();
        Object object3 = wOTimer.userInfo();
        return (this._selector == nSSelector || this._selector.equals((Object)nSSelector)) && (this._target == object2 || this._target != null && this._target.equals(object2)) && (this._userInfo == object3 || this._userInfo != null && this._userInfo.equals(object3));
    }

    public int hashCode() {
        return this.fireDate().hashCode();
    }
}

