/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver._private.WODWSServiceObject;
import com.webobjects.appserver._private.WOWebService;
import com.webobjects.foundation.NSLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class WOWebServiceRegistrar {
    public static HashSet _registeredServiceNames = new HashSet();
    private static final String emptyDeploymentFileString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <deployment xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\"> <globalConfiguration> <parameter name=\"sendMultiRefs\" value=\"true\"/> <parameter name=\"sendXsiTypes\" value=\"true\"/> <parameter name=\"sendXMLDeclaration\" value=\"true\"/> <requestFlow> <handler type=\"java:com.webobjects.webservice.support._private.WOSecurityHandler\"/> <handler type=\"java:com.webobjects.appserver._private.WOServerSessionHandler\"/> </requestFlow> <responseFlow> <handler type=\"java:com.webobjects.appserver._private.WOServerSessionHandler\"/> <handler type=\"java:com.webobjects.webservice.support._private.WOSecurityHandler\"/> </responseFlow> </globalConfiguration> <handler name=\"URLMapper\" type=\"java:org.apache.axis.handlers.http.URLMapper\"/> <handler name=\"HTTPActionHandler\" type=\"java:org.apache.axis.handlers.http.HTTPActionHandler\"/> <handler name=\"RPCDispatcher\" type=\"java:org.apache.axis.providers.java.RPCProvider\"/> <handler name=\"MsgDispatcher\" type=\"java:org.apache.axis.providers.java.MsgProvider\"/> <transport name=\"http\"> <requestFlow> <handler type=\"HTTPActionHandler\"/> <handler type=\"URLMapper\"/> </requestFlow> </transport> </deployment>";
    private static Document document = null;
    private static String serviceStringTemplate1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <service xmlns=\"http://xml.apache.org/axis/wsdd/\" name=\"";
    private static String serviceStringTemplateRPC = "\" provider=\"Handler\"><parameter name=\"handlerClass\" value=\"org.apache.axis.providers.java.RPCProvider\"/> <parameter name=\"className\" value=\"";
    private static String serviceStringTemplateDoc = "\" provider=\"Handler\" style=\"document\"><parameter name=\"handlerClass\" value=\"org.apache.axis.providers.java.MsgProvider\"/> <parameter name=\"className\" value=\"";
    private static String serviceStringTemplate3 = "\" /><parameter name=\"allowedMethods\" value=\"";
    private static String serviceStringTemplate4 = "\" /></service>";
    private static final String d2wsServiceStringTemplate2 = "\" provider=\"Handler\"><parameter name=\"handlerClass\" value=\"com.webobjects.appserver._private.WORPCProvider\"/> <parameter name=\"scope\" value=\"Application\" /> <parameter name=\"className\" value=\"";

    private static void setUpDeploymentDocument() {
        try {
            InputStream inputStream = WOApplication.application().resourceManager().inputStreamForResourceNamed("template_server.wsdd", "JavaWebObjects", null);
            document = XMLUtils.newDocument((InputStream)inputStream);
        }
        catch (Exception exception) {
            NSLog._conditionallyLogPrivateException((Throwable)exception);
        }
        if (document == null) {
            NSLog.out.appendln((Object)"WOWebServiceRegistrar - couldn't use template_server.wsdd in JavaWebObjects.framework - defaulting to basic empty wsdd");
            try {
                document = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(emptyDeploymentFileString.getBytes()));
            }
            catch (Exception exception) {
                NSLog._conditionallyLogPrivateException((Throwable)exception);
            }
        }
    }

    public static Document _getEmptyDeployment() {
        return document;
    }

    public static void registerWebService(Class clazz, boolean bl) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.registerWebService(Class, boolean) - registering " + clazz));
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Unable to register web service for class " + clazz);
        }
        String string = clazz.getName();
        if (string.lastIndexOf(".") > 0) {
            string = string.substring(string.lastIndexOf("."));
        }
        String[] stringArray = null;
        if (!(bl || (stringArray = WOWebServiceRegistrar.getDeclaredMethodsForClass(clazz)) != null && stringArray.length == 1)) {
            String string2 = stringArray == null || stringArray.length == 0 ? " no handler method implemented." : " only one handler method may be implemented.";
            throw new IllegalArgumentException("Unable to register document style web service - " + string2);
        }
        WOWebServiceRegistrar.registerWebService(string, clazz, stringArray, bl);
    }

    public static void registerWebService(String string, Class clazz, boolean bl) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.registerWebService (String, Class, boolean) - registering " + clazz + " with name " + string));
        }
        if (string == null || clazz == null) {
            throw new IllegalArgumentException("Unable to register web service for class " + clazz + " with name " + string);
        }
        String[] stringArray = null;
        if (!(bl || (stringArray = WOWebServiceRegistrar.getDeclaredMethodsForClass(clazz)) != null && stringArray.length == 1)) {
            String string2 = stringArray == null || stringArray.length == 0 ? " no handler method implemented." : " only one handler method may be implemented.";
            throw new IllegalArgumentException("Unable to register document style web service - " + string2);
        }
        WOWebServiceRegistrar.registerWebService(string, clazz, stringArray, bl);
    }

    public static void registerWebService(String string, Class clazz, String[] stringArray, boolean bl) {
        Document document;
        block7: {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("WOWebServiceRegistrar.registerWebService (String, Class, String[], boolean) - registering " + clazz + " with name " + string + " and a set of allowed methods"));
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("WOWebServiceRegistrar.registerWebServiceWithNameForClassAllowedMethods - allowed methods are:\n\t " + WOWebServiceRegistrar.createAllowedMethodsString(stringArray)));
            }
            if (string == null || clazz == null) {
                throw new IllegalArgumentException("Unable to register web service for class " + clazz + " with name " + string + ", methods " + WOWebServiceRegistrar.createAllowedMethodsString(stringArray) + " isRPC " + bl);
            }
            if (!(bl || stringArray != null && stringArray.length == 1)) {
                String string2 = stringArray == null ? " no handler method specified." : (stringArray.length == 0 ? " a handler method must be specified." : " only one handler method may be specified.");
                throw new IllegalArgumentException("Unable to register document style web service - " + string2);
            }
            String string3 = WOWebServiceRegistrar.createServiceString(string, clazz, stringArray, bl, false);
            document = null;
            try {
                document = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(string3.getBytes()));
            }
            catch (Exception exception) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) break block7;
                NSLog.debug.appendln((Object)"Couldn't parse XML stream");
                NSLog.debug.appendln((Throwable)exception);
            }
        }
        if (document != null) {
            WOWebService.registerService(document.getDocumentElement());
        }
    }

    public static void registerD2WebServiceWithOperations(String string, String[] stringArray) {
        Document document;
        block4: {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0L)) {
                NSLog.debug.appendln((Object)"WOWebServiceRegistrar.registerD2WebServiceWithOperations");
            }
            String string2 = WOWebServiceRegistrar.createServiceString(string, WODWSServiceObject.class, stringArray, true, true);
            document = null;
            try {
                document = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(string2.getBytes()));
            }
            catch (Exception exception) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) break block4;
                NSLog.debug.appendln((Object)"Couldn't parse XML stream");
                NSLog.debug.appendln((Throwable)exception);
            }
        }
        if (document != null) {
            WOWebService.registerService(document.getDocumentElement());
        }
    }

    public static void unregisterWebService(Class clazz) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.deregisterServiceForClass - deregistering " + clazz));
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Unable to deregister web service for class " + clazz);
        }
        String string = clazz.getName();
        if (string.lastIndexOf(".") > 0) {
            string = string.substring(string.lastIndexOf("."));
        }
        WOWebServiceRegistrar.unregisterWebService(string);
    }

    public static void unregisterWebService(String string) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.deregisterServiceForName - deregistering " + string));
        }
        if (string == null) {
            throw new IllegalArgumentException("Unable to deregister web service with name " + string);
        }
        WOWebService.deregisterServiceWithName(string);
    }

    private static String[] getDeclaredMethodsForClass(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        String[] stringArray = new String[methodArray.length];
        for (int i = 0; i < methodArray.length; ++i) {
            stringArray[i] = methodArray[i].getName();
        }
        return stringArray;
    }

    private static String createServiceString(String string, Class clazz, String[] stringArray, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(serviceStringTemplate1);
        stringBuffer.append(string);
        if (bl2) {
            stringBuffer.append(d2wsServiceStringTemplate2);
        } else if (bl) {
            stringBuffer.append(serviceStringTemplateRPC);
        } else {
            stringBuffer.append(serviceStringTemplateDoc);
        }
        stringBuffer.append(clazz.getName());
        stringBuffer.append(serviceStringTemplate3);
        stringBuffer.append(WOWebServiceRegistrar.createAllowedMethodsString(stringArray));
        stringBuffer.append(serviceStringTemplate4);
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.createServiceString " + stringBuffer));
        }
        return stringBuffer.toString();
    }

    private static String createAllowedMethodsString(String[] stringArray) {
        if (stringArray == null) {
            return "*";
        }
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 20);
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ,");
        }
        stringBuffer.append(stringArray[n - 1]);
        return stringBuffer.toString();
    }

    public static void registerFactoriesForClassWithQName(SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, Class clazz, QName qName) {
        WOWebService.registerSerializerAndDeserializerFactoriesForClassWithQName(serializerFactory, deserializerFactory, clazz, qName);
    }

    public static void registerXSLTForServiceAndOperation(URL uRL, String string, String string2) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebServiceRegistrar.registerXSLTTransformForServiceAndOperation - registering " + uRL + " " + string + " " + string2));
        }
        if (uRL == null || string == null || string2 == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            NSLog.out.appendln((Object)("WOWebServiceRegistrar.registerXSLTTransformForServiceAndOperation - unable to openURL: " + uRL + " (" + string + " " + string2 + ")"));
            return;
        }
        WOWebService.registerTransformerForSourceServiceAndOperation(new StreamSource(inputStream), string, string2);
    }

    public static void setSecurityDelegate(Object object) {
        WOWebService.setSecurityDelegate(object);
    }

    static {
        WOWebServiceRegistrar.setUpDeploymentDocument();
    }
}

