/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;

final class _CookieParser {
    _CookieParser() {
    }

    private static int findNameDelimiter(String string, int n, int n2) {
        char c;
        while (n < n2 && (c = string.charAt(n)) != ';' && c != ',' && c != '=') {
            ++n;
        }
        return n;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static int skipWhiteSpace(String string, int n, int n2) {
        while (n < n2 && _CookieParser.isWhiteSpace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static void _parse(String string, NSMutableDictionary nSMutableDictionary) {
        int n = string.length();
        int n2 = _CookieParser.skipWhiteSpace(string, 0, n);
        while (n2 < n) {
            int n3 = _CookieParser.findNameDelimiter(string, n2, n);
            String string2 = string.substring(n2, n3).trim();
            if (string2.length() == 0) {
                throw new IllegalStateException("Malformed cookie content:\"" + string + "\"");
            }
            n2 = n3;
            String string3 = "";
            if (n2 < n) {
                boolean bl = false;
                if (string.charAt(n2) == '=') {
                    n2 = _CookieParser.skipWhiteSpace(string, n2 + 1, n);
                    bl = true;
                }
                if (n2 >= n) {
                    NSLog.err.appendln((Object)("CookieParser: Found a null cookie value in: '" + string + "'. Will continue by setting value to the empty string."));
                } else {
                    switch (string.charAt(n2)) {
                        case '\"': {
                            int n4 = string.indexOf(34, n2 + 1);
                            if (n4 < 0) {
                                throw new IllegalStateException("Malformed cookie content. No closing quote found at: \"" + string + "\"");
                            }
                            string3 = string.substring(n2 + 1, n4);
                            n2 = _CookieParser.skipWhiteSpace(string, n4 + 1, n);
                            if (n2 >= n) break;
                            if (string.charAt(n2) != ';' && string.charAt(n2) != ',') {
                                throw new IllegalStateException("Expected a \";\" instead of \"" + string.substring(n2) + "\"");
                            }
                            ++n2;
                            break;
                        }
                        case ',': 
                        case ';': {
                            if (bl) {
                                NSLog.err.appendln((Object)("CookieParser: Found a null cookie value in: '" + string + "'. Will continue by setting value to the empty string."));
                                string3 = "";
                            } else {
                                ++n2;
                                break;
                            }
                        }
                        default: {
                            int n5;
                            for (n5 = n2; n5 < n; ++n5) {
                                char c = string.charAt(n5);
                                if (!_CookieParser.isWhiteSpace(c) && c != ';' && c != ',' && c != '\"') continue;
                                if (c != ' ') break;
                                NSLog.err.appendln((Object)("CookieParser: Found an unquoted space in: '" + string + "'. Will continue by assuming the value was properly quoted."));
                            }
                            if (n5 == n) {
                                string3 = string.substring(n2).trim();
                                n2 = n5;
                            } else {
                                string3 = string.substring(n2, n5).trim();
                                n2 = _CookieParser.skipWhiteSpace(string, n5, n);
                                if (n2 < n && string.charAt(n2) != ';' && string.charAt(n2) != ',') {
                                    throw new IllegalStateException("CookieParser: Expected a \";\" or a \",\" instead of \"" + string.substring(n2) + "\"");
                                }
                            }
                            ++n2;
                            break;
                        }
                    }
                }
            }
            n2 = _CookieParser.skipWhiteSpace(string, n2, n);
            NSMutableArray nSMutableArray = (NSMutableArray)nSMutableDictionary.objectForKey((Object)string2);
            if (nSMutableArray != null) {
                nSMutableArray.addObject((Object)string3);
                continue;
            }
            NSMutableArray nSMutableArray2 = new NSMutableArray();
            nSMutableArray2.addObject((Object)string3);
            nSMutableDictionary.setObjectForKey((Object)nSMutableArray2, (Object)string2);
        }
        if (nSMutableDictionary.count() == 0) {
            throw new IllegalStateException("CookieParser: empty cookie set not allowed by RFC 2109");
        }
    }

    public static NSDictionary parse(String string) {
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
        if (string == null) {
            return nSMutableDictionary;
        }
        try {
            _CookieParser._parse(string, nSMutableDictionary);
        }
        catch (RuntimeException runtimeException) {
            nSMutableDictionary = WOApplication.application().handleMalformedCookieString(runtimeException, string, nSMutableDictionary);
        }
        return nSMutableDictionary;
    }
}

