/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.util.GregorianCalendar;

public class License {
    private int _productCode = 0;
    private int _productMajorVers = 0;
    private int _productMinorVers = 0;
    private int _maxReqPerMin = 0;
    private boolean _multithreadingEnabled = false;
    private boolean _loadBalancingEnabled = false;
    public static final int MacOSX = 1;
    public static final int WinNT = 2;
    public static final int Unix = 4;
    public static final int HPUX = 8;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage - SerialNumberUtil serialNumber");
            System.exit(0);
        }
        License license = new License(stringArray[0]);
        System.out.println(license);
    }

    public License(String string) throws IllegalArgumentException {
        FSSerialRec fSSerialRec;
        byte[] byArray;
        try {
            byArray = SerialNumberUtil.FSSerialString2Bytes(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Invalid serial number");
        }
        try {
            fSSerialRec = SerialNumberUtil.FSSerialBytes2Struct(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException("Invalid serial number - Unable to convert string to bytes");
        }
        boolean bl = SerialNumberUtil.FSSerialNumberIsValid(fSSerialRec);
        if (!bl) {
            throw new IllegalArgumentException("Not a valid serial number");
        }
        int n = (fSSerialRec.womacosx ? 1 : 0) | (fSSerialRec.wowinnt ? 2 : 0) | (fSSerialRec.wounix ? 4 : 0);
        String string2 = System.getProperty("os.name");
        int n2 = string2.equals("Rhapsody") ? 1 : (string2.startsWith("Darwin") ? 1 : (string2.startsWith("Mac OS") ? 1 : (string2.startsWith("Windows") ? 2 : (string2.equals("Solaris") ? 4 : (string2.equals("Linux") ? 4 : (string2.equals("HP-UX") ? 4 : 4))))));
        if ((n2 & n) == 0) {
            throw new IllegalArgumentException("Serial number not valid for this platform");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.getInstance();
        int n3 = (gregorianCalendar.get(1) - 1998) * 12 + gregorianCalendar.get(2);
        if (fSSerialRec.expiremonth != 0 && n3 > fSSerialRec.expiremonth) {
            throw new IllegalArgumentException("Serial number has expired");
        }
        this._productCode = fSSerialRec.productCode;
        this._productMajorVers = fSSerialRec.version >> 4;
        this._productMinorVers = fSSerialRec.version & 0xF;
        this._maxReqPerMin = fSSerialRec.maxrequests * 25;
        this._multithreadingEnabled = fSSerialRec.multithreading;
        this._loadBalancingEnabled = fSSerialRec.loadbalancing;
        if (this._productMajorVers != 5 && this._productMinorVers > 1) {
            throw new IllegalArgumentException("Serial number is not for this version of WebObjects");
        }
    }

    public String toString() {
        return "<License productCode=" + this._productCode + "\nproductMajorVers=" + this._productMajorVers + "\nproductMinorVers=" + this._productMinorVers + "\nmaxReqPerMin=" + this._maxReqPerMin + "\nmultithreadingEnabled=" + this._multithreadingEnabled + "\nloadBalancingEnabled=" + this._loadBalancingEnabled + ">";
    }

    public int productCode() {
        return this._productCode;
    }

    public int majorVersion() {
        return this._productMajorVers;
    }

    public int minorVersion() {
        return this._productMinorVers;
    }

    public int maxReqPerMin() {
        return this._maxReqPerMin;
    }

    public boolean loadBalancingEnabled() {
        return this._loadBalancingEnabled;
    }

    public boolean multiThreadingEnabled() {
        return this._multithreadingEnabled;
    }

    private static class SNDef {
        int flags;
        SNStructDef[] structDef;
        String strDef;
        int bytesLen;

        public SNDef(int n, SNStructDef[] sNStructDefArray, String string, int n2) {
            this.flags = n;
            this.structDef = sNStructDefArray;
            this.strDef = string;
            this.bytesLen = n2;
        }
    }

    private static class SNStructDef {
        int type;
        String offset;
        int bitLen;

        public SNStructDef(int n, String string, int n2) {
            this.type = n;
            this.offset = string;
            this.bitLen = n2;
        }

        public void setOffsetWithValue(FSSerialRec fSSerialRec, Object object) throws IllegalArgumentException {
            block8: {
                Field field;
                try {
                    Class<?> clazz = fSSerialRec.getClass();
                    field = clazz.getDeclaredField(this.offset);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException("Requested variable does not exist in FSSerialRec or type is incorrect.");
                }
                Class<?> clazz = field.getType();
                String string = clazz.getName();
                try {
                    if (string.equals("int")) {
                        field.setInt(fSSerialRec, (Integer)object);
                        break block8;
                    }
                    if (string.equals("boolean")) {
                        field.setBoolean(fSSerialRec, (Boolean)object);
                        break block8;
                    }
                    if (string.equals("long")) {
                        field.setLong(fSSerialRec, (Long)object);
                        break block8;
                    }
                    if (string.equals("char")) {
                        field.setChar(fSSerialRec, ((Character)object).charValue());
                        break block8;
                    }
                    throw new IllegalAccessException("new string in catch block");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Requested variable does not exist in FSSerialRec or type is incorrect.");
                }
            }
        }

        public Object getValueWithOffset(FSSerialRec fSSerialRec) throws IllegalArgumentException {
            Constable constable;
            block8: {
                Field field;
                constable = null;
                try {
                    Class<?> clazz = fSSerialRec.getClass();
                    field = clazz.getDeclaredField(this.offset);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException("Requested variable does not exist in FSSerialRec or type is incorrect.");
                }
                Class<?> clazz = field.getType();
                String string = clazz.getName();
                try {
                    if (string.equals("int")) {
                        constable = new Integer(field.getInt(fSSerialRec));
                        break block8;
                    }
                    if (string.equals("boolean")) {
                        constable = field.getBoolean(fSSerialRec) ? Boolean.TRUE : Boolean.FALSE;
                        break block8;
                    }
                    if (string.equals("long")) {
                        constable = new Long(field.getLong(fSSerialRec));
                        break block8;
                    }
                    if (string.equals("char")) {
                        constable = new Character(field.getChar(fSSerialRec));
                        break block8;
                    }
                    throw new IllegalAccessException("new string in catch block");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Requested variable does not exist in FSSerialRec or type is incorrect.");
                }
            }
            return constable;
        }
    }

    public static class FSSerialRec {
        public int productCode;
        public int version;
        public int locationCode;
        public int serialNumberVersion;
        public long serialNumber;
        public long check;
        public int station;
        public int reserved;
        public int maxrequests;
        public int expiremonth;
        public boolean womacosx;
        public boolean wowinnt;
        public boolean woplaceholder;
        public boolean wounix;
        public boolean multithreading;
        public boolean loadbalancing;

        public String toString() {
            return "<FSSerialRec productCode=" + this.productCode + " version=" + this.version + " locationCode=" + this.locationCode + " serialNumberVersion=" + this.serialNumberVersion + " serialNumber=" + this.serialNumber + " check=" + this.check + " station=" + this.station + " reserved=" + this.reserved + " maxrequests=" + this.maxrequests + " expiremonth=" + this.expiremonth + " womacosx=" + this.womacosx + " wowinnt=" + this.wowinnt + " wounix=" + this.wounix + " multithreading=" + this.multithreading + " loadbalancing=" + this.loadbalancing + " >";
        }
    }

    public static class SerialNumberUtil {
        static final int kSNEnd = 0;
        static final int kSNChar = 1;
        static final int kSNBoolean = 2;
        static final int kSNShort = 3;
        static final int kSNLong = 4;
        static final int kSNCheck = 5;
        static final int kSNVersion = 6;
        static final int kTwiddleBits = 1;
        static final int kFSSerialBytesLen = 40;
        static final int kFSSerialStringLen = 40;
        static final int kSerialNumVersion = 1;
        static final int kASProductCodeNum = 0;
        static final int kARAProductCodeNum = 1;
        static final int kASIPProductCodeNum = 2;
        static final int kYBRunProductCodeNum = 8;
        static final int kYBSDKProductCodeNum = 9;
        static final int kWODEVProductCodeNum = 10;
        static final int kWODEPProductCodeNum = 11;
        static final int kVideoStartProductCodeNum = 16;
        static final int kInvalidProductCodeNum = 255;
        static FSSerialRec FSSerialRec;
        static int SNCheck;
        static SNStructDef SNStructDef;
        static SNDef SNDef;
        static int OSErr;
        static int Str255;
        static SNStructDef[] alphaSNStructDef;
        static SNDef alphaSNDef;
        static SNStructDef[] finalSNStructDef;
        static SNDef finalSNDef;
        static long acm_randseed;

        public static SNDef SNDefOfString(String string) {
            if (SerialNumberUtil.SNVersionOfString(string) == 0) {
                return alphaSNDef;
            }
            return finalSNDef;
        }

        public static SNDef SNDefOfBytes(byte[] byArray) {
            if (SerialNumberUtil.SNVersionOfBytes(byArray) == 0) {
                return alphaSNDef;
            }
            return finalSNDef;
        }

        public static SNDef SNDefOfStruct(FSSerialRec fSSerialRec) {
            if (fSSerialRec.serialNumberVersion == 0) {
                return alphaSNDef;
            }
            return finalSNDef;
        }

        public static FSSerialRec FSSerialBytes2Struct(byte[] byArray) throws IllegalArgumentException {
            return SerialNumberUtil.SNBytes2Struct(SerialNumberUtil.SNDefOfBytes(byArray), byArray);
        }

        public static boolean FSSerialNumberIsValid(FSSerialRec fSSerialRec) {
            int n;
            boolean bl = SerialNumberUtil.SNIsValid(SerialNumberUtil.SNDefOfStruct(fSSerialRec), fSSerialRec);
            if (bl && (n = fSSerialRec.productCode) != 8 && n != 9 && n != 10 && n != 11) {
                bl = false;
            }
            return bl;
        }

        public static byte[] FSSerialString2Bytes(String string) throws IllegalArgumentException {
            return SerialNumberUtil.SNString2Bytes(SerialNumberUtil.SNDefOfString(string), string);
        }

        public static void set_acm_seed(long l) {
            if (l == 0L) {
                l = 1L;
            }
            if (l < 0L) {
                l = -l;
            }
            acm_randseed = l;
        }

        public static long acm_random() {
            long l = Integer.MAX_VALUE;
            long l2 = acm_randseed % 127773L;
            long l3 = acm_randseed / 127773L;
            long l4 = 16807L * l2 - 2836L * l3;
            acm_randseed = l4 > 0L ? l4 : l4 + l;
            return acm_randseed;
        }

        public static int BitLen(int n, int n2) {
            int n3;
            int n4 = n;
            while (--n2 != 0) {
                n4 *= n;
            }
            for (n3 = 31; n3 > 0 && (1L << n3 & (long)n4) == 0L; --n3) {
            }
            return n3;
        }

        public static int MapSegmentString2Bytes(int n, int n2, String string, int n3, byte[] byArray, int n4, int n5) {
            int n6 = 0;
            int n7 = SerialNumberUtil.BitLen(n, n2);
            if ((n5 + n7 + 7) / 8 >= n4) {
                return 0;
            }
            while (n2 > 0) {
                --n2;
                char c = string.charAt(n3);
                ++n3;
                int n8 = Character.toLowerCase(c) - (n == 10 ? 48 : 97);
                if (n8 < 0 || n8 >= n) {
                    return 0;
                }
                n6 = n6 * n + n8;
            }
            if (((long)n6 & ((1L << n7) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                return 0;
            }
            while (n7 > 0) {
                if (((long)n6 & 1L << --n7) != 0L) {
                    int n9 = n5 / 8;
                    byArray[n9] = (byte)(byArray[n9] | 1 << n5 % 8);
                    n6 = (int)((long)n6 ^ 1L << n7);
                }
                ++n5;
            }
            return n5;
        }

        public static int MapString2Bytes(String string, String string2, byte[] byArray, int n) {
            int n2 = 0;
            int n3 = 26;
            int n4 = 0;
            int n5 = 0;
            block5: for (n5 = 0; n5 < string.length(); ++n5) {
                char c = string.charAt(n5);
                switch (c) {
                    case 'A': 
                    case 'a': {
                        n3 = 26;
                        continue block5;
                    }
                    case 'D': 
                    case 'd': {
                        n3 = 10;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n6 = c - 48;
                        n2 = SerialNumberUtil.MapSegmentString2Bytes(n3, n6, string2, n4, byArray, n, n2);
                        if (n2 == 0) {
                            return 0;
                        }
                        n4 += n6;
                        continue block5;
                    }
                    default: {
                        if (c != string2.charAt(n4)) {
                            return 0;
                        }
                        ++n4;
                    }
                }
            }
            if (n4 != string2.length()) {
                return 0;
            }
            return n2;
        }

        public static byte[] SNString2Bytes(SNDef sNDef, String string) throws IllegalArgumentException {
            byte[] byArray = new byte[sNDef.bytesLen];
            int n = SerialNumberUtil.MapString2Bytes(sNDef.strDef, string, byArray, sNDef.bytesLen);
            if ((n + 7) / 8 == 0) {
                throw new IllegalArgumentException("Length is 0");
            }
            return byArray;
        }

        public static int MapBytes2Struct(boolean bl, SNStructDef[] sNStructDefArray, FSSerialRec fSSerialRec, byte[] byArray, int n) {
            int n2 = 0;
            block7: for (int i = 0; i < sNStructDefArray.length; ++i) {
                SNStructDef sNStructDef = sNStructDefArray[i];
                int n3 = 0;
                int n4 = sNStructDef.bitLen;
                int n5 = bl ? (int)((1L << n4) - 1L & 0xFFFFFFFFAAAAAAAAL) : 0;
                while (n4 != 0) {
                    --n4;
                    if ((byArray[n2 / 8] & 1 << n2 % 8) != 0) {
                        n3 = (int)((long)n3 | 1L << n4);
                    }
                    ++n2;
                }
                switch (sNStructDef.type) {
                    case 6: {
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Integer(n3));
                        continue block7;
                    }
                    case 1: {
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Character((char)(n3 ^ n5)));
                        continue block7;
                    }
                    case 2: {
                        sNStructDef.setOffsetWithValue(fSSerialRec, (n3 ^ n5) != 0 ? Boolean.TRUE : Boolean.FALSE);
                        continue block7;
                    }
                    case 3: {
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Integer(n3 ^ n5));
                        continue block7;
                    }
                    case 4: 
                    case 5: {
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Long(n3 ^ n5));
                        continue block7;
                    }
                }
            }
            return n2;
        }

        public static FSSerialRec SNBytes2Struct(SNDef sNDef, byte[] byArray) throws IllegalArgumentException {
            FSSerialRec fSSerialRec;
            int n = SerialNumberUtil.MapBytes2Struct((sNDef.flags & 1) != 0, sNDef.structDef, fSSerialRec = new FSSerialRec(), byArray, sNDef.bytesLen);
            if ((n + 7) / 8 == 0) {
                throw new IllegalArgumentException("Length is 0");
            }
            return fSSerialRec;
        }

        public static boolean GenerateCheck(boolean bl, SNStructDef[] sNStructDefArray, FSSerialRec fSSerialRec) {
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            boolean bl2 = true;
            block7: for (int i = 0; i < sNStructDefArray.length; ++i) {
                SNStructDef sNStructDef = sNStructDefArray[i];
                int n2 = sNStructDef.bitLen;
                switch (sNStructDef.type) {
                    case 1: {
                        int n3 = (int)((long)((Number)sNStructDef.getValueWithOffset(fSSerialRec)).intValue() & (1L << n2) - 1L);
                        l ^= (long)n3 << 24 | (long)n3 << 16 | (long)n3 << 8 | (long)n3;
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Character((char)n3));
                        continue block7;
                    }
                    case 2: {
                        int n4 = (int)((long)((Boolean)sNStructDef.getValueWithOffset(fSSerialRec) != false ? 1 : 0) & (1L << n2) - 1L);
                        l ^= (long)n4 << 24 | (long)n4 << 16 | (long)n4 << 8 | (long)n4;
                        sNStructDef.setOffsetWithValue(fSSerialRec, n4 != 0 ? Boolean.TRUE : Boolean.FALSE);
                        continue block7;
                    }
                    case 3: 
                    case 6: {
                        int n5 = (int)((long)((Number)sNStructDef.getValueWithOffset(fSSerialRec)).intValue() & (1L << n2) - 1L);
                        l ^= (long)n5 << 16 | (long)n5;
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Integer(n5));
                        continue block7;
                    }
                    case 4: {
                        long l3 = ((Number)sNStructDef.getValueWithOffset(fSSerialRec)).longValue() & (n2 != 32 ? (1L << n2) - 1L : -1L);
                        l ^= l3;
                        sNStructDef.setOffsetWithValue(fSSerialRec, new Long(l3));
                        continue block7;
                    }
                    case 5: {
                        n = n2;
                        l2 = ((Number)sNStructDef.getValueWithOffset(fSSerialRec)).longValue();
                        continue block7;
                    }
                }
            }
            if (l2 != 0L) {
                SerialNumberUtil.set_acm_seed(l);
                if (bl) {
                    l2 = SerialNumberUtil.acm_random() & (n != 32 ? (1L << n) - 1L : -1L);
                } else {
                    bl2 = l2 == (SerialNumberUtil.acm_random() & (n != 32 ? (1L << n) - 1L : -1L));
                }
            }
            return bl2;
        }

        public static boolean SNIsValid(SNDef sNDef, FSSerialRec fSSerialRec) {
            return SerialNumberUtil.GenerateCheck(false, sNDef.structDef, fSSerialRec);
        }

        public static int SNVersionOfString(String string) {
            char c = string.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return c - 65;
            }
            if (c >= 'a' && c <= 'z') {
                return c - 97;
            }
            return 0;
        }

        public static int SNVersionOfBytes(byte[] byArray) {
            return byArray[0] >> 4;
        }

        public static void SNDefStats(SNDef sNDef, int n, int n2, int n3, int n4, int n5) {
            int n6 = 26;
            String string = sNDef.strDef;
            SNStructDef[] sNStructDefArray = sNDef.structDef;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            block5: for (n10 = 0; n10 < string.length(); ++n10) {
                char c = string.charAt(n10);
                switch (c) {
                    case 'A': 
                    case 'a': {
                        n6 = 26;
                        continue block5;
                    }
                    case 'D': 
                    case 'd': {
                        n6 = 10;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        int n11 = c - 48;
                        n9 += n11;
                        n7 += SerialNumberUtil.BitLen(n6, n11);
                        continue block5;
                    }
                    default: {
                        ++n9;
                    }
                }
            }
            n3 = n7;
            n7 = 0;
            for (n10 = 0; n10 < sNStructDefArray.length; ++n10) {
                n7 += sNStructDefArray[n10].bitLen;
            }
            n4 = n7;
            n5 = sNDef.bytesLen * 8;
            n = n8;
            n2 = sNDef.bytesLen;
        }

        static {
            alphaSNStructDef = new SNStructDef[]{new SNStructDef(3, "productCode", 8), new SNStructDef(3, "version", 8), new SNStructDef(3, "reserved", 4), new SNStructDef(3, "maxrequests", 10), new SNStructDef(3, "expiremonth", 8), new SNStructDef(2, "womacosx", 1), new SNStructDef(2, "wowinnt", 1), new SNStructDef(2, "woplaceholder", 1), new SNStructDef(2, "wounix", 1), new SNStructDef(2, "multithreading", 1), new SNStructDef(2, "loadbalancing", 1), new SNStructDef(3, "locationCode", 8), new SNStructDef(3, "serialNumber", 20), new SNStructDef(5, "check", 20)};
            alphaSNDef = new SNDef(0, alphaSNStructDef, "D1-A4-D3-A4-D3-A4-D3-A1", 40);
            finalSNStructDef = new SNStructDef[]{new SNStructDef(6, "serialNumberVersion", 4), new SNStructDef(3, "productCode", 8), new SNStructDef(3, "version", 8), new SNStructDef(3, "reserved", 4), new SNStructDef(3, "maxrequests", 10), new SNStructDef(3, "expiremonth", 8), new SNStructDef(2, "womacosx", 1), new SNStructDef(2, "wowinnt", 1), new SNStructDef(2, "woplaceholder", 1), new SNStructDef(2, "wounix", 1), new SNStructDef(2, "multithreading", 1), new SNStructDef(2, "loadbalancing", 1), new SNStructDef(3, "locationCode", 8), new SNStructDef(4, "serialNumber", 20), new SNStructDef(5, "check", 20), new SNStructDef(3, "station", 8)};
            finalSNDef = new SNDef(1, finalSNStructDef, "A1-D3-A3-D3-A3-D3-A3-D3-A3-D3", 40);
            acm_randseed = 1L;
        }
    }
}

