/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOInput;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;

public class WOCheckBoxList
extends WOInput {
    private WOAssociation _list;
    private WOAssociation _item;
    private WOAssociation _index;
    private WOAssociation _selections;
    private WOAssociation _prefix;
    private WOAssociation _suffix;
    private WOAssociation _displayString;
    private WOAssociation _escapeHTML;
    private boolean _defaultEscapeHTML;
    private boolean _loggedSlow = false;

    public WOCheckBoxList(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super(string, nSDictionary, wOElement);
        NSMutableDictionary nSMutableDictionary = nSDictionary.mutableClone();
        this._list = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"list");
        this._item = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"item");
        this._index = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"index");
        this._selections = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"selections");
        this._prefix = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"prefix");
        this._suffix = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"suffix");
        this._displayString = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"displayString");
        this._escapeHTML = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"escapeHTML");
        if (this._displayString == null) {
            this._displayString = (WOAssociation)nSMutableDictionary.removeObjectForKey((Object)"value");
            this._defaultEscapeHTML = false;
        } else {
            this._defaultEscapeHTML = true;
        }
        if (this._list == null || (this._displayString != null || this._value != null) && (this._item == null || !this._item.isValueSettable()) || this._selections != null && !this._selections.isValueSettable()) {
            throw new IllegalArgumentException("WOCheckBoxList: Invalid attributes: 'list' must be present. 'item' must not be a constant if 'displayString' or 'value' is present. 'selections' must not be a constant if present.");
        }
    }

    public String toString() {
        return "" + super.toString() + " list: " + this._list + " item: " + this._item + " index: " + this._index + " selections: " + this._selections + " ";
    }

    public String elementName() {
        return "INPUT";
    }

    public void _fastTakeValuesFromRequestInContext(WORequest wORequest, WOContext wOContext) {
        WOComponent wOComponent = wOContext.component();
        if (this._selections != null && !this.disabledInComponent(wOComponent) && wOContext._wasFormSubmitted()) {
            String string = this.nameInContext(wOContext, wOComponent);
            NSArray nSArray = wORequest.formValuesForKey(string);
            int n = nSArray != null ? nSArray.count() : 0;
            NSMutableArray nSMutableArray = new NSMutableArray(n);
            if (n > 0) {
                int n2 = 0;
                Object object = this._list.valueInComponent(wOComponent);
                if (object instanceof NSArray) {
                    NSArray nSArray2 = (NSArray)object;
                    for (n2 = 0; n2 < n; ++n2) {
                        int n3 = Integer.valueOf(String.valueOf(nSArray.objectAtIndex(n2)));
                        nSMutableArray.addObject(nSArray2.objectAtIndex(n3));
                    }
                } else {
                    throw new IllegalArgumentException("<" + this.getClass().getName() + "> Evaluating 'list' binding returned a " + object.getClass().getName() + " when it should return either a com.webobjects.foundation.NSArray .");
                }
            }
            this._selections.setValue(nSMutableArray, wOComponent);
        }
    }

    public void _slowTakeValuesFromRequestInContext(WORequest wORequest, WOContext wOContext) {
        WOComponent wOComponent = wOContext.component();
        if (this._selections != null && !this.disabledInComponent(wOComponent) && wOContext._wasFormSubmitted()) {
            String string = this.nameInContext(wOContext, wOComponent);
            NSArray nSArray = wORequest.formValuesForKey(string);
            NSMutableArray nSMutableArray = new NSMutableArray(nSArray != null ? nSArray.count() : 8);
            if (nSArray != null && nSArray.count() != 0) {
                int n = 0;
                NSArray nSArray2 = NSArray.EmptyArray;
                Object object = this._list.valueInComponent(wOComponent);
                if (!(object instanceof NSArray)) {
                    throw new IllegalArgumentException("<" + this.getClass().getName() + "> Evaluating 'list' binding returned a " + object.getClass().getName() + " when it should return either a com.webobjects.foundation.NSArray.");
                }
                nSArray2 = (NSArray)object;
                int n2 = nSArray2.count();
                for (n = 0; n < n2; ++n) {
                    Object object2 = nSArray2.objectAtIndex(n);
                    this._item.setValue(object2, wOComponent);
                    Object object3 = this._value.valueInComponent(wOComponent);
                    if (object3 != null) {
                        if (!nSArray.containsObject((Object)object3.toString())) continue;
                        nSMutableArray.addObject(object2);
                        continue;
                    }
                    WOApplication.application().debugString(this.toString() + " 'value' evaluated to null in component " + wOComponent.toString() + ".\nUnable to select item " + object2);
                }
            }
            this._selections.setValue(nSMutableArray, wOComponent);
        }
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        if (this._value != null) {
            if (!this._loggedSlow) {
                WOApplication.application().debugString("<" + this.getClass().getName() + "> Warning: Avoid using the 'value' binding as it is much slower than omitting it, and it is just cosmetic.");
                this._loggedSlow = true;
            }
            this._slowTakeValuesFromRequestInContext(wORequest, wOContext);
        } else {
            this._fastTakeValuesFromRequestInContext(wORequest, wOContext);
        }
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object;
        int n = 0;
        int n2 = 0;
        WOComponent wOComponent = wOContext.component();
        boolean bl = this._escapeHTML != null ? this._escapeHTML.booleanValueInComponent(wOComponent) : this._defaultEscapeHTML;
        String string = this.nameInContext(wOContext, wOComponent);
        NSArray nSArray = NSArray.EmptyArray;
        NSArray nSArray2 = NSArray.EmptyArray;
        Object object2 = this._list.valueInComponent(wOComponent);
        if (!(object2 instanceof NSArray)) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Evaluating 'list' binding returned a " + object2.getClass().getName() + " when it should return either a com.webobjects.foundation.NSArray .");
        }
        nSArray = (NSArray)object2;
        Object object3 = object = this._selections != null ? this._selections.valueInComponent(wOComponent) : null;
        if (object != null) {
            nSArray2 = object instanceof NSArray ? (NSArray)object : new NSArray(object);
        }
        n = nSArray.count();
        for (n2 = 0; n2 < n; ++n2) {
            Object object4;
            String string2 = this._prefix != null ? String.valueOf(this._prefix.valueInComponent(wOComponent)) : null;
            String string3 = this._suffix != null ? String.valueOf(this._suffix.valueInComponent(wOComponent)) : null;
            String string4 = null;
            if (this._index != null) {
                this._index.setValue(new Integer(n2), wOComponent);
            }
            Object object5 = nSArray.objectAtIndex(n2);
            if (this._item != null && this._displayString != null) {
                this._item.setValue(object5, wOComponent);
                object4 = this._displayString.valueInComponent(wOComponent);
                if (object4 == null) {
                    string4 = object5.toString();
                    WOApplication.application().debugString(this.toString() + " 'displayString' evaluated to null in component " + wOComponent.toString() + ".\nDefaulting to description for " + string4);
                } else {
                    string4 = object4.toString();
                }
            } else {
                string4 = object5.toString();
            }
            wOResponse.appendContentString("<input name=\"");
            wOResponse.appendContentString(string);
            wOResponse.appendContentString("\" type=checkbox value=\"");
            object4 = null;
            if (this._value != null) {
                object4 = this._value.valueInComponent(wOComponent);
                if (object4 != null) {
                    wOResponse.appendContentHTMLAttributeValue(String.valueOf(object4));
                } else {
                    WOApplication.application().debugString(this.toString() + " 'value' evaluated to null in component " + wOComponent.toString() + ".\nDefaulting to index.");
                }
            }
            if (object4 == null) {
                wOResponse.appendContentString(String.valueOf(n2));
            }
            if (nSArray2.containsObject(object5)) {
                wOResponse.appendContentString("\" checked>");
            } else {
                wOResponse.appendContentCharacter('\"');
                wOResponse.appendContentCharacter('>');
            }
            if (string2 != null) {
                wOResponse.appendContentString(string2);
            }
            if (bl) {
                wOResponse.appendContentHTMLString(string4);
            } else {
                wOResponse.appendContentString(string4);
            }
            if (string3 == null) continue;
            wOResponse.appendContentString(string3);
        }
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        super.appendAttributesToResponse(wOResponse, wOContext);
    }

    public boolean appendStringAtLeftWithMapping(String string, char c) {
        return false;
    }

    public boolean appendStringAtRightWithMapping(String string, char c) {
        return false;
    }

    public boolean compactHTMLTags() {
        return false;
    }
}

