/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORedirect;
import com.webobjects.appserver._private.WOArchiveSupport;
import com.webobjects.appserver._private.WOBundle;
import com.webobjects.appserver._private.WOComponentReference;
import com.webobjects.appserver._private.WODeclarationFormatException;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WOEncodingDetector;
import com.webobjects.appserver._private.WOFileCacheManager;
import com.webobjects.appserver._private.WOHTMLFormatException;
import com.webobjects.appserver._private.WOParser;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class WOComponentDefinition {
    private String _name;
    private URL _pathURL;
    private String _url;
    private String _frameworkName;
    private String _language;
    private String _className;
    Class _componentClass;
    boolean _caching;
    boolean _isAwake;
    private WOElement _template;
    private URL _htmlPath;
    private URL _wodPath;
    private URL _wooPath;
    private boolean missingArchive;
    private NSDictionary _archive;
    private String _encoding;
    protected boolean _isStateless;
    private WODeployedBundle _bundle;
    private WOComponent _sharedInstance;
    private NSMutableArray _instancePool;
    private boolean _lockInstancePool;
    private boolean _hasBeenAccessed;
    private boolean _hasContextConstructor;
    private static final Object TheWOComponentConstructorLock;
    public static WOContext TheTemporaryContext;
    protected static boolean _IsEventLoggingEnabled;
    public static String InitEvent;

    public WOComponentDefinition(String string, URL uRL, String string2, String string3, String string4) {
        String string5;
        this._name = _NSStringUtilities.lastComponentInString((String)string, (char)'.');
        this._className = string;
        this._pathURL = uRL;
        this._url = string2;
        this._frameworkName = string3;
        this._language = string4;
        this._hasBeenAccessed = false;
        this._hasContextConstructor = false;
        this._isStateless = false;
        this._instancePool = new NSMutableArray();
        this._lockInstancePool = WOApplication.application().isConcurrentRequestHandlingEnabled();
        if (this._name != null && this._frameworkName != null) {
            string5 = NSBundle.bundleForName((String)string3);
            if (string5 != null) {
                this._componentClass = WOBundle.classForComponentNamedInBundle(this._className, (NSBundle)string5);
            }
            if (this._className.indexOf(46) == -1 && this._componentClass != null) {
                this._className = this._componentClass.getName();
            }
        }
        string5 = this._pathURL.toString();
        StringBuffer stringBuffer = new StringBuffer(string5.length() + this._name.length() + 6);
        stringBuffer.append(string5);
        stringBuffer.append('/');
        stringBuffer.append(this._name);
        stringBuffer.append(".html");
        String string6 = new String(stringBuffer);
        stringBuffer.setLength(0);
        stringBuffer.append(string5);
        stringBuffer.append('/');
        stringBuffer.append(this._name);
        stringBuffer.append(".xml");
        String string7 = new String(stringBuffer);
        stringBuffer.setLength(0);
        stringBuffer.append(string5);
        stringBuffer.append('/');
        stringBuffer.append(this._name);
        stringBuffer.append(".wod");
        String string8 = new String(stringBuffer);
        stringBuffer.setLength(0);
        stringBuffer.append(string5);
        stringBuffer.append('/');
        stringBuffer.append(this._name);
        stringBuffer.append(".woo");
        String string9 = new String(stringBuffer);
        this._htmlPath = null;
        this._wodPath = null;
        this._wooPath = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(string6);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (NSPathUtilities.fileExistsAtPathURL(uRL2)) {
            this._htmlPath = uRL2;
        } else {
            try {
                uRL2 = new URL(string7);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (NSPathUtilities.fileExistsAtPathURL((URL)uRL2)) {
                this._htmlPath = uRL2;
            }
        }
        try {
            uRL2 = new URL(string8);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (NSPathUtilities.fileExistsAtPathURL((URL)uRL2)) {
            this._wodPath = uRL2;
        }
        try {
            uRL2 = new URL(string9);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (NSPathUtilities.fileExistsAtPathURL((URL)uRL2)) {
            this._wooPath = uRL2;
        }
        if (this._htmlPath == null && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x4000004L) && (this._componentClass == null || !WORedirect.class.isAssignableFrom(this._componentClass))) {
            NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> No template found for component " + this._name + " at \"" + string5 + "\"."));
        }
        this._archive = null;
        this._encoding = null;
        this._template = null;
        this.setCachingEnabled(WOApplication.application().isCachingEnabled());
        this._isAwake = false;
        if (this._frameworkName == null) {
            this._bundle = WODeployedBundle.deployedBundle();
        } else {
            this._bundle = WODeployedBundle.deployedBundleForFrameworkNamed(this._frameworkName);
            if (this._bundle == null) {
                throw new IllegalStateException("Unable to find framework named \"" + this._frameworkName + "\".");
            }
        }
    }

    public void awake() {
        if (!this._isAwake) {
            this._isAwake = true;
            if (!this.isCachingEnabled()) {
                this.componentClass();
            }
        }
    }

    public void sleep() {
        if (this._isAwake) {
            this._isAwake = false;
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " name=" + this._name + " pathURL=" + this._pathURL + " url=" + this._url + " >";
    }

    public String name() {
        return this._name;
    }

    public URL pathURL() {
        return this._pathURL;
    }

    public String baseURL() {
        return this._url;
    }

    public String frameworkName() {
        return this._frameworkName;
    }

    public void setCachingEnabled(boolean bl) {
        this._caching = bl;
    }

    public boolean isCachingEnabled() {
        return this._caching;
    }

    public synchronized WOElement template() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.isCachingEnabled();
        if (!bl3) {
            bl = WOFileCacheManager.manager().hasPathURLBeenModified(this._htmlPath, WOComponentDefinition.class);
            if (this._htmlPath != null && !bl) {
                bl2 = WOFileCacheManager.manager().hasPathURLBeenModified(this._wodPath, WOComponentDefinition.class);
            }
        }
        String string = this.encoding();
        if (this._htmlPath != null && (this._template == null || bl || bl2)) {
            String string2;
            try {
                string2 = _NSStringUtilities.stringFromPathURL((URL)this._htmlPath, (String)string);
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = NSForwardException._originalThrowable((Throwable)runtimeException);
                if (throwable instanceof UnsupportedEncodingException) {
                    this._encoding = System.getProperty("file.encoding");
                    NSLog.err.appendln((Object)("<" + this.getClass().getName() + "> Unable to find Encoding Converter for '" + string + "' on this Java platform. Will use default encoding.\n" + runtimeException.toString()));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x800004L)) {
                        NSLog.debug.appendln((Throwable)runtimeException);
                    }
                    string2 = _NSStringUtilities.stringFromPathURL((URL)this._htmlPath, (String)this._encoding);
                }
                throw new NSForwardException(throwable, "<" + this.getClass().getName() + ": Errors reading HTML/XML file '" + this._htmlPath + "':\n" + throwable.toString());
            }
            if (!bl3) {
                WOFileCacheManager.manager().pathURLWasRead(this._htmlPath, WOComponentDefinition.class);
            }
            String string3 = this.readWoDeclaration(this._wodPath, string);
            if (string2 == null || string3 == null) {
                throw new IllegalStateException("<WOComponentDefinition>: problem parsing component " + this._name + " from path " + this._pathURL + ". Verify the existence of the proper .html and .wod files in the specified path.");
            }
            try {
                NSArray nSArray = this._language != null ? new NSArray((Object)this._language) : NSArray.EmptyArray;
                this._template = WOParser.templateWithHTMLAndDeclaration(string2, string3, nSArray);
            }
            catch (WODeclarationFormatException wODeclarationFormatException) {
                this._template = null;
                throw new NSForwardException((Throwable)wODeclarationFormatException, "<" + this.getClass().getName() + ": Error parsing template for Component : '" + NSPathUtilities.stringByDeletingLastPathComponent((String)this._htmlPath.toString()) + "':\n" + wODeclarationFormatException.toString());
            }
            catch (WOHTMLFormatException wOHTMLFormatException) {
                this._template = null;
                throw new NSForwardException((Throwable)wOHTMLFormatException, "<" + this.getClass().getName() + ": Error parsing template for Component : '" + NSPathUtilities.stringByDeletingLastPathComponent((String)this._htmlPath.toString()) + "':\n" + wOHTMLFormatException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._template = null;
                throw new NSForwardException((Throwable)classNotFoundException, "<" + this.getClass().getName() + ": Error parsing template for Component : '" + NSPathUtilities.stringByDeletingLastPathComponent((String)this._htmlPath.toString()) + "':\n" + classNotFoundException.toString());
            }
        }
        return this._template;
    }

    private String readWoDeclaration(URL uRL, String string) {
        String string2 = "";
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                byte[] byArray = _NSStringUtilities.bytesFromInputStream((InputStream)inputStream);
                if (byArray == null) {
                    throw new IllegalStateException("Unable to read .wod file at \"" + uRL + "\".");
                }
                if (!this.isCachingEnabled()) {
                    WOFileCacheManager.manager().pathURLWasRead(uRL, WOComponentDefinition.class);
                }
                if (byArray.length == 0) {
                    string2 = "";
                } else {
                    if (WOEncodingDetector.sharedInstance().couldBeUTF16(byArray, 0)) {
                        string = "Unicode";
                    }
                    string2 = new String(byArray, string);
                }
            }
            catch (IOException iOException) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)iOException);
            }
        }
        return string2;
    }

    public synchronized NSDictionary archive() {
        if (this._wooPath != null) {
            this._archive = WOArchiveSupport.parseArchiveAtPathURL(this._archive, this._wooPath, this.isCachingEnabled());
        }
        return this._archive;
    }

    public synchronized String encoding() {
        if (this._encoding == null) {
            NSDictionary nSDictionary = this.archive();
            if (nSDictionary != null) {
                this._encoding = (String)nSDictionary.objectForKey((Object)"encoding");
            }
            if (this._encoding == null) {
                this._encoding = System.getProperty("file.encoding");
            } else {
                String string = _NSUtilities._encodingNameFromObjectiveC((String)this._encoding);
                if (string != null) {
                    try {
                        byte[] byArray = "test".getBytes(string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = null;
                    }
                }
                if (string != null) {
                    this._encoding = string;
                } else if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x4000004L)) {
                    NSLog.debug.appendln((Object)("The text encoding: \"" + this._encoding + "\" for the component:" + this.toString() + " could not be found on this JavaVM platform."));
                }
            }
        }
        return this._encoding;
    }

    public WOComponentReference componentReferenceWithAssociations(NSDictionary nSDictionary, WOElement wOElement) {
        return new WOComponentReference(this._className, nSDictionary, wOElement);
    }

    private Class _componentClass() {
        Class clazz = _NSUtilities.classWithName((String)this._className);
        if (clazz == null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x4000004L)) {
                NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> WARNING: Unable to find component class named \"" + this._className + "\".  If this is not intended to be a classless component, check your framework settings and the contents of your classpath file (in the .woa's Contents/<PLATFORM_NAME> subdirectory)."));
            }
            clazz = WOComponent.class;
        } else if (!WOComponent.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Class '" + this._className + "' exists but is not a subclass of WOComponent.");
        }
        return clazz;
    }

    public Class componentClass() {
        if (this._componentClass == null) {
            this._componentClass = this._componentClass();
        }
        return this._componentClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WOComponent _componentInstanceInContext(WOContext wOContext) {
        Object object;
        Object object2;
        Class clazz = this.componentClass();
        WOComponent wOComponent = null;
        if (wOContext == null) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Attempt to create component instance without a WOContext object.");
        }
        Class[] classArray = new Class[]{WOContext.class};
        Object[] objectArray = new Object[]{wOContext};
        if (clazz == WOComponent.class) {
            wOContext._setComponentName(this._className);
        }
        wOContext._setTempComponentDefinition(this);
        WOComponent.Event event = null;
        if (_IsEventLoggingEnabled) {
            event = (WOComponent.Event)EOEventCenter.newEventOfClass((Class)WOComponent.Event.class, (String)InitEvent);
            EOEventCenter.markStartOfEvent((EOEvent)event, (Object)this._name);
            event.setComponentName(this._name);
        }
        if (!this._hasBeenAccessed) {
            try {
                wOComponent = (WOComponent)_NSUtilities.instantiateObject((Class)clazz, (Class[])classArray, (Object[])objectArray, (boolean)true, (boolean)WOApplication.application().isDebuggingEnabled());
                this._hasContextConstructor = true;
            }
            catch (RuntimeException runtimeException) {
                if (NSForwardException._originalThrowable((Throwable)runtimeException) instanceof NoSuchMethodException) {
                    object2 = TheWOComponentConstructorLock;
                    synchronized (object2) {
                        TheTemporaryContext = wOContext;
                        wOComponent = (WOComponent)_NSUtilities.instantiateObject((Class)clazz, null, null, (boolean)true, (boolean)WOApplication.application().isDebuggingEnabled());
                        TheTemporaryContext = null;
                        this._hasContextConstructor = false;
                    }
                }
                throw runtimeException;
            }
        } else if (this._hasContextConstructor) {
            wOComponent = (WOComponent)_NSUtilities.instantiateObject((Class)clazz, (Class[])classArray, (Object[])objectArray, (boolean)true, (boolean)WOApplication.application().isDebuggingEnabled());
        } else {
            object = TheWOComponentConstructorLock;
            synchronized (object) {
                TheTemporaryContext = wOContext;
                wOComponent = (WOComponent)_NSUtilities.instantiateObject((Class)clazz, null, null, (boolean)true, (boolean)WOApplication.application().isDebuggingEnabled());
                TheTemporaryContext = null;
            }
        }
        if (wOComponent.context() == null) {
            throw new IllegalStateException("<" + this.getClass().getName() + "> Component named \"" + this._name + "\" was improperly initialized.  It appears that the initialization method of this component did not call super(aContext).");
        }
        if (event != null) {
            if (wOComponent.isEventLoggingEnabled() && (wOContext.component() == null || wOContext.component().isEventLoggingEnabled())) {
                String string = wOComponent.name();
                event.setInfo(string);
                event.setComponentName(string);
                if (object != null) {
                    object2 = null;
                    for (object = wOComponent.parent(); object != null; object = ((WOComponent)object).parent()) {
                        object2 = object;
                    }
                    event.setPageName(((WOComponent)object2).name());
                } else {
                    event.setPageName(string);
                }
            } else {
                EOEventCenter.cancelEvent((EOEvent)event);
            }
        }
        return wOComponent;
    }

    public boolean isStateless() {
        return this._isStateless;
    }

    private WOComponent _sharedInstanceInContext(WOContext wOContext) {
        WOComponent wOComponent = null;
        if (this._sharedInstance != null) {
            wOComponent = this._sharedInstance;
            this._sharedInstance = null;
        } else if (this._instancePool.count() > 0) {
            wOComponent = (WOComponent)this._instancePool.lastObject();
            this._instancePool.removeLastObject();
        } else {
            wOComponent = this._componentInstanceInContext(wOContext);
        }
        return wOComponent;
    }

    private void checkInComponentInstance(WOComponent wOComponent) {
        if (this._sharedInstance == null) {
            this._sharedInstance = wOComponent;
        } else {
            this._instancePool.addObject((Object)wOComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _checkInComponentInstance(WOComponent wOComponent) {
        if (this._lockInstancePool) {
            NSMutableArray nSMutableArray = this._instancePool;
            synchronized (nSMutableArray) {
                this.checkInComponentInstance(wOComponent);
            }
        } else {
            this.checkInComponentInstance(wOComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent componentInstanceInContext(WOContext wOContext) {
        WOComponent wOComponent = null;
        if (!this._hasBeenAccessed) {
            wOComponent = this._componentInstanceInContext(wOContext);
            this._isStateless = wOComponent.isStateless();
            this._hasBeenAccessed = true;
        } else if (this._isStateless) {
            if (this._lockInstancePool) {
                NSMutableArray nSMutableArray = this._instancePool;
                synchronized (nSMutableArray) {
                    wOComponent = this._sharedInstanceInContext(wOContext);
                }
            } else {
                wOComponent = this._sharedInstanceInContext(wOContext);
            }
        } else {
            wOComponent = this._componentInstanceInContext(wOContext);
        }
        return wOComponent;
    }

    public void finishInitializingComponent(WOComponent wOComponent) {
        NSDictionary nSDictionary = this.archive();
        if (nSDictionary != null) {
            try {
                WOArchiveSupport.initializeObjectFromArchive(wOComponent, nSDictionary);
            }
            catch (RuntimeException runtimeException) {
                if (!(runtimeException instanceof NSForwardException)) {
                    throw new NSForwardException((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    public URL pathURLForResourceNamed(String string, String string2, NSArray nSArray) {
        String string3 = string2 == null || string2.length() == 0 ? "" : (string2.charAt(0) == '.' ? string2 : ".".concat(string2));
        String string4 = string.concat(string3);
        return this._bundle.pathURLForResourceNamed(string, nSArray);
    }

    static {
        block2: {
            TheWOComponentConstructorLock = new Object();
            TheTemporaryContext = null;
            _IsEventLoggingEnabled = false;
            InitEvent = "init";
            try {
                EOEventCenter.registerEventClass((Class)WOComponent.Event.class, (EOEventCenter.EventRecordingHandler)new _EventLoggingEnabler());
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOComponentDefinition> Exception during static initialization - registering WOComponent.Event: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }

    public static class _EventLoggingEnabler
    implements EOEventCenter.EventRecordingHandler {
        public void setLoggingEnabled(boolean bl, Class clazz) {
            _IsEventLoggingEnabled = bl;
        }
    }
}

