/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODynamicElement;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;

public class WODynamicGroup
extends WODynamicElement {
    protected NSMutableArray _children;
    private static final WODynamicGroup _EmptyGroup = new WODynamicGroup(null, null, (NSMutableArray)null);

    public static WODynamicGroup EmptyGroup() {
        return _EmptyGroup;
    }

    public WODynamicGroup(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super(null, null, null);
        this._initChildrenFromTemplate(wOElement);
    }

    public WODynamicGroup(String string, NSDictionary nSDictionary, NSMutableArray nSMutableArray) {
        super(null, null, null);
        this._children = null;
        if (nSMutableArray != null && nSMutableArray.count() > 0) {
            this._children = nSMutableArray;
        }
    }

    private void _initChildrenFromTemplate(WOElement wOElement) {
        NSMutableArray nSMutableArray = null;
        if (wOElement != null) {
            if (wOElement.getClass() == WODynamicGroup.class) {
                nSMutableArray = ((WODynamicGroup)wOElement).childrenElements();
            } else {
                nSMutableArray = new NSMutableArray();
                nSMutableArray.addObject((Object)wOElement);
            }
        }
        this._children = null;
        if (nSMutableArray != null && nSMutableArray.count() > 0) {
            this._children = nSMutableArray;
        }
    }

    public NSMutableArray childrenElements() {
        return this._children;
    }

    protected void addChildElement(Object object) {
        if (this._children == null) {
            this._children = new NSMutableArray();
        }
        this._children.addObject(object);
    }

    public boolean hasChildrenElements() {
        return this._children != null && this._children.count() > 0;
    }

    public void takeChildrenValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        if (this.hasChildrenElements()) {
            int n = this._children.count();
            wOContext.appendZeroElementIDComponent();
            for (int i = 0; i < n; ++i) {
                WOElement wOElement = (WOElement)this._children.objectAtIndex(i);
                wOElement.takeValuesFromRequest(wORequest, wOContext);
                wOContext.incrementLastElementIDComponent();
            }
            wOContext.deleteLastElementIDComponent();
        }
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        this.takeChildrenValuesFromRequest(wORequest, wOContext);
    }

    public WOActionResults invokeChildrenAction(WORequest wORequest, WOContext wOContext) {
        WOActionResults wOActionResults = null;
        if (this.hasChildrenElements()) {
            int n = this._children.count();
            wOContext.appendZeroElementIDComponent();
            for (int i = 0; i < n && wOActionResults == null; ++i) {
                WOElement wOElement = (WOElement)this._children.objectAtIndex(i);
                wOActionResults = wOElement.invokeAction(wORequest, wOContext);
                wOContext.incrementLastElementIDComponent();
            }
            wOContext.deleteLastElementIDComponent();
        }
        return wOActionResults;
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        return this.invokeChildrenAction(wORequest, wOContext);
    }

    public void appendChildrenToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (this.hasChildrenElements()) {
            int n = this._children.count();
            wOContext.appendZeroElementIDComponent();
            for (int i = 0; i < n; ++i) {
                WOElement wOElement = (WOElement)this._children.objectAtIndex(i);
                wOElement.appendToResponse(wOResponse, wOContext);
                wOContext.incrementLastElementIDComponent();
            }
            wOContext.deleteLastElementIDComponent();
        }
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        this.appendChildrenToResponse(wOResponse, wOContext);
    }

    public String toString() {
        return "<" + this.getClass().getName() + " children:" + (this._children != null ? this._children.toString() : "null") + " >";
    }
}

