/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSUtilities;

public class WOEncodingDetector {
    protected static WOEncodingDetector WOEncodingDetectorInstance = null;
    private static final byte BOM_MOST_SIGNIFICATNT_BIT = -2;
    private static final byte BOM_LEAST_SIGNIFICATNT_BIT = -1;
    protected String fallbackEncoding = _NSUtilities.ISOLatin1StringEncoding;
    protected _NSDelegate delegate = new _NSDelegate(Delegate.class);

    private static boolean couldBeUTF16BigEndian(byte[] byArray, int n) {
        return byArray[n] == -2 && byArray[n + 1] == -1;
    }

    private static boolean couldBeUTF16SmallEndian(byte[] byArray, int n) {
        return byArray[n] == -1 && byArray[n + 1] == -2;
    }

    protected static boolean is7bitString(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if ((byArray[n] & 0x80) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected static boolean isISOSequence(byte[] byArray, int n, boolean bl) {
        switch ((char)byArray[1 + n]) {
            case '`': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'n': 
            case 'o': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
            case '!': 
            case '\"': 
            case '$': 
            case '(': {
                if (!bl || byArray[2 + n] < 32 && byArray[2 + n] == 128) break;
                return true;
            }
        }
        return false;
    }

    protected static boolean isISO2022JPString(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (byArray[n] == 27 && (n2 > 3 ? WOEncodingDetector.isISOSequence(byArray, n, true) : n2 > 2 && WOEncodingDetector.isISOSequence(byArray, n, false))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean isUnicodeString(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (byArray[n] == 0 && n2 != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static boolean isShiftJISString(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        while (n < n3) {
            --n3;
            if ((byArray[n] & 0x80) != 0 && (byArray[n] < 161 || byArray[n] > 223)) {
                byte by = (byte)((byArray[n] - (byArray[n] <= 159 ? 113 : 177)) * 2 + 1);
                byte by2 = byArray[n + 1];
                if (by > 127) {
                    by2 = (byte)(by2 - 1);
                }
                if (by2 >= 158) {
                    by = (byte)(by + 1);
                    by2 = (byte)(by2 - 125);
                } else {
                    by2 = (byte)(by2 - 31);
                }
                if (by >= 127 || by <= 31 || by2 >= 127 || by2 <= 31) {
                    return false;
                }
                ++n;
                --n3;
            }
            ++n;
        }
        return true;
    }

    protected static boolean isJapaneseEUCString(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        while (n3 >= 0) {
            --n3;
            if ((byArray[n] & 0x80) != 0) {
                byte by;
                if (byArray[n] == 255) {
                    return false;
                }
                if (byArray[n] == 142) {
                    by = byArray[n + 1];
                    if (by < 161 || by >= 224) {
                        return false;
                    }
                    ++n;
                    --n3;
                } else if (byArray[n] >= 160) {
                    if (n3 - 1 == 0 || (by = byArray[n + 1]) < 160 || by == 255) {
                        return false;
                    }
                    ++n;
                    --n3;
                } else {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private String _realGuessEncoding(byte[] byArray, int n, int n2) {
        if (WOEncodingDetector.is7bitString(byArray, n, n2)) {
            if (WOEncodingDetector.isISO2022JPString(byArray, n, n2)) {
                return "ISO2022JP";
            }
            return "ASCII";
        }
        if (WOEncodingDetector.isUnicodeString(byArray, n, n2)) {
            return "Unicode";
        }
        boolean bl = WOEncodingDetector.isJapaneseEUCString(byArray, n, n2);
        boolean bl2 = WOEncodingDetector.isShiftJISString(byArray, n, n2);
        if (bl && bl2) {
            if (this.delegate.respondsTo("encodingDetectorWillFallback")) {
                return (String)this.delegate.perform("encodingDetectorWillFallback", (Object)this);
            }
            return this.fallbackEncoding;
        }
        if (!bl && !bl2) {
            return this.fallbackEncoding;
        }
        return bl ? "EUC_JP" : "SJIS";
    }

    public static synchronized WOEncodingDetector sharedInstance() {
        if (WOEncodingDetectorInstance != null) {
            return WOEncodingDetectorInstance;
        }
        WOEncodingDetectorInstance = new WOEncodingDetector();
        return WOEncodingDetectorInstance;
    }

    public String fallbackEncoding() {
        return this.fallbackEncoding;
    }

    public void setFallbackEncoding(String string) {
        this.fallbackEncoding = string;
    }

    public Object delegate() {
        return this.delegate.delegate();
    }

    public void setDelegate(Object object) {
        this.delegate.setDelegate(object);
    }

    public String guessEncodingForData(NSData nSData) {
        NSMutableRange nSMutableRange = new NSMutableRange();
        byte[] byArray = nSData.bytesNoCopy(nSMutableRange);
        int n = nSMutableRange.location();
        int n2 = nSMutableRange.length();
        if (byArray == null || n2 == 0) {
            return "UnknownStringEncoding";
        }
        if (n2 == 1) {
            return _NSUtilities.ISOLatin1StringEncoding;
        }
        if (n2 == 2 && this.couldBeUTF16(byArray, n)) {
            return "Unicode";
        }
        return this._realGuessEncoding(byArray, n, n2);
    }

    public boolean couldBeUTF16(byte[] byArray, int n) {
        return WOEncodingDetector.couldBeUTF16BigEndian(byArray, n) || WOEncodingDetector.couldBeUTF16SmallEndian(byArray, n);
    }

    public static String detectEncodingWithDefaultEncoding(NSData nSData, String string) {
        WOEncodingDetector wOEncodingDetector = WOEncodingDetector.sharedInstance();
        String string2 = wOEncodingDetector.fallbackEncoding();
        wOEncodingDetector.setFallbackEncoding(string);
        String string3 = wOEncodingDetector.guessEncodingForData(nSData);
        wOEncodingDetector.setFallbackEncoding(string2);
        return string3;
    }

    public static interface Delegate {
        public String encodingDetectorWillFallback(WOEncodingDetector var1);
    }
}

