/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOMultipartIterator;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOInput;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WOFileUpload
extends WOInput {
    public static final String FILENAME_SUBKEY = "filename";
    public static final String MIMETYPE_SUBKEY = "mimetype";
    public static final String CONTENTTYPE_KEY = "content-type";
    public static final int DEFAULT_BUFFER_SIZE = 524288;
    WOAssociation _data;
    WOAssociation _filepath;
    WOAssociation _mimeType;
    WOAssociation _copyData;
    WOAssociation _inputStream;
    WOAssociation _outputStream;
    WOAssociation _bufferSize;
    WOAssociation _streamToFilePath;
    WOAssociation _overwrite;
    WOAssociation _finalFilePath;

    public WOFileUpload(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("input", nSDictionary, (WOElement)null);
        this._data = (WOAssociation)this._associations.removeObjectForKey((Object)"data");
        this._filepath = (WOAssociation)this._associations.removeObjectForKey((Object)"filePath");
        this._mimeType = (WOAssociation)this._associations.removeObjectForKey((Object)"mimeType");
        this._copyData = (WOAssociation)this._associations.removeObjectForKey((Object)"copyData");
        this._inputStream = (WOAssociation)this._associations.removeObjectForKey((Object)"inputStream");
        this._outputStream = (WOAssociation)this._associations.removeObjectForKey((Object)"outputStream");
        this._bufferSize = (WOAssociation)this._associations.removeObjectForKey((Object)"bufferSize");
        this._streamToFilePath = (WOAssociation)this._associations.removeObjectForKey((Object)"streamToFilePath");
        this._overwrite = (WOAssociation)this._associations.removeObjectForKey((Object)"overwrite");
        this._finalFilePath = (WOAssociation)this._associations.removeObjectForKey((Object)"finalFilePath");
        if (this._data == null && this._inputStream == null && this._outputStream == null && this._streamToFilePath == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> At least one of the '" + "data" + "', '" + "inputStream" + "', '" + "outputStream" + "', or '" + "streamToFilePath" + "' attributes must be specified.");
        }
        if (this._inputStream != null) {
            if (this._outputStream != null || this._data != null || this._streamToFilePath != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "inputStream" + "' attribute can not be used with the '" + "outputStream" + "', '" + "data" + "', or '" + "streamToFilePath" + "' attributes.");
            }
            if (!this._inputStream.isValueSettable()) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "inputStream" + "' attribute can not be a constant.");
            }
        }
        if (this._outputStream != null) {
            if (this._inputStream != null || this._data != null || this._streamToFilePath != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "outputStream" + "' attribute can not be used with the '" + "inputStream" + "', '" + "data" + "', or '" + "streamToFilePath" + "' attributes.");
            }
            if (!this._outputStream.isValueSettable()) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "outputStream" + "' attribute can not be a constant.");
            }
        }
        if (this._streamToFilePath != null && (this._outputStream != null || this._inputStream != null || this._data != null)) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "streamToFilePath" + "' attribute can not be used with the '" + "inputStream" + "', '" + "data" + "', or '" + "outputStream" + "' attributes.");
        }
        if (this._bufferSize != null && this._outputStream == null && this._streamToFilePath == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "bufferSize" + "' attribute must be used with either the'" + "outputStream" + "' or '" + "streamToFilePath" + "' attribute.");
        }
        if ((this._overwrite != null || this._finalFilePath != null) && this._streamToFilePath == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "overwrite" + "' and '" + "finalFilePath" + "' attributes must be used with the '" + "streamToFilePath" + "' attribute.");
        }
        if (this._data != null) {
            if (this._inputStream != null || this._outputStream != null || this._streamToFilePath != null) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "data" + "' attribute can not be used with the '" + "inputStream" + "', '" + "outputStream" + "', or '" + "streamToFilePath" + "' attributes.");
            }
            if (!this._data.isValueSettable()) {
                throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "data" + "' attribute can not be a constant.");
            }
        }
        if (this._filepath != null && !this._filepath.isValueSettable()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "filePath" + "' attribute is a constant.");
        }
        if (this._mimeType != null && !this._mimeType.isValueSettable()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "mimeType" + "' attribute is a constant.");
        }
        if (this._finalFilePath != null && !this._finalFilePath.isValueSettable()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> '" + "finalFilePath" + "' attribute is a constant.");
        }
    }

    protected String type() {
        return "file";
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        String string;
        WOComponent wOComponent = wOContext.component();
        String string2 = this.nameInContext(wOContext, wOComponent);
        NSArray nSArray = null;
        if (this._filepath != null) {
            string = string2 + "." + FILENAME_SUBKEY;
            nSArray = (NSArray)wORequest.formValues().objectForKey((Object)string);
            if (nSArray != null) {
                this._filepath.setValue(nSArray.objectAtIndex(0), wOContext.component());
            }
        }
        if (this._data != null && nSArray != null) {
            NSDictionary nSDictionary = wORequest.formValues();
            NSArray nSArray2 = (NSArray)nSDictionary.objectForKey((Object)string2);
            if (nSArray2 != null) {
                boolean bl = true;
                if (this._copyData != null) {
                    bl = this._copyData.booleanValueInComponent(wOComponent);
                }
                NSData nSData = null;
                try {
                    nSData = (NSData)nSArray2.objectAtIndex(0);
                }
                catch (ClassCastException classCastException) {
                    throw new ClassCastException("<WOFileUpload>: Value in request was of type '" + nSArray2.objectAtIndex(0).getClass().getName() + "' instead of NSData. Verify that the WOForm's 'enctype' binding is set to 'multipart/form-data'");
                }
                if (bl) {
                    nSData = new NSData(nSData);
                }
                this._data.setValue(nSData, wOComponent);
            }
            if (this._mimeType != null && (nSArray = (NSArray)nSDictionary.objectForKey((Object)(string = string2 + "." + MIMETYPE_SUBKEY))) != null) {
                this._mimeType.setValue(nSArray.objectAtIndex(0), wOContext.component());
            }
        } else {
            NSDictionary nSDictionary;
            Object object;
            WOMultipartIterator wOMultipartIterator = wORequest.multipartIterator();
            if (wOMultipartIterator == null) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                    NSLog.debug.appendln((Object)"<WOFileUpload>: Could not create WOMultipartIterator. If you have only one (1) WOForm on this page, verify that the WOForm's 'enctype' binding is set to 'multipart/form-data'");
                }
                return;
            }
            WOMultipartIterator.WOFormData wOFormData = wOMultipartIterator.nextFormData();
            while (wOFormData != null && !string2.equals(object = (nSDictionary = wOFormData.contentDispositionHeaders()).objectForKey((Object)"name"))) {
                wOFormData = wOMultipartIterator.nextFormData();
            }
            if (wOFormData == null) {
                throw new IllegalStateException("<" + this.getClass().getName() + "> No form data left for WOFileUpload!");
            }
            nSDictionary = wOFormData.contentDispositionHeaders();
            object = null;
            if (this._filepath != null && (object = (String)nSDictionary.objectForKey((Object)FILENAME_SUBKEY)) != null) {
                this._filepath.setValue(object, wOContext.component());
            }
            if (this._mimeType != null && (nSArray = (NSArray)wOFormData.headers().objectForKey((Object)CONTENTTYPE_KEY)) != null) {
                this._mimeType.setValue(nSArray.objectAtIndex(0), wOContext.component());
            }
            InputStream inputStream = wOFormData.formDataInputStream();
            if (object != null && ((String)object).length() > 0) {
                if (this._inputStream != null) {
                    this._inputStream.setValue(inputStream, wOContext.component());
                } else {
                    int n;
                    Object object2;
                    String string3;
                    OutputStream outputStream = null;
                    String string4 = null;
                    File file = null;
                    int n2 = 524288;
                    if (this._bufferSize != null && (string3 = this._bufferSize.valueInComponent(wOContext.component()).toString()) != null) {
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> Unable to parse 'bufferSize' binding: '" + string3 + "'."));
                        }
                    }
                    if (this._outputStream != null) {
                        outputStream = (OutputStream)this._outputStream.valueInComponent(wOContext.component());
                    } else if (this._streamToFilePath != null) {
                        if (this._finalFilePath != null) {
                            this._finalFilePath.setValue(null, wOContext.component());
                        }
                        if ((string4 = (String)this._streamToFilePath.valueInComponent(wOContext.component())) != null) {
                            try {
                                string3 = NSPathUtilities.stringByDeletingLastPathComponent((String)string4);
                                object2 = new File(string3);
                                if (object2 != null) {
                                    if (((File)object2).exists()) {
                                        if (!((File)object2).isDirectory()) {
                                            object2 = null;
                                        }
                                    } else if (!((File)object2).mkdirs()) {
                                        object2 = null;
                                    }
                                }
                                file = File.createTempFile(wOContext.session().sessionID(), null, (File)object2);
                                outputStream = new FileOutputStream(file);
                            }
                            catch (IOException iOException) {
                                throw new RuntimeException("Error creating temp file output stream: " + (file != null ? file.getPath() : "") + "\n" + iOException.getMessage());
                            }
                        }
                    }
                    if (outputStream != null) {
                        n = 0;
                        object2 = new byte[n2];
                        try {
                            while ((n = inputStream.read((byte[])object2)) != -1) {
                                outputStream.write((byte[])object2, 0, n);
                                if (n != -1) continue;
                            }
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException("Error writing to output stream: " + outputStream + "\n" + iOException);
                        }
                    } else {
                        throw new RuntimeException(" Could not create output stream. 'outputStream', or 'streamToFilePath' may have evaluated to null. No Upload performed.");
                    }
                    if (file != null) {
                        String string5;
                        n = this._overwrite != null ? (int)(this._overwrite.booleanValueInComponent(wOComponent) ? 1 : 0) : 0;
                        boolean bl = false;
                        int n3 = 1;
                        File file2 = new File(string4);
                        if (file2.exists()) {
                            NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> Attempt to Upload on file " + string4 + " that already exists..."));
                            n3 = n;
                        }
                        if (n3 != 0) {
                            bl = NSPathUtilities._overwriteFileWithFile((File)file2, (File)file);
                        }
                        String string6 = string5 = bl ? string4 : file.getPath();
                        if (!bl && this._finalFilePath == null) {
                            NSLog.debug.appendln((Object)("<" + this.getClass().getName() + "> Failed renaming temp file " + file.getPath() + " . It has not been deleted. You may want to set the attribute overwrite=true or the attribute finalFilePath to recover the tempFile name programmatically."));
                        }
                        if (this._finalFilePath != null) {
                            this._finalFilePath.setValue(string5, wOContext.component());
                        }
                    }
                }
            } else {
                if (this._inputStream != null) {
                    this._inputStream.setValue(null, wOContext.component());
                }
                if (this._finalFilePath != null) {
                    this._finalFilePath.setValue(null, wOContext.component());
                }
                byte[] byArray = new byte[128];
                try {
                    while (inputStream.read(byArray) != -1) {
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Error skipping empty file upload: " + iOException);
                }
            }
        }
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        if (this._inputStream != null && wOContext._isMultipleSubmitForm()) {
            throw new IllegalStateException("<" + this.getClass().getName() + "> The WOFileUpload dynamic element can not have an '" + "inputStream" + "' attribute when used inside a WOForm with 'multipleSubmit=true'. Either use the '" + "outputStream" + "' or '" + "streamToFilePath" + "' of WOFileUpload instead, or turn off multipleSubmit in the WOForm.");
        }
        return null;
    }

    protected void _appendValueAttributeToResponse(WOResponse wOResponse, WOContext wOContext) {
    }

    protected void _appendCloseTagToResponse(WOResponse wOResponse, WOContext wOContext) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" data=" + this._data);
        stringBuffer.append(" filepath=" + this._filepath);
        stringBuffer.append(" mimeType=" + this._mimeType);
        stringBuffer.append(" inputStream=" + this._inputStream);
        stringBuffer.append(" outputStream=" + this._outputStream);
        stringBuffer.append(" bufferSize=" + this._bufferSize);
        stringBuffer.append(" streamToFilePath=" + this._streamToFilePath);
        stringBuffer.append(" overwrite=" + this._overwrite);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

