/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOHTMLDynamicElement;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSDictionaryUtilities;
import java.util.Enumeration;

public class WOForm
extends WOHTMLDynamicElement {
    private WOAssociation _action;
    private WOAssociation _href;
    private WOAssociation _multipleSubmit;
    private WOAssociation _actionClass;
    private WOAssociation _queryDictionary;
    private NSDictionary _otherQueryAssociations;
    private WOAssociation _directActionName;

    public WOForm(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("form", nSDictionary, wOElement);
        this._otherQueryAssociations = _NSDictionaryUtilities.extractObjectsForKeysWithPrefix((NSMutableDictionary)this._associations, (String)"?", (boolean)true);
        if (this._otherQueryAssociations.count() == 0) {
            this._otherQueryAssociations = null;
        }
        this._action = (WOAssociation)this._associations.removeObjectForKey((Object)"action");
        this._href = (WOAssociation)this._associations.removeObjectForKey((Object)"href");
        this._multipleSubmit = (WOAssociation)this._associations.removeObjectForKey((Object)"multipleSubmit");
        this._actionClass = (WOAssociation)this._associations.removeObjectForKey((Object)"actionClass");
        this._queryDictionary = (WOAssociation)this._associations.removeObjectForKey((Object)"queryDictionary");
        this._directActionName = (WOAssociation)this._associations.removeObjectForKey((Object)"directActionName");
        if (this._associations.objectForKey((Object)"method") == null && this._associations.objectForKey((Object)"Method") == null && this._associations.objectForKey((Object)"METHOD") == null) {
            this._associations.setObjectForKey((Object)new WOConstantValueAssociation("post"), (Object)"method");
        }
        if (this._action != null && this._href != null || this._action != null && this._directActionName != null || this._href != null && this._directActionName != null || this._action != null && this._actionClass != null || this._href != null && this._actionClass != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + ">: At least two of these conflicting attributes are present: 'action', 'href', 'directActionName', 'actionClass'");
        }
        if (this._action != null && this._action.isValueConstant()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + ">: 'action' is a constant.");
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " action: " + (this._action != null ? this._action.toString() : "null") + " actionClass: " + (this._actionClass != null ? this._actionClass.toString() : "null") + " directActionName: " + (this._directActionName != null ? this._directActionName.toString() : "null") + " href: " + (this._href != null ? this._href.toString() : "null") + " multipleSubmit: " + (this._multipleSubmit != null ? this._multipleSubmit.toString() : "null") + " queryDictionary: " + (this._queryDictionary != null ? this._queryDictionary.toString() : "null") + " otherQueryAssociations: " + (this._otherQueryAssociations != null ? this._otherQueryAssociations.toString() : "null") + " >";
    }

    private void _enterFormInContext(WOContext wOContext) {
        wOContext.setInForm(true);
        if (wOContext.elementID().equals(wOContext.senderID())) {
            wOContext._setFormSubmitted(true);
        }
    }

    private void _exitFormInContext(WOContext wOContext) {
        wOContext.setInForm(false);
        wOContext._setFormSubmitted(false);
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        this._enterFormInContext(wOContext);
        super.takeValuesFromRequest(wORequest, wOContext);
        this._exitFormInContext(wOContext);
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        this._enterFormInContext(wOContext);
        wOContext._setActionInvoked(false);
        wOContext._setIsMultipleSubmitForm(this._multipleSubmit != null ? this._multipleSubmit.booleanValueInComponent(wOContext.component()) : false);
        WOActionResults wOActionResults = super.invokeAction(wORequest, wOContext);
        if (!wOContext._wasActionInvoked() && wOContext._wasFormSubmitted()) {
            if (this._action != null) {
                wOActionResults = (WOActionResults)this._action.valueInComponent(wOContext.component());
            }
            if (wOActionResults == null) {
                wOActionResults = wOContext.page();
            }
        }
        wOContext._setIsMultipleSubmitForm(false);
        this._exitFormInContext(wOContext);
        return wOActionResults;
    }

    private void _appendHiddenFieldsToResponse(WOResponse wOResponse, WOContext wOContext) {
        boolean bl = this._actionClass != null;
        NSDictionary nSDictionary = this.computeQueryDictionaryInContext(this._actionClass, this._directActionName, this._queryDictionary, bl, this._otherQueryAssociations, wOContext);
        if (nSDictionary.count() > 0) {
            Enumeration enumeration = nSDictionary.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = nSDictionary.objectForKey((Object)string);
                wOResponse._appendContentAsciiString("<input type=hidden");
                wOResponse._appendTagAttributeAndValue("name", string, false);
                wOResponse._appendTagAttributeAndValue("value", object.toString(), false);
                wOResponse._appendContentAsciiString(">\n");
            }
        }
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        wOContext.setInForm(true);
        super.appendToResponse(wOResponse, wOContext);
        wOContext.setInForm(false);
    }

    public void appendChildrenToResponse(WOResponse wOResponse, WOContext wOContext) {
        super.appendChildrenToResponse(wOResponse, wOContext);
        this._appendHiddenFieldsToResponse(wOResponse, wOContext);
    }

    protected void _appendCGIActionToResponse(WOResponse wOResponse, WOContext wOContext) {
        String string = this.computeActionStringInContext(this._actionClass, this._directActionName, wOContext);
        wOResponse._appendTagAttributeAndValue("action", wOContext.directActionURLForActionNamed(string, null), false);
    }

    public void appendAttributesToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object object = null;
        WOComponent wOComponent = wOContext.component();
        super.appendAttributesToResponse(wOResponse, wOContext);
        if (this._href != null) {
            object = this._href.valueInComponent(wOComponent);
        }
        if (this._directActionName != null || this._actionClass != null) {
            this._appendCGIActionToResponse(wOResponse, wOContext);
        } else if (object != null) {
            wOResponse._appendTagAttributeAndValue("action", object.toString(), false);
        } else if (this._href == null) {
            wOResponse._appendTagAttributeAndValue("action", wOContext.componentActionURL(), false);
        } else {
            NSLog.err.appendln((Object)"<WOForm> : action attribute evaluates to null");
        }
    }
}

